/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.HitInfo;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.Wire;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;

public class InvisibleConnectionSymbol
extends DiagramSymbol {
    @NonNull
    protected @NonNull List<@NonNull Wire> mInvWires = new ArrayList<Wire>();
    @NonNull
    Pin mConnectionPin;

    public InvisibleConnectionSymbol(@NonNull String id, @NonNull Pin connectionPin) {
        super(id, true);
        this.mConnectionPin = connectionPin;
    }

    protected void addConnection(@NonNull Point2D start, @NonNull Point2D end) {
        Wire w = new Wire(start, end);
        this.mInvWires.add(w);
        this.mGraphElems.add(w);
    }

    @Override
    public void draw(AffineTransform transform, PaintEvent e, DiagramStyleProvider styleProvider) {
        this.mGraphElems.forEach(x -> {
            if (!this.mInvWires.contains(x)) {
                x.draw(transform, e, styleProvider);
            }
        });
    }

    public void merge(InvisibleConnectionSymbol output) {
        if (this.getId().equals(output.getId())) {
            output.getGraphElems().forEach(x -> this.addGraphElem((GraphicalElement)x));
            this.addConnection(this.mConnectionPin.mEndDS, output.mConnectionPin.mStartDS);
        }
    }

    @Override
    public @Nullable HitInfo computeHitInfo(@NonNull Point2D p) {
        return null;
    }

    public @NonNull Pin getInputPin() {
        return this.mConnectionPin;
    }

    @Override
    public @NonNull InvisibleConnectionSymbol makeCopy() {
        InvisibleConnectionSymbol copy = new InvisibleConnectionSymbol(this.mId, this.mConnectionPin.makeCopy());
        this.mInvWires.forEach(x -> copy.addConnection(x.getStartDS(), x.getEndDS()));
        this.mGraphElems.forEach(x -> {
            if (!this.mInvWires.contains(x)) {
                copy.addGraphElem((GraphicalElement)x);
            }
        });
        return copy;
    }
}

