/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagramsymbols.BoundingBox;
import com.nxp.swtools.clocks.ui.diagramsymbols.Color;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.ICollidable;
import com.nxp.swtools.clocks.ui.diagramsymbols.IDrawable;
import com.nxp.swtools.clocks.ui.diagramsymbols.LineStyle;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.swt.events.PaintEvent;

public abstract class GraphicalElement
implements ICollidable,
IDrawable {
    @NonNull
    BoundingBox mBoundingBoxDS;
    @NonNull
    LineStyle mBoundingBoxLineStyle;
    @NonNull
    protected final DrawState mDrawState = new DrawState();
    protected static long UUID_COUNTER = 0L;
    private final long mUUID = UUID_COUNTER++;

    public GraphicalElement() {
        Color color = new Color(255, 51, 204);
        this.mBoundingBoxLineStyle = new LineStyle(LineStyle.Style.DASH_LINE, 1, color);
        this.mBoundingBoxDS = new BoundingBox(new Point2D.Double(), new Point2D.Double());
    }

    public void update(@NonNull DrawState.State state) {
        this.mDrawState.update(state);
    }

    public void drawBB(@NonNull AffineTransform transform, @NonNull PaintEvent e) {
        this.mBoundingBoxDS.draw(transform, e, null, this.mBoundingBoxLineStyle);
    }

    protected abstract @NonNull GraphicalElement makeCopy();

    public abstract void applyTransform(@NonNull AffineTransform var1);

    @Override
    public boolean isHitBy(@NonNull Point2D p) {
        return this.mBoundingBoxDS.isHitBy(p);
    }

    public @NonNull BoundingBox getBoundingBoxDS() {
        return this.mBoundingBoxDS;
    }

    public static int[] unroll(@NonNull Point2D[] points) {
        int[] list = new int[2 * points.length];
        int i = 0;
        while (i < points.length) {
            list[2 * i] = (int)points[i].getX();
            list[2 * i + 1] = (int)points[i].getY();
            ++i;
        }
        return list;
    }

    public @Nullable Point2D getCenter() {
        Point2D center;
        if (this.mBoundingBoxDS.isValid() && this.isHitBy(center = this.mBoundingBoxDS.getCenterDS())) {
            return center;
        }
        return null;
    }

    public long getUUID() {
        return this.mUUID;
    }
}

