/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagramsymbols.Color;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public final class Font {
    @NonNull
    private String mFont;
    private int mHeight;
    private Style mStyle;
    @NonNull
    Color mColor;
    private @Nullable org.eclipse.swt.graphics.Color mPrevSWTColor;
    private @Nullable org.eclipse.swt.graphics.Font mPrevSWTFont;

    public Font(@NonNull String name, @NonNull Color color, int height) {
        this.mFont = name;
        this.mHeight = height;
        this.mStyle = Style.NORMAL;
        this.mColor = color;
    }

    public Font(@NonNull String name, int height) {
        this(name, new Color(0, 0, 0), height);
    }

    public void setColor(@NonNull Color color) {
        this.mColor = color;
    }

    public static void dispose(@Nullable org.eclipse.swt.graphics.Font font) {
        if (font != null && !font.isDisposed()) {
            font.dispose();
        }
    }

    public @NonNull org.eclipse.swt.graphics.Font getSWTFont() {
        return this.getSWTFont(this.mHeight);
    }

    public int getHeight() {
        return this.mHeight;
    }

    public @NonNull org.eclipse.swt.graphics.Font getSWTFont(int height) {
        switch (this.mStyle) {
            // Empty switch
        }
        org.eclipse.swt.graphics.Font f = new org.eclipse.swt.graphics.Font((Device)Display.getCurrent(), this.mFont, height, 0);
        return f;
    }

    public void set(@NonNull PaintEvent e, int newHeight) {
        this.mPrevSWTColor = e.gc.getBackground();
        e.gc.setForeground(this.mColor.getSWTColor());
        this.mPrevSWTFont = e.gc.getFont();
        e.gc.setFont(this.getSWTFont(newHeight));
    }

    public void unset(@NonNull PaintEvent e) {
        if (this.mPrevSWTColor != null && !this.mPrevSWTColor.isDisposed()) {
            assert (this.mPrevSWTColor != null);
            e.gc.setForeground(this.mPrevSWTColor);
        }
        Font.dispose(e.gc.getFont());
        if (this.mPrevSWTFont != null && !this.mPrevSWTFont.isDisposed()) {
            e.gc.setFont(this.mPrevSWTFont);
        }
    }

    public @NonNull Font makeCopy() {
        return new Font(this.mFont, this.mColor.makeCopy(), this.mHeight);
    }

    public static enum Style {
        NORMAL;

    }
}

