/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DrawState {
    private List<State> mStates = new ArrayList<State>();

    public void update(State state) {
        int stateGroupID = state.getGroupID();
        if (state.equals((Object)State.CLEAR) || state.equals((Object)State.CLEAR_KEEP_SPECIAL)) {
            Iterator<State> iterator = this.mStates.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getGroupID() >= stateGroupID) continue;
                iterator.remove();
            }
        } else {
            Iterator<State> iterator = this.mStates.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getGroupID() != stateGroupID) continue;
                iterator.remove();
            }
            this.mStates.add(state);
        }
    }

    public Collection<State> get() {
        return this.mStates;
    }

    public static enum State {
        APPEARANCE_ACTIVE(0),
        APPEARANCE_INACTIVE(0),
        APPEARANCE_NORMAL(0),
        STATUS_FINE(1),
        STATUS_ERROR(1),
        STATUS_DISABLED(1),
        STATUS_UNAVAILABLE(1),
        CLEAR(0x7FFFFFFE),
        SELECTED_FLAG(0x7FFFFFFD),
        BOUNDARY_SELECTED_FLAG(0x7FFFFFFD),
        CLEAR_KEEP_SPECIAL(0x7FFFFFFC),
        BOUNDARY_FLAG(Integer.MAX_VALUE);

        private int mGroupID;

        private State(int groupID) {
            this.mGroupID = groupID;
        }

        public int getGroupID() {
            return this.mGroupID;
        }
    }
}

