/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagramsymbols.BoundingBox;
import com.nxp.swtools.clocks.ui.diagramsymbols.Color;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.HitInfo;
import com.nxp.swtools.clocks.ui.diagramsymbols.LineStyle;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.PinConnection;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.swt.events.PaintEvent;

public class CompositeSymbol
extends DiagramSymbol {
    @NonNull
    protected List<DiagramSymbol> mParts = new ArrayList<DiagramSymbol>();
    protected boolean mDefinesBoundary;
    protected boolean mIsComponent;
    private boolean mRefreshPinDirections;

    public CompositeSymbol(@NonNull String ID, boolean definesBoundary, boolean isComponent, boolean isDiagramOnly) {
        super(ID, isDiagramOnly);
        this.mDefinesBoundary = definesBoundary;
        this.mIsComponent = isComponent;
    }

    @Override
    public void draw(@NonNull AffineTransform transform, @NonNull PaintEvent e, DiagramStyleProvider styleProvider) {
        if (this.mRefreshPinDirections) {
            this.refreshInputPinsDirections();
            this.mRefreshPinDirections = false;
        }
        this.mGraphElems.forEach(x -> x.draw(transform, e, styleProvider));
        this.mParts.forEach(x -> x.draw(transform, e, styleProvider));
        if (this.mOutputFreq != null) {
            this.mOutputFreq.draw(transform, e, styleProvider);
        }
        if (this.mScale != null) {
            this.mScale.draw(transform, e, styleProvider);
        }
    }

    public void addPart(@NonNull DiagramSymbol part) {
        this.mParts.add(part);
        this.updateBB(part.getBoundingBoxDS());
    }

    @Override
    public void addGraphElem(@NonNull GraphicalElement elem) {
        if (this.mDefinesBoundary) {
            elem.update(DrawState.State.BOUNDARY_FLAG);
        }
        if (elem instanceof Pin) {
            this.mRefreshPinDirections = true;
        }
        super.addGraphElem(elem);
    }

    public boolean definesBoundary() {
        return this.mDefinesBoundary;
    }

    public boolean isComponent() {
        return this.mIsComponent;
    }

    public void drawBB(@NonNull AffineTransform transform, @NonNull PaintEvent e) {
        LineStyle style = new LineStyle(LineStyle.Style.DASH_LINE, 1, new Color(255, 51, 180));
        this.mBoundingBoxDS.draw(transform, e, null, style);
        this.calculateMaxBoundingBoxDS().draw(transform, e, null, style);
        for (GraphicalElement elem : this.mGraphElems) {
            elem.getBoundingBoxDS().draw(transform, e, null, style);
        }
        if (this.mOutputFreq != null) {
            this.mOutputFreq.getBoundingBoxDS().draw(transform, e, null, style);
        }
        if (this.mScale != null) {
            this.mScale.getBoundingBoxDS().draw(transform, e, null, style);
        }
    }

    @Override
    public @Nullable HitInfo computeHitInfo(@NonNull Point2D p) {
        HitInfo result = this.mParts.stream().map(x -> x.computeHitInfo(p)).filter(Objects::nonNull).findFirst().orElse(null);
        if (result == null) {
            result = super.computeHitInfo(p);
        }
        return result;
    }

    public Collection<DiagramSymbol> getAllParts() {
        return Collections.unmodifiableCollection(this.mParts);
    }

    @Override
    public @NonNull BoundingBox calculateMaxBoundingBoxDS() {
        BoundingBox box = super.calculateMaxBoundingBoxDS();
        for (DiagramSymbol s : this.mParts) {
            box = box.merge(s.calculateMaxBoundingBoxDS());
        }
        return box;
    }

    @Override
    public CompositeSymbol makeCopy() {
        CompositeSymbol copy = new CompositeSymbol(this.mId, this.mDefinesBoundary, this.mIsComponent, this.mIsDiagramOnly);
        this.mGraphElems.forEach(x -> {
            if (!(x instanceof PinConnection)) {
                copy.addGraphElem(x.makeCopy());
            }
        });
        copy.findPinConnection();
        this.mParts.forEach(x -> copy.addPart(x.makeCopy()));
        if (this.mOutputFreq != null) {
            copy.setOutputFrequencyField(this.mOutputFreq.makeCopy());
        }
        if (this.mScale != null) {
            copy.setScaleField(this.mScale.makeCopy());
        }
        return copy;
    }

    public void findPinConnection() {
        List allPins = CollectionsUtils.getInstancesOf((Collection)this.mGraphElems, Pin.class).collect(Collectors.toList());
        List inputPins = allPins.stream().filter(Pin::isInput).collect(Collectors.toList());
        if (inputPins.size() > 1) {
            Pin outputPin = allPins.stream().filter(x -> !x.isInput()).findFirst().orElse(null);
            this.addGraphElem(new PinConnection(null, outputPin));
        }
    }

    public void refreshInputPinsDirections() {
        boolean vertical;
        List allPins = CollectionsUtils.getInstancesOf((Collection)this.mGraphElems, Pin.class).collect(Collectors.toList());
        List inputPins = allPins.stream().filter(Pin::isInput).collect(Collectors.toList());
        Pin outputPin = allPins.stream().filter(x -> !x.isInput()).findFirst().orElse(null);
        if (inputPins.isEmpty() || outputPin == null) {
            return;
        }
        Pin inputPin = (Pin)inputPins.get(0);
        Point2D inputPos = inputPin.getEndDS();
        Point2D outputPos = outputPin.getStartDS();
        if (inputPins.size() == 1) {
            vertical = inputPos.getY() - outputPos.getY() != 0.0;
        } else {
            Pin input2 = (Pin)inputPins.get(1);
            boolean bl = vertical = inputPos.getX() != input2.getEndDS().getX();
        }
        Pin.Direction directionToSet = vertical ? (inputPos.getY() - outputPos.getY() > 0.0 ? Pin.Direction.TO_UP : Pin.Direction.TO_DOWN) : (inputPos.getX() - outputPos.getX() > 0.0 ? Pin.Direction.TO_LEFT : Pin.Direction.TO_RIGHT);
        inputPins.stream().forEach(x -> x.setDir(directionToSet));
    }
}

