/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagram;

import com.nxp.swtools.clocks.ui.diagram.Junction;
import com.nxp.swtools.clocks.ui.diagram.Style;
import com.nxp.swtools.clocks.ui.diagramsymbols.Color;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.Fill;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.LineStyle;
import com.nxp.swtools.clocks.ui.diagramsymbols.Lock;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.PinConnection;
import com.nxp.swtools.clocks.ui.diagramsymbols.Polygon;
import com.nxp.swtools.clocks.ui.diagramsymbols.Rectangle;
import com.nxp.swtools.clocks.ui.diagramsymbols.Text;
import com.nxp.swtools.clocks.ui.diagramsymbols.Wire;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiagramStyleProvider {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(DiagramStyleProvider.class);
    private boolean IS_LOGGING_ON = true;
    @NonNull
    private static final Style UNSET_STYLE;
    @NonNull
    private static final Style JUNCTION_STYLE;
    @NonNull
    private static final Color VERY_LIGHT_GRAY;
    @NonNull
    private static final Color VERY_LIGHT_BLUE;
    @NonNull
    private static final Color LIGHTER_GRAY;
    @NonNull
    private static final Color LIGHTER_RED;
    @NonNull
    private static final Color LIGHT_GRAY;
    @NonNull
    private static final Color LIGHT_RED;
    @NonNull
    private static final Color DARK_BLUE;
    @NonNull
    private static final Color LIGHT_BLUE;
    @NonNull
    private static final Color DARK_GRAY;
    @NonNull
    private static final Color DARK_RED;
    @NonNull
    private static final Color BLACK;
    @NonNull
    private static final Color PINK;
    private int NARROW;
    private int MEDIUM;
    private int WIDE;
    private boolean drawSiganlDirection = true;

    static {
        VERY_LIGHT_GRAY = new Color(250, 250, 250);
        VERY_LIGHT_BLUE = new Color(242, 245, 253);
        LIGHTER_GRAY = new Color(225, 225, 225);
        LIGHTER_RED = new Color(240, 168, 168);
        LIGHT_GRAY = new Color(200, 200, 200);
        LIGHT_RED = new Color(240, 95, 95);
        DARK_BLUE = new Color(0, 0, 240);
        LIGHT_BLUE = new Color(160, 160, 240);
        DARK_GRAY = new Color(90, 90, 90);
        DARK_RED = new Color(170, 60, 60);
        BLACK = new Color(0, 0, 0);
        PINK = new Color(255, 20, 147);
        UNSET_STYLE = SWToolsProperties.isVerificationOn() ? new Style(new LineStyle(LineStyle.Style.SOLID, 5, PINK), new Fill(false, PINK)) : new Style(new LineStyle(LineStyle.Style.SOLID, 5, LIGHT_GRAY), new Fill(false, LIGHTER_GRAY));
        JUNCTION_STYLE = new Style(new LineStyle(LineStyle.Style.SOLID, 1, BLACK), new Fill(false, new Color(0, 0, 0)));
    }

    public DiagramStyleProvider() {
        this.setThickLines();
    }

    public @NonNull Style getStyle(@NonNull GraphicalElement element, DrawState state) {
        Style style = null;
        if (state.get().contains((Object)DrawState.State.BOUNDARY_FLAG)) {
            style = this.getBoundaryStyle(state.get());
        } else if (element instanceof Rectangle || element instanceof Polygon || element instanceof PinConnection) {
            style = this.getClockElementStyle(state.get());
        } else if (element instanceof Junction) {
            style = JUNCTION_STYLE;
        } else if (element instanceof Wire) {
            style = this.getWireStyle(state.get());
        } else if (element instanceof Pin) {
            style = this.getPinStyle(state.get());
        } else if (element instanceof Text) {
            style = DiagramStyleProvider.getFontStyle(state.get());
        } else if (element instanceof Lock) {
            style = this.getLockStyle();
        }
        if (style == null) {
            if (this.IS_LOGGING_ON) {
                Level level = SWToolsProperties.isVerificationOn() ? Level.WARNING : Level.FINE;
                LOGGER.log(level, DiagramStyleProvider.getMissingStyleLog(element, state));
            }
            style = UNSET_STYLE;
        }
        return style;
    }

    private static @NonNull Supplier<String> getMissingStyleLog(@NonNull GraphicalElement element, DrawState state) {
        return () -> String.format("No style defined for %s, state %s. Should be this element in diagram?", element.toString(), state.get().toString());
    }

    public void setLogging(boolean isOn) {
        this.IS_LOGGING_ON = isOn;
    }

    private Style getBoundaryStyle(@Nullable Collection<DrawState.State> states) {
        int lineWidth = this.NARROW;
        Fill fill = new Fill(true, BLACK);
        if (states != null && (states.contains((Object)DrawState.State.BOUNDARY_SELECTED_FLAG) || states.contains((Object)DrawState.State.SELECTED_FLAG))) {
            lineWidth = this.MEDIUM;
            fill = new Fill(false, VERY_LIGHT_BLUE);
        }
        Style style = new Style(new LineStyle(LineStyle.Style.DASH_LINE, lineWidth, BLACK), fill);
        return style;
    }

    private Style getLockStyle() {
        return new Style(new LineStyle(LineStyle.Style.SOLID, this.NARROW, BLACK), new Fill(false, BLACK));
    }

    private static Style getFontStyle(Collection<DrawState.State> states) {
        if (states.contains((Object)DrawState.State.STATUS_ERROR)) {
            return new Style(new LineStyle(LineStyle.Style.SOLID, 1, DARK_RED), new Fill(false, DARK_RED));
        }
        if (states.contains((Object)DrawState.State.STATUS_DISABLED)) {
            return new Style(new LineStyle(LineStyle.Style.SOLID, 1, DARK_GRAY), new Fill(false, DARK_GRAY));
        }
        if (states.contains((Object)DrawState.State.STATUS_UNAVAILABLE)) {
            return new Style(new LineStyle(LineStyle.Style.SOLID, 1, LIGHT_GRAY), new Fill(false, LIGHT_GRAY));
        }
        return JUNCTION_STYLE;
    }

    private @Nullable Style getPinStyle(Collection<DrawState.State> states) {
        Color fillColor = DiagramStyleProvider.UNSET_STYLE.Fill.getColor();
        Color lineColor = DiagramStyleProvider.UNSET_STYLE.LineStyle.getColor();
        int lineWidth = this.NARROW;
        if (states.contains((Object)DrawState.State.APPEARANCE_INACTIVE) && states.contains((Object)DrawState.State.STATUS_ERROR)) {
            lineColor = DARK_RED;
            lineWidth = states.contains((Object)DrawState.State.SELECTED_FLAG) ? this.WIDE : this.MEDIUM;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_NORMAL) && states.contains((Object)DrawState.State.STATUS_ERROR)) {
            lineColor = LIGHT_RED;
            lineWidth = states.contains((Object)DrawState.State.SELECTED_FLAG) ? this.WIDE : this.MEDIUM;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_ACTIVE) && states.contains((Object)DrawState.State.STATUS_ERROR)) {
            lineColor = DARK_RED;
            lineWidth = states.contains((Object)DrawState.State.SELECTED_FLAG) ? this.WIDE : this.MEDIUM;
        } else {
            Style wireStyle = this.getWireStyle(states);
            if (wireStyle != null) {
                wireStyle.isSignalDirectionEnabled = this.drawSiganlDirection;
            }
            return wireStyle;
        }
        return new Style(new LineStyle(LineStyle.Style.SOLID, lineWidth, lineColor), new Fill(false, fillColor), this.drawSiganlDirection);
    }

    private @Nullable Style getWireStyle(Collection<DrawState.State> states) {
        Color fillColor = DiagramStyleProvider.UNSET_STYLE.Fill.getColor();
        Color lineColor = DiagramStyleProvider.UNSET_STYLE.LineStyle.getColor();
        int lineWidth = this.NARROW;
        if (states.contains((Object)DrawState.State.APPEARANCE_INACTIVE) && states.contains((Object)DrawState.State.STATUS_FINE)) {
            lineColor = DARK_GRAY;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_INACTIVE) && states.contains((Object)DrawState.State.STATUS_ERROR)) {
            lineColor = LIGHT_RED;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_INACTIVE) && states.contains((Object)DrawState.State.STATUS_UNAVAILABLE)) {
            lineColor = LIGHTER_GRAY;
            lineWidth = this.NARROW;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_INACTIVE) && states.contains((Object)DrawState.State.STATUS_DISABLED)) {
            lineColor = LIGHT_GRAY;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_NORMAL) && states.contains((Object)DrawState.State.STATUS_FINE)) {
            lineColor = DARK_GRAY;
            lineWidth = this.MEDIUM;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_NORMAL) && states.contains((Object)DrawState.State.STATUS_ERROR)) {
            lineColor = LIGHT_RED;
            lineWidth = this.MEDIUM;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_NORMAL) && states.contains((Object)DrawState.State.STATUS_DISABLED)) {
            lineColor = LIGHT_GRAY;
            lineWidth = this.MEDIUM;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_ACTIVE) && states.contains((Object)DrawState.State.STATUS_FINE)) {
            lineColor = DARK_BLUE;
            lineWidth = this.MEDIUM;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_ACTIVE) && states.contains((Object)DrawState.State.STATUS_ERROR)) {
            lineColor = DARK_RED;
            lineWidth = this.MEDIUM;
        } else if (states.contains((Object)DrawState.State.APPEARANCE_ACTIVE) && states.contains((Object)DrawState.State.STATUS_DISABLED)) {
            lineColor = LIGHT_BLUE;
            lineWidth = this.MEDIUM;
        } else {
            return null;
        }
        if (states.contains((Object)DrawState.State.SELECTED_FLAG)) {
            lineWidth = this.WIDE;
        }
        return new Style(new LineStyle(LineStyle.Style.SOLID, lineWidth, lineColor), new Fill(false, fillColor));
    }

    private @Nullable Style getClockElementStyle(Collection<DrawState.State> states) {
        Color fillColor = DiagramStyleProvider.UNSET_STYLE.Fill.getColor();
        Color lineColor = DiagramStyleProvider.UNSET_STYLE.LineStyle.getColor();
        int lineWidth = 2;
        if (states.contains((Object)DrawState.State.STATUS_FINE) && states.contains((Object)DrawState.State.APPEARANCE_ACTIVE)) {
            lineWidth = this.MEDIUM;
            fillColor = VERY_LIGHT_GRAY;
            lineColor = DARK_BLUE;
        } else if (states.contains((Object)DrawState.State.STATUS_FINE)) {
            fillColor = VERY_LIGHT_GRAY;
            lineColor = DARK_GRAY;
        } else if (states.contains((Object)DrawState.State.STATUS_ERROR)) {
            fillColor = LIGHTER_RED;
            lineColor = DARK_RED;
        } else if (states.contains((Object)DrawState.State.STATUS_DISABLED)) {
            fillColor = LIGHTER_GRAY;
            lineColor = LIGHT_GRAY;
        } else if (states.contains((Object)DrawState.State.STATUS_UNAVAILABLE)) {
            fillColor = VERY_LIGHT_GRAY;
            lineColor = LIGHTER_GRAY;
        } else {
            return null;
        }
        Style style = new Style(new LineStyle(LineStyle.Style.SOLID, lineWidth, lineColor), new Fill(false, fillColor));
        return this.checkIfSelected(states, style);
    }

    private @NonNull Style checkIfSelected(Collection<DrawState.State> states, @NonNull Style style) {
        if (states.contains((Object)DrawState.State.SELECTED_FLAG)) {
            style.LineStyle.setThickness(this.WIDE);
        }
        return style;
    }

    public void setThinLines() {
        this.NARROW = 1;
        this.MEDIUM = 2;
        this.WIDE = 3;
    }

    public void setThickLines() {
        this.NARROW = 1;
        this.MEDIUM = 3;
        this.WIDE = 5;
    }

    public void toggleSignalDirectionDrawing() {
        this.drawSiganlDirection = !this.drawSiganlDirection;
    }
}

