/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.McuDescriptor;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.ClocksProfile;
import com.nxp.swtools.clocks.data.model.EmptyProfile;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.ClocksServiceProvider;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.diagramsymbols.TextField;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.controller.AController;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ConfigChangeReason;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.ISharedConfigurationListener;
import com.nxp.swtools.provider.configuration.SharedConfigurationAdapter;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.StorageConfigurationPreferences;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.registers.BitFieldInfo;
import com.nxp.swtools.validation.engine.GenericProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.engine.ValidationProblemsUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;

public class UiController
extends AController {
    @NonNull
    public static final String TOOL_NAME = "Clocks";
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(UiController.class);
    @NonNull
    protected IClocksProfile profile;
    @Nullable
    private ISharedConfigurationListener sharedConfigListener;
    @NonNull
    protected final ISharedConfiguration sharedConfig;
    private boolean inited;
    private boolean disposed;
    protected boolean enabled;
    @Nullable
    private String lastlyChangedSetting;
    @Nullable
    Display display;

    private UiController() {
        this.profile = new EmptyProfile(UtilsText.safeString((String)Messages.get().UiController_McuNotSelected));
        this.inited = false;
        this.disposed = false;
        this.enabled = true;
        this.sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        TextField.init();
    }

    protected synchronized void init() {
        if (this.inited || this.disposed) {
            throw new IllegalStateException("THe controller has already been initialized (or diposed)");
        }
        if (Rap.isActive()) {
            this.display = Display.getCurrent();
            if (this.display != null) {
                this.display.asyncExec(() -> this.registerClocksServiceListener());
            } else {
                LOGGER.warning("ClocksServiceProvider not registered. This can led to several refresh issues.");
            }
        } else if (!SWToolsPlatform.isRunningJUnitTest()) {
            this.registerClocksServiceListener();
        }
        this.loadProfileFromSharedConfig();
        this.sharedConfigListener = new SharedConfigurationAdapter(){
            private McuDescriptor lastConfigMcu = null;
            private String lastConfigBoard = null;
            private String lastConfigKit = null;

            public void configurationReloaded(@NonNull ISharedConfiguration sharedConfiguration, @NonNull ConfigChangeReason reason) {
                if (reason == ConfigChangeReason.UNDO_REDO && UiController.this.profile.toStorageProfile(null).equals((StorageTool)sharedConfiguration.getTools().getClock(), StorageTool.CompareMode.MEX_AND_YAML) && UiController.this.profile.isYamlEnabled() == sharedConfiguration.getPreferences().isYamlOutputEnabled()) {
                    return;
                }
                if (UiController.this.sharedConfig != sharedConfiguration) {
                    throw new IllegalArgumentException("Unexpected change of shared configuration");
                }
                StorageClocksTool clocks = UiController.this.sharedConfig.getTools().getClock();
                boolean bl = UiController.this.enabled = clocks == null || clocks.isEnabled();
                if (UiController.this.enabled) {
                    try {
                        UiController.this.loadProfileFromSharedConfig();
                    }
                    catch (IllegalStateException e) {
                        UiController.this.disableClocksTool();
                        LOGGER.log(Level.SEVERE, "Cannot obtain Processor: " + sharedConfiguration.getCommonConfig().getMcu() + ". Clocks tool will be disabled", e);
                    }
                } else {
                    UiController.this.disableClocksTool();
                }
                ToolEvent event = new ToolEvent.Builder(64).setOriginator((Object)this).build();
                UiController.this.fireListeners(event);
                this.lastConfigMcu = McuDescriptor.fromSharedConfig(UiController.this.sharedConfig.getCommonConfig());
                this.lastConfigBoard = UiController.this.sharedConfig.getCommonConfig().getBoard();
                this.lastConfigKit = UiController.this.sharedConfig.getCommonConfig().getKit();
            }

            public void commonConfigurationChanged(@NonNull ISharedConfiguration sharedConfiguration) {
                McuDescriptor descriptor = McuDescriptor.fromSharedConfig(sharedConfiguration.getCommonConfig());
                if (Objects.equals(descriptor, this.lastConfigMcu) && Objects.equals(this.lastConfigBoard, sharedConfiguration.getCommonConfig().getBoard()) && Objects.equals(this.lastConfigKit, sharedConfiguration.getCommonConfig().getKit())) {
                    return;
                }
                this.configurationReloaded(sharedConfiguration, ConfigChangeReason.UNKNOWN);
            }

            public void configurationChanged(ISharedConfiguration sharedConfiguration, IConfigChangeContext changeContext) {
                Object source = changeContext.getSource();
                if (source instanceof StorageConfigurationPreferences) {
                    UiController.this.profile.setYamlEnabled(((StorageConfigurationPreferences)source).isYamlOutputEnabled());
                    UiController.this.profile.regenerateCode();
                } else if (source instanceof StorageClocksTool && ((StorageClocksTool)source).isEnabled() != UiController.this.enabled) {
                    this.configurationReloaded(sharedConfiguration, ConfigChangeReason.UNKNOWN);
                }
            }
        };
        this.sharedConfig.addListener(this.sharedConfigListener);
        IEventListener uiControllerListener = new IEventListener(){

            public void handle(@NonNull Collection<@NonNull ToolEvent> events) {
                for (ToolEvent event : events) {
                    if (event.originator == this || UiController.this.profile instanceof EmptyProfile) continue;
                    this.handle(event);
                    break;
                }
            }

            public void handle(@NonNull ToolEvent event) {
                if (event.originator != this && !(UiController.this.profile instanceof EmptyProfile)) {
                    StorageClocksTool clock = UiController.this.profile.toStorageProfile(UiController.this.sharedConfig.getTools().getClock());
                    UiController.this.sharedConfig.getTools().setClock(clock);
                    UiController.this.setDirty(clock, UiController.this.getLastlyChangedSetting());
                }
            }
        };
        this.addListener(146, uiControllerListener);
        this.addListener(194, new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (SWToolsProperties.isHeadlessOn()) {
                    UiController.this.refreshAllProblems();
                } else {
                    UIJobHelper.runNowOrInJob(() -> UiController.this.refreshAllProblems(), (String)"Refresh clock problems", (Display)UiController.this.display);
                }
            }
        });
        this.inited = true;
    }

    void setDirty(@NonNull StorageClocksTool clock, @Nullable String label) {
        this.setDirty(this.sharedConfig, TOOL_NAME, clock, label, IConfigChangeContext.ConfigChangeType.TOOL_SETTING_CHANGE);
    }

    private void registerClocksServiceListener() {
        ISourceProvider provider;
        ISourceProviderService service;
        if (PlatformUI.isWorkbenchRunning() && (service = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class)) != null && (provider = service.getSourceProvider("com.nxp.swtools.clocks.isConfigurationRemovable")) instanceof ClocksServiceProvider) {
            this.addListener(246, new IEventListener(){

                public void handle(@NonNull ToolEvent event) {
                    ((ClocksServiceProvider)provider).updateConfigurationState();
                }
            });
        }
    }

    protected void loadProfileFromSharedConfig() {
        IClocksProfile profileLoc;
        StorageClocksTool clocks = this.sharedConfig.getTools().getClock();
        if (clocks == null) {
            profileLoc = ClocksProfile.createProfileForMcu(this.sharedConfig.getCommonConfig());
            IClocksConfig defConfig = profileLoc.createDefaultConfig();
            profileLoc.addConfig(defConfig);
            profileLoc.setActiveConfig(defConfig);
        } else {
            profileLoc = ClocksProfile.fromStorageProfile(clocks, this.sharedConfig.getCommonConfig());
        }
        this.setProfile(profileLoc);
        this.profile.regenerateCode();
        if (!(profileLoc instanceof EmptyProfile)) {
            StorageClocksTool newProfile = this.getProfile().toStorageProfile(this.sharedConfig.getTools().getClock());
            this.sharedConfig.getTools().setClock(newProfile);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean loadConfigurationFromBitFieldState(@NonNull Collection<@NonNull BitFieldInfo> bitFieldInfo, @Nullable String configName) {
        IClocksConfig activeConfig = this.profile.getActiveConfig();
        boolean createNew = configName != null && !configName.isEmpty();
        String activeConfigName = activeConfig != null ? activeConfig.getName() : this.profile.createUniqueConfigName();
        String name = createNew ? configName : activeConfigName;
        IClocksConfig config = ClocksProfile.fromBitFieldConfig(this.profile.getMcu(), this.profile, bitFieldInfo, UtilsText.safeString((String)name));
        @NonNull Set requirementProblems = (Set)config.getProblems().stream().filter(x -> x.getProblemType().equals((Object)ClocksProblem.Type.REQUIREMENT)).collect(CollectorsUtils.toSet());
        requirementProblems.forEach(x -> UserLogger.getInstance().warning(x.getMessage()));
        config.removeProblems(requirementProblems);
        if (createNew) {
            this.profile.addConfig(config);
        } else {
            this.profile.updateConfig(config);
        }
        this.profile.setActiveConfig(config);
        this.profile.regenerateCode();
        this.fireListeners(new ToolEvent.Builder(160).build());
        return true;
    }

    protected void disableClocksTool() {
        EmptyProfile profileLoc = new EmptyProfile(UtilsText.safeString((String)Messages.get().ClocksProfile_ToolDisabled));
        this.setProfile(profileLoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull UiController getInstance() {
        try {
            UiController controller = (UiController)((Object)SWTFactoryProxy.INSTANCE.getSingletonInstance(UiController.class));
            if (!controller.inited || controller.disposed) {
                UiController uiController = controller;
                synchronized (uiController) {
                    if (controller.disposed) {
                        throw new IllegalStateException(String.valueOf(UiController.class.getSimpleName()) + " has already been disposed");
                    }
                    if (!controller.inited) {
                        controller.init();
                    }
                }
            }
            return controller;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot obtain user-singleton instance of: " + UiController.class.getSimpleName(), e);
        }
    }

    public synchronized void dispose() {
        ISharedConfigurationListener listenerLoc = this.sharedConfigListener;
        if (listenerLoc != null) {
            this.sharedConfig.removeListener(listenerLoc);
        }
    }

    public @NonNull IClocksProfile getProfile() {
        return this.profile;
    }

    public void setProfile(@NonNull IClocksProfile profile) {
        this.profile = profile;
    }

    public @Nullable IClocksConfig tryCreateConfig(final @Nullable IClocksConfig original, final @Nullable String proposedName, final @Nullable String description, final boolean replaceIfNecessary) {
        if (!this.canAddConfig()) {
            return null;
        }
        return (IClocksConfig)CollectionsUtils.nullableOptionalGet((Optional)this.runTransaction(new Supplier<IClocksConfig>(){

            @Override
            public @Nullable IClocksConfig get() {
                boolean replacing;
                IClocksConfig newConfig = original == null ? UiController.this.profile.createDefaultConfig() : original.clone(original.getClocksModel());
                String finalName = proposedName;
                IClocksConfig oldConfig = (IClocksConfig)CollectionsUtils.nullableOptionalGet(UiController.this.profile.getConfigs().stream().filter(x -> x.getName().equals(proposedName)).findFirst());
                boolean bl = replacing = oldConfig != null && replaceIfNecessary;
                if (replacing && oldConfig != null) {
                    newConfig = UiController.this.profile.resetToDefaults(oldConfig);
                }
                if (finalName == null || UtilsText.isEmpty((String)finalName) || !UiController.this.isConfigNameUnique(finalName) && !replaceIfNecessary) {
                    finalName = UiController.this.profile.createUniqueConfigName();
                    GuiController.getInstance().getUserLogger().warning(MessageFormat.format(Messages.get().UiController_WarningRenamingConfig, proposedName, finalName), UiController.TOOL_NAME);
                }
                String finalDescription = UtilsText.safeString((String)description);
                newConfig.setName(finalName);
                newConfig.setDescription(finalDescription);
                newConfig.setCalledFromDefaultInit(false);
                if (!replacing) {
                    UiController.this.addAndOpenConfig(newConfig);
                }
                return newConfig;
            }
        }));
    }

    public boolean canAddConfig() {
        return this.profile.getConfigs().size() < 20;
    }

    void addAndOpenConfig(@NonNull IClocksConfig newConfig) {
        this.profile.addConfig(newConfig);
        this.profile.setActiveConfig(newConfig);
        this.profile.regenerateCode();
        ToolEvent event = new ToolEvent.Builder(160).build();
        this.fireListeners(event);
    }

    public void setConfigOfDefaultInit(@Nullable IClocksConfig config) {
        if (config == null || this.profile.getConfigs().contains(config)) {
            this.profile.getConfigs().forEach(x -> x.setCalledFromDefaultInit(false));
            if (config != null) {
                config.setCalledFromDefaultInit(true);
            }
            this.profile.regenerateCode();
            ToolEvent event = new ToolEvent.Builder(2).build();
            this.fireListeners(event);
        }
    }

    public @Nullable IClockElement getClockElementById(@NonNull String elmentId) {
        return this.profile.getMcu().getClockElement(elmentId);
    }

    public @Nullable IClocksConfig getConfigOfDefaultInit() {
        return (IClocksConfig)CollectionsUtils.findAny(this.profile.getConfigs(), x -> x.isCalledFromDefaultInit());
    }

    public boolean isConfigNameUnique(@NonNull String name) {
        for (IClocksConfig config : this.profile.getConfigs()) {
            if (!config.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public @Nullable String getLastlyChangedSetting() {
        return this.lastlyChangedSetting;
    }

    public void setLastlyChangedSetting(@NonNull String lastlyChangedSetting) {
        this.lastlyChangedSetting = lastlyChangedSetting;
    }

    public void findNearValueOrRestore(@NonNull ISetting setting, @NonNull IClocksConfig config, @Nullable Shell shell, @NonNull SettingValue value) {
        this.runTransaction(() -> SettingEditorHelper.findNearValueOrRestore(setting, config, null, shell, value));
    }

    static void checkGlobalProblems() {
        ArrayList<@NonNull GenericProblem> problems = new ArrayList<GenericProblem>();
        if (UiController.getInstance().getConfigOfDefaultInit() == null) {
            problems.add(new GenericProblem(TOOL_NAME, 0, UtilsText.safeString((String)Messages.get().GuiController_NoDefaultInitConfig), TOOL_NAME, TOOL_NAME, UtilsText.safeString((String)Messages.get().GuiController_NoDefaultInitConfig)));
        }
        ValidationEngineFactory.addAndRemoveProblems(null, null, problems);
    }

    static void refreshProblems(@NonNull IClocksConfig config) {
        ValidationEngineFactory.addAndRemoveProblems(null, null, config.getProblems());
    }

    void refreshAllProblems() {
        ValidationEngineFactory.deleteToolProblems((String)TOOL_NAME);
        if (this.isEnabled()) {
            UiController.checkGlobalProblems();
        }
        this.getProfile().getConfigs().forEach(x -> UiController.refreshProblems(x));
    }

    public static @NonNull Map<@NonNull String, @NonNull List<@NonNull IValidationProblem>> collectValidationProblemsOnClocksTool() {
        List<@NonNull String> respondsTo = Arrays.asList("ClockConfig", "ClockOutput");
        Predicate<@NonNull IValidationProblem> predicate = p -> respondsTo.contains(p.getDependency().getResourceType());
        Function<@NonNull IValidationProblem, @NonNull String> keyTransformer = p -> p.getDependency().getResourceId();
        return ValidationProblemsUtils.getValidationProblemsMap(predicate, keyTransformer);
    }
}

