/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.clocks.ui.table.SettingsTable;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.controller.shared.SharedController;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SettingsDialog
extends Dialog {
    @NonNull
    @NonNull Collection<@NonNull IEventListener> listeners = new ArrayList<IEventListener>();
    @NonNull
    @NonNull Collection<@NonNull IEventListener> sharedEventListeners = new ArrayList<IEventListener>();
    @Nullable
    final String id;
    @NonNull
    final GuiController guiController = GuiController.getInstance();

    private SettingsDialog(@NonNull Shell parentShell, @Nullable String id) {
        super(parentShell);
        this.id = id;
        this.guiController.getSettingsDialogHolder().put(id, this);
    }

    public static @NonNull SettingsDialog getFor(@Nullable String id, @NonNull Shell parentShell) {
        SettingsDialog dialog = GuiController.getInstance().getSettingsDialogHolder().get(id);
        if (dialog == null) {
            dialog = new SettingsDialog(parentShell, id);
        }
        return dialog;
    }

    public static int numOfOpened() {
        return GuiController.getInstance().getSettingsDialogHolder().getCount();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        final SettingsTable table = new SettingsTable(container, "settings_dialog", true, true);
        table.setValueChangeListener(new SettingValueChangeListener(table.getGrid()));
        table.setInput(this.guiController.createSettingsInput(this.id));
        Object listener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (!table.getGrid().isDisposed()) {
                    if ((event.type & 0x22) != 0) {
                        table.setInput(SettingsDialog.this.guiController.createSettingsInput(SettingsDialog.this.id));
                    } else if (event.originator != table.getGrid()) {
                        table.refresh();
                    }
                }
            }
        };
        int events = 50;
        this.guiController.addListener(events, (IEventListener)listener);
        this.listeners.add((IEventListener)listener);
        listener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                SettingsDialog.this.close();
            }
        };
        this.guiController.addListener(64, (IEventListener)listener);
        this.listeners.add((IEventListener)listener);
        SharedController.getInstance().addListener(2, listener);
        this.sharedEventListeners.add((IEventListener)listener);
        return container;
    }

    private @NonNull String getTitle() {
        IClockElement foundElement;
        String idLoc = this.id;
        IMcu mcu = this.guiController.getProfile().getMcu();
        IClockElement iClockElement = foundElement = idLoc == null ? null : mcu.getClockElement(idLoc);
        if (foundElement == null) {
            IElement iElement = foundElement = idLoc == null ? null : mcu.getClockComponent(idLoc);
            if (foundElement == null) {
                return mcu.getMcuDescriptor().getID();
            }
        }
        String elementText = String.format("%s [%s]", foundElement.getName(), foundElement.getID());
        if (foundElement instanceof ClockOutput) {
            elementText = MessageFormat.format(Messages.get().SettingsDialog_PathTo, elementText);
        }
        return UtilsText.safeString((String)elementText);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getTitle());
    }

    protected boolean isResizable() {
        return true;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public boolean close() {
        this.guiController.getSettingsDialogHolder().remove(this.id);
        Display display = Display.getCurrent();
        if (!display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (IEventListener listener : SettingsDialog.this.listeners) {
                        SettingsDialog.this.guiController.removeModelListener(listener);
                    }
                    for (IEventListener listener : SettingsDialog.this.sharedEventListeners) {
                        SharedController.getInstance().removeListener(listener);
                    }
                }
            });
        }
        return super.close();
    }

    public static class DialogHolder<T extends Dialog> {
        private Map<@Nullable String, @Nullable T> dialogs = new HashMap<String, T>();

        @Nullable T get(@Nullable String id) {
            return (T)((Dialog)this.dialogs.get(id));
        }

        void put(@Nullable String id, @Nullable T dialog) {
            this.dialogs.put(id, dialog);
        }

        void remove(@Nullable String id) {
            this.dialogs.remove(id);
        }

        int getCount() {
            return this.dialogs.size();
        }
    }
}

