/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.utils.controller.shared.SharedController;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SettingValueDialog
extends Dialog {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SettingValueDialog.class);
    @NonNull
    private final ISetting setting;
    @Nullable
    private final String message;
    @NonNull
    private final String error;
    @Nullable
    private Text text;
    @Nullable
    private ControlDecoration decorationError;
    @Nullable
    private SettingValue value;
    private static Map<@Nullable String, @Nullable SettingValueDialog> dialogs = new HashMap<String, SettingValueDialog>();
    @NonNull
    @NonNull Collection<@NonNull IEventListener> listeners = new ArrayList<IEventListener>();
    @NonNull
    @NonNull Collection<@NonNull IEventListener> sharedEventListeners = new ArrayList<IEventListener>();
    @NonNull
    final GuiController guiController = GuiController.getInstance();

    private SettingValueDialog(@NonNull Shell parentShell, @NonNull ISetting setting, @Nullable String message, @NonNull String errorText) {
        super(parentShell);
        this.message = message;
        this.error = errorText;
        this.setting = setting;
        dialogs.put(setting.getId(), this);
    }

    protected Control createDialogArea(Composite parent) {
        ControlDecoration decoration;
        Text textBox;
        Label label;
        Composite container = (Composite)super.createDialogArea(parent);
        Image errorImage = ToolsImages.getStatusDecoratorImg((int)2);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing += errorImage.getBounds().width;
        container.setLayout((Layout)layout);
        if (this.message != null) {
            label = new Label(container, 64);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            label.setText(this.message);
            label = new Label(container, 258);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        }
        label = new Label(container, 0);
        label.setText(this.setting.getName());
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        this.text = textBox = new Text(container, 2048);
        textBox.setTextLimit(20);
        textBox.setLayoutData((Object)new GridData(4, 4, true, false));
        textBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SettingValueDialog.this.hideErrorDecoration();
            }
        });
        SWTFactoryProxy.INSTANCE.setTestId((Widget)textBox, "clocksSetValueTextField");
        this.decorationError = decoration = new ControlDecoration((Control)textBox, 16512);
        decoration.setImage(errorImage);
        decoration.setDescriptionText(this.error);
        decoration.hide();
        IEventListener listener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                SettingValueDialog.this.close();
            }
        };
        this.guiController.addListener(64, listener);
        this.listeners.add(listener);
        SharedController.getInstance().addListener(2, listener);
        this.sharedEventListeners.add(listener);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)newShell, "clocksSetValueShell");
        newShell.setText(Messages.get().SettingValueDialog_Title);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2144);
        this.setBlockOnOpen(false);
    }

    protected void okPressed() {
        Text textBox = this.getTextBox();
        String selectedText = textBox.getText();
        if (selectedText != null) {
            IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
            if (activeConfig != null) {
                this.value = this.setting.parseUiValue(selectedText, activeConfig);
                if (this.value == null) {
                    this.showErrorDecoration();
                } else {
                    super.okPressed();
                }
            } else {
                LOGGER.severe("Active configuration is null.");
            }
        }
    }

    void showErrorDecoration() {
        this.getDecoration().show();
    }

    void hideErrorDecoration() {
        this.getDecoration().hide();
    }

    private @NonNull ControlDecoration getDecoration() {
        ControlDecoration decoration = this.decorationError;
        if (decoration == null) {
            throw new IllegalStateException("Decoration has not been initialized yet.");
        }
        return decoration;
    }

    private @NonNull Text getTextBox() {
        Text textBox = this.text;
        if (textBox == null) {
            throw new IllegalStateException("Text box has not been initialized yet.");
        }
        return textBox;
    }

    public @Nullable SettingValue getValue() {
        return this.value;
    }

    public static @NonNull SettingValueDialog getDialogForSetting(@NonNull Shell parentShell, @NonNull ISetting setting, @Nullable String message, @NonNull String errorText) {
        String id = setting.getId();
        SettingValueDialog dialog = dialogs.get(id);
        if (dialog == null) {
            dialog = new SettingValueDialog(parentShell, setting, message, errorText);
        }
        return dialog;
    }

    public boolean close() {
        dialogs.remove(this.setting.getId());
        this.guiController.getSettingsDialogHolder().remove(this.setting.getId());
        for (IEventListener listener : this.listeners) {
            this.guiController.removeModelListener(listener);
        }
        for (IEventListener listener : this.sharedEventListeners) {
            SharedController.getInstance().removeListener(listener);
        }
        return super.close();
    }
}

