/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class GlobalSettingsConfiguration {
    @NonNull
    GuiController guiController = GuiController.getInstance();
    @NonNull
    @NonNull Map<@NonNull AGlobalSetting, @NonNull InstantSearchList> combos = new HashMap<AGlobalSetting, InstantSearchList>();
    @NonNull
    @NonNull Set<@NonNull IEventListener> listeners = new HashSet<IEventListener>();
    @NonNull
    protected Composite combosComposite;

    public GlobalSettingsConfiguration(@NonNull Composite parent) {
        parent.setLayout((Layout)new RowLayout());
        this.combosComposite = parent;
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.combosComposite, "clocksGlobalSettings");
        this.fillCombosComposite(parent);
        this.resetComobosContent();
        this.addCombosChangeListener();
        this.registerValueChangeListeners();
        this.registerDisposeListener();
    }

    void fillCombosComposite(@NonNull Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.combos.clear();
        SettingsDB settingsDb = GuiController.getInstance().getProfile().getMcu().getSettings();
        ArrayList<@NonNull AGlobalSetting> globalSettings = new ArrayList<AGlobalSetting>(settingsDb.getGlobalSettings());
        int numOfProcessed = 0;
        for (AGlobalSetting setting : globalSettings) {
            if (numOfProcessed++ != 0) {
                Label separator = new Label(parent, 0);
                separator.setText("|");
            }
            Label title = new Label(parent, 0);
            title.setText(setting.getName());
            InstantSearchList combo = new InstantSearchList(parent, 2048);
            SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "comboBox_" + setting.getId());
            this.combos.put(setting, combo);
            title.setLayoutData((Object)new RowData());
        }
        this.addCombosChangeListener();
        this.resetComobosContent();
    }

    void updateComboState(@NonNull ISetting setting) {
        IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
        if (this.combos.containsKey(setting) && activeConfig != null) {
            SettingValue value = activeConfig.getSettingsConfig().getSettingValue(setting);
            @Nullable InstantSearchList combo = this.combos.get(setting);
            assert (combo != null);
            combo.select(value.getUiValue());
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)combo, setting.getToolTipText(activeConfig));
            combo.setEnabled(setting.isEnabled(activeConfig) && setting.isEditable(activeConfig));
            Color highlight = activeConfig.getSettingsConfig().isLastlyChanged(setting) ? combo.getDisplay().getSystemColor(7) : combo.getDisplay().getSystemColor(25);
            Color comboBg = setting.isValid(value, activeConfig) ? highlight : ToolsColors.SwToolsColors.ERROR_BG.getColor();
            combo.setBackground(comboBg);
            combo.setForeground(setting.isValid(value, activeConfig) ? combo.getDisplay().getSystemColor(21) : ToolsColors.SwToolsColors.ERROR_FG.getColor());
        }
    }

    void resetComobosContent() {
        for (Map.Entry<AGlobalSetting, InstantSearchList> settingCombo : this.combos.entrySet()) {
            InstantSearchList combo = settingCombo.getValue();
            AGlobalSetting setting = settingCombo.getKey();
            SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "comboBox_" + setting.toString());
            IClocksConfig clocksConfig = GuiController.getInstance().getProfile().getActiveConfig();
            if (clocksConfig == null) continue;
            List<SettingValue> settingValues = setting.getValues(clocksConfig);
            int size = settingValues == null ? 0 : settingValues.size();
            String[] values = new String[size];
            HashSet<@NonNull String> errorItems = new HashSet<String>();
            HashMap<String, String> itemToolTips = new HashMap<String, String>();
            int i = 0;
            while (i < size) {
                String value;
                assert (settingValues != null);
                SettingValue settingValue = settingValues.get(i);
                values[i] = value = settingValue.getUiValue();
                if (setting.hasConflicts(settingValue, clocksConfig)) {
                    errorItems.add(value);
                }
                String itemTooltip = setting.getToolTipText(settingValue, clocksConfig);
                itemToolTips.put(value, Text.replaceNewLinesWithSpace(itemTooltip));
                ++i;
            }
            combo.setItems(values);
            Image errorImage = ToolsImages.getStatusIcon((int)2);
            combo.setStatusItemProvider(item -> errorItems.contains(item) ? errorImage : null);
            itemToolTips.entrySet().forEach(x -> combo.addItemToolTip(UtilsText.safeString((String)((String)x.getKey())), (String)x.getValue()));
            this.updateComboState(setting);
        }
    }

    private void addCombosChangeListener() {
        for (final Map.Entry<AGlobalSetting, InstantSearchList> settingCombo : this.combos.entrySet()) {
            final @NonNull InstantSearchList combo = settingCombo.getValue();
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (combo.isDisposed()) {
                        return;
                    }
                    ISetting setting = (ISetting)settingCombo.getKey();
                    SettingEditorHelper.setValue(setting, combo.getText(), new SettingValueChangeListener(GlobalSettingsConfiguration.this.combos));
                    if (Rap.isActive()) {
                        combo.getDisplay().asyncExec(() -> GlobalSettingsConfiguration.this.resetComobosContent());
                    } else {
                        GlobalSettingsConfiguration.this.resetComobosContent();
                    }
                }
            });
        }
    }

    private void registerValueChangeListeners() {
        GuiController controller = GuiController.getInstance();
        IEventListener settingChangeListener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (event.originator != GlobalSettingsConfiguration.this.combos) {
                    GlobalSettingsConfiguration.this.resetComobosContent();
                }
            }
        };
        controller.addListener(34, settingChangeListener);
        this.listeners.add(settingChangeListener);
        IEventListener profileChangeListener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (event.originator != GlobalSettingsConfiguration.this.combos) {
                    GlobalSettingsConfiguration.this.fillCombosComposite(GlobalSettingsConfiguration.this.combosComposite);
                    GlobalSettingsConfiguration.this.layout();
                }
            }
        };
        controller.addListener(64, profileChangeListener);
        this.listeners.add(profileChangeListener);
    }

    private void registerDisposeListener() {
        Composite combosCompositeLoc = this.combosComposite;
        if (!combosCompositeLoc.isDisposed()) {
            combosCompositeLoc.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    GlobalSettingsConfiguration.this.dispose();
                }
            });
        }
    }

    public void dispose() {
        this.combos.clear();
        this.listeners.forEach(x -> this.guiController.removeModelListener((IEventListener)x));
    }

    void layout() {
        this.combosComposite.layout();
        this.combosComposite.pack();
        Composite parent = this.combosComposite.getParent();
        if (parent != null) {
            parent.layout();
        }
    }
}

