/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.sources.ISourcesContentProvider;
import java.util.Collection;
import java.util.Map;

public class ClocksSourcesProvider
implements ISourcesContentProvider {
    public @NonNull Collection<@NonNull ISourceFile> getContent() {
        ScriptResult lastWorkingResult = UiController.getInstance().getProfile().getLastWorkingGeneratedCode();
        return SourceFileProviderFactory.buildSourceFileList((Map)lastWorkingResult.getOpenedFiles());
    }

    public boolean isOutOfSync() {
        ScriptResult scriptResult = ClocksSourcesProvider.getScriptResult();
        return scriptResult.containsAnyError();
    }

    public @Nullable String getStatus() {
        String result = Messages.get().ClocksSourcesProvider_Status_CodeGenerated;
        ScriptResult scriptResult = ClocksSourcesProvider.getScriptResult();
        if (scriptResult.containsAnyError()) {
            result = Messages.get().ClocksSourcesProvider_Status_CodeGenerationFailed;
        } else if (!scriptResult.getWarnings().isEmpty()) {
            result = Messages.get().ClocksSourcesProvider_Status_CodeGeneratedWithWarnings;
        }
        return result;
    }

    public @Nullable String getErrorText() {
        return ClocksSourcesProvider.getScriptResult().getErrors();
    }

    public @Nullable String getWarningText() {
        return ClocksSourcesProvider.getScriptResult().getWarnings();
    }

    private static @NonNull ScriptResult getScriptResult() {
        return UiController.getInstance().getProfile().getGeneratedCode();
    }
}

