/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.resources;

import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.IProcessorFilterForSwTools;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ProcessorFilterForClocksTool
implements IProcessorFilterForSwTools {
    @NonNull
    private static final ProcessorFilterForClocksTool INSTANCE = new ProcessorFilterForClocksTool();
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ProcessorFilterForClocksTool.class);
    @NonNull
    private @NonNull List<@NonNull Triplet<@NonNull String, @NonNull Integer, @NonNull Integer>> requirements = new ArrayList<Triplet<String, Integer, Integer>>();

    private ProcessorFilterForClocksTool() {
        this.requirements.add((Triplet<String, Integer, Integer>)IProcessorFilterForSwTools.createRequirement((String)"package", (int)1, (int)0));
        this.requirements.add((Triplet<String, Integer, Integer>)IProcessorFilterForSwTools.createRequirement((String)"registers", (int)1, (int)0));
        this.requirements.add((Triplet<String, Integer, Integer>)IProcessorFilterForSwTools.createRequirement((String)"clocks_model", (int)1, (int)0));
        this.requirements.add((Triplet<String, Integer, Integer>)IProcessorFilterForSwTools.createRequirement((String)"clocks_scripts", (int)1, (int)0));
        this.requirements.add((Triplet<String, Integer, Integer>)IProcessorFilterForSwTools.createRequirement((String)"module_clocks", (int)1, (int)0));
    }

    public static boolean isSupported(@NonNull IMcuDescriptor descriptor) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(descriptor.getID(), descriptor.getSDKVersion());
        if (info == null) {
            LOGGER.warning("Cannot obtain Processor Master Tool Info for " + descriptor + ". MCU will be marked as unsupported.");
            return false;
        }
        return INSTANCE.isPartNumberSupported(info, descriptor.getPartNumber());
    }

    public static @NonNull List<@NonNull String> getMissingRequirements(@NonNull IMcuDescriptor descriptor) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(descriptor.getID(), descriptor.getSDKVersion());
        assert (info != null);
        return INSTANCE.getMissingRequirements(info, descriptor.getPartNumber(), derivatives);
    }

    public List<@NonNull Triplet<@NonNull String, @NonNull Integer, @NonNull Integer>> getRequirements() {
        return this.requirements;
    }

    public @NonNull String getToolId() {
        return "Clocks";
    }
}

