/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.resources;

import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.PEConfiguration;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.McuIdentification;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

public class DataDirectory {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(DataDirectory.class);

    public static @NonNull String getClocksJavaScriptDir(@NonNull IMcuDescriptor mcuDescriptor) {
        return String.valueOf(DataDirectory.getDataDir()) + File.separator + DataDirectory.getDBFile(mcuDescriptor, "clocks_scripts");
    }

    public static String getPeripheralSignalsFile(@NonNull IMcuDescriptor mcuDescriptor) {
        return String.valueOf(DataDirectory.getDataDir()) + File.separator + DataDirectory.getDBFile(mcuDescriptor, "module_clocks");
    }

    public static @NonNull String getMcuRelFile(@NonNull IMcuDescriptor mcuDescriptor) {
        return DataDirectory.getDBFile(mcuDescriptor, "clocks_model");
    }

    public static @NonNull String getClocksDataDir(@NonNull IMcuDescriptor mcuDescriptor) {
        File f = new File(String.valueOf(DataDirectory.getDataDir()) + File.separator + DataDirectory.getMcuRelFile(mcuDescriptor));
        String parent = f.getParent();
        if (parent == null) {
            LOGGER.warning("File '" + f + "' does not have a parent.");
            parent = "";
        }
        return parent;
    }

    protected static @NonNull String getDBFile(@NonNull IMcuDescriptor mcuDescriptor, @NonNull String fileType) {
        McuIdentification mcuIdentification = new McuIdentification(mcuDescriptor.getID(), mcuDescriptor.getPartNumber(), mcuDescriptor.getSDKVersion(), "", "");
        return DataDirectoryUtils.getDbFile((IMcuIdentification)mcuIdentification, (String)fileType);
    }

    public static @NonNull String getFontsDirectory() {
        return String.valueOf(Platform.isRunning() ? String.valueOf(PEConfiguration.getSystemDirectory()) + File.separator : "") + "resources" + File.separator + "fonts";
    }

    public static @NonNull String getDataDir() {
        return DataDirectoryUtils.getDataDir();
    }
}

