/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.handlers;

import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.script.ClocksProfileInfo;
import com.nxp.swtools.clocks.wizards.importWizard.ClocksSrcImporter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageToolBaseConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.provider.toolchainproject.IImportToolchainProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectInfo;
import com.nxp.swtools.utils.FunctionalGroupUtils;
import com.nxp.swtools.utils.scripting.FileYamlContent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ClocksToolProjectImport
implements IImportToolchainProject {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ClocksToolProjectImport.class);
    @NonNull
    private static final String CLOCK_CONFIG_C = "clock_config.c";

    public @NonNull String getToolId() {
        return "Clocks";
    }

    public IImportToolchainProject.PreparedImportStatus prepareImport(@NonNull IToolchainProjectInfo prjSrcProvider, @NonNull ISharedConfiguration targetConfig) {
        Path clockConfigRelPath = prjSrcProvider.findSourceFileRelPath(CLOCK_CONFIG_C);
        IImportToolchainProject.PreparedImportStatus preparedImportStatus = new IImportToolchainProject.PreparedImportStatus(IImportToolchainProject.PreparedImportStatus.ImportResult.NONE, Paths.get(CLOCK_CONFIG_C, new String[0]), null);
        if (clockConfigRelPath != null) {
            FileYamlContent<@NonNull ClocksProfileInfo, @NonNull StorageClocksConfiguration> content = ClocksToolProjectImport.parseYamlContent(prjSrcProvider, clockConfigRelPath);
            if (content != null) {
                ClocksToolProjectImport.selectProcessorFromYaml(targetConfig, content);
                preparedImportStatus = targetConfig.isEmpty() && content.getFunctions().isEmpty() ? new IImportToolchainProject.PreparedImportStatus(IImportToolchainProject.PreparedImportStatus.ImportResult.EMPTY_YAML, clockConfigRelPath, null) : new IImportToolchainProject.PreparedImportStatus(IImportToolchainProject.PreparedImportStatus.ImportResult.READY_FOR_IMPORT, clockConfigRelPath, null);
            } else {
                preparedImportStatus = new IImportToolchainProject.PreparedImportStatus(IImportToolchainProject.PreparedImportStatus.ImportResult.NO_YAML, clockConfigRelPath, MessageFormat.format(Messages.get().ClocksToolProjectImport_CannotParse, clockConfigRelPath));
            }
        }
        return preparedImportStatus;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull String fillTargetConfig(ISharedConfiguration targetConfig, FileYamlContent<@NonNull ClocksProfileInfo, @NonNull StorageClocksConfiguration> content) {
        String result = "";
        @NonNull List configs = content.getFunctions();
        if (configs.isEmpty()) {
            result = String.valueOf(UtilsText.safeString((String)Messages.get().ClocksToolProjectImport_CannotLoadProfileForProcessor)) + ((ClocksProfileInfo)content.getProfileInfo()).getMcuIdentification();
        } else {
            if (!ClocksToolProjectImport.validateNames(configs)) {
                result = UtilsText.safeString((String)Messages.get().ClocksToolProjectImport_NotValidNames);
            }
            StorageClocksTool newClocks = new StorageClocksTool();
            newClocks.setConfigurations(content.getFunctions());
            targetConfig.getTools().setClock(newClocks);
        }
        return result;
    }

    private static void selectProcessorFromYaml(ISharedConfiguration targetConfig, FileYamlContent<@NonNull ClocksProfileInfo, @NonNull StorageClocksConfiguration> content) {
        IMcuIdentification mcuIdentification = ((ClocksProfileInfo)content.getProfileInfo()).getMcuIdentification();
        targetConfig.setMcuIdentification(mcuIdentification);
    }

    private static @Nullable FileYamlContent<@NonNull ClocksProfileInfo, @NonNull StorageClocksConfiguration> parseYamlContent(@NonNull IToolchainProjectInfo prjSrcProvider, @NonNull Path clockConfigRelPath) {
        InputStream openFile;
        Object var4_6;
        Throwable throwable;
        FileYamlContent<@NonNull ClocksProfileInfo, @NonNull StorageClocksConfiguration> content = null;
        try {
            throwable = null;
            var4_6 = null;
            try {
                openFile = prjSrcProvider.openSourceFile(clockConfigRelPath);
                try {
                    if (openFile != null) {
                        content = ClocksSrcImporter.extractYaml(clockConfigRelPath.toString(), openFile, (IProgressMonitor)new NullProgressMonitor(), false);
                    }
                }
                finally {
                    if (openFile != null) {
                        openFile.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        if (content == null) {
            try {
                throwable = null;
                var4_6 = null;
                try {
                    openFile = prjSrcProvider.openSourceFile(clockConfigRelPath);
                    try {
                        if (openFile != null) {
                            content = ClocksSrcImporter.extractYaml(clockConfigRelPath.toString(), openFile, (IProgressMonitor)new NullProgressMonitor(), true);
                        }
                    }
                    finally {
                        if (openFile != null) {
                            openFile.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        return content;
    }

    public boolean importProject(@NonNull IToolchainProjectInfo prjSrcProvider, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IImportToolchainProject.PreparedImportStatus preparedImport, @NonNull ISharedConfiguration targetConfig, @NonNull IProgressMonitor monitor) {
        assert (IImportToolchainProject.PreparedImportStatus.ImportResult.READY_FOR_IMPORT.equals((Object)preparedImport.getResult()));
        assert (preparedImport.getSrcFilePaths().size() == 1);
        Path clockConfigRelPath = preparedImport.getSrcFilePath();
        monitor.beginTask("Import clocks from " + clockConfigRelPath, 1);
        FileYamlContent<@NonNull ClocksProfileInfo, @NonNull StorageClocksConfiguration> content = ClocksToolProjectImport.parseYamlContent(prjSrcProvider, clockConfigRelPath);
        if (content != null) {
            String resultMessage = ClocksToolProjectImport.fillTargetConfig(targetConfig, content);
            if (!resultMessage.isEmpty()) {
                LOGGER.severe(resultMessage);
            }
        } else {
            LOGGER.severe("Cannot parse yaml from: " + clockConfigRelPath);
            return false;
        }
        monitor.worked(1);
        monitor.done();
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean validateNames(@NonNull List<@NonNull StorageClocksConfiguration> configs) {
        @NonNull List names = (List)configs.stream().map(StorageToolBaseConfiguration::getName).collect(CollectorsUtils.toList());
        return names.stream().allMatch(x -> 1 == Collections.frequency(names, x) && FunctionalGroupUtils.isNameValid((String)x));
    }
}

