/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.expression;

import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.expression.ConfigContext;
import com.nxp.swtools.clocks.expression.DefaultContext;
import com.nxp.swtools.clocks.verification.ExpressionVerificator;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.BitFieldVariable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IResolvable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.OperatorType;
import com.nxp.swtools.common.utils.expression.ReverseConcatenationOperator;
import com.nxp.swtools.common.utils.expression.ReversionVariable;
import com.nxp.swtools.common.utils.expression.TopDownParser;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Expression
extends com.nxp.swtools.common.utils.expression.Expression {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(Expression.class);
    @NonNull
    public static final Expression EXPRESSION_TRUE = new Expression((IResolvable)TRUE);
    @NonNull
    public static final Expression EXPRESSION_FALSE = new Expression((IResolvable)FALSE);
    @NonNull
    private IContext context;
    @Nullable
    private ReversionVariable reversionVariable = null;

    public static @NonNull Expression create(@NonNull String expression) {
        Expression parsedExpression = new Expression(new TopDownParser().initAndParse(expression));
        return parsedExpression;
    }

    public static @NonNull Expression create(@NonNull String expression, @NonNull IContext context) {
        Expression parsedExpression = new Expression(new TopDownParser().initAndParse(expression), context);
        return parsedExpression;
    }

    public static @NonNull Expression create(@NonNull IResolvable mainResolvable, @NonNull IContext context) {
        Expression parsedExpression = new Expression(mainResolvable, context);
        return parsedExpression;
    }

    public static @NonNull Expression negate(@NonNull Expression expression, @NonNull IContext context) {
        return new Expression(OperatorType.NEGATION, context, expression);
    }

    public static @NonNull Expression negate(@NonNull Expression expression) {
        return Expression.negate(expression, expression.getContext());
    }

    public @Nullable Expression reverse() {
        ReversionVariable variable = new ReversionVariable((IValue)Value.valueOf((long)0L));
        @Nullable com.nxp.swtools.common.utils.expression.Expression reversed = super.reverse(variable);
        return reversed == null ? null : new Expression((IResolvable)reversed, this.context, variable);
    }

    Expression(@NonNull IResolvable mainResolvable) {
        this(mainResolvable, DefaultContext.getInstance());
    }

    Expression(@NonNull IResolvable mainResolvable, @NonNull IContext context) {
        super(mainResolvable);
        this.context = context;
        ExpressionVerificator.getInstance().addExpression(this);
    }

    Expression(@NonNull IResolvable mainResolvable, @NonNull IContext context, @Nullable ReversionVariable reversionVariable) {
        super(mainResolvable);
        this.context = context;
        this.reversionVariable = reversionVariable;
        ExpressionVerificator.getInstance().addExpression(this);
    }

    public Expression(@NonNull OperatorType type, @NonNull IContext context, Expression ... ex) {
        super(type, (com.nxp.swtools.common.utils.expression.Expression[])ex);
        this.context = context;
    }

    public @NonNull IValue resolve() {
        return this.resolve(this.context);
    }

    public @NonNull IValue resolve(@NonNull IClocksConfig config) {
        return this.resolve(new ConfigContext(this.context, config));
    }

    public @NonNull IValue resolve(@NonNull IValue defaultValue) {
        try {
            return this.resolve();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Not resolvable, default value is used", e);
            return defaultValue;
        }
    }

    public @NonNull IValue resolve(@NonNull IValue defaultValue, @NonNull IContext specificContext) {
        try {
            return this.resolve(specificContext);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Not resolvable, default value is used", e);
            return defaultValue;
        }
    }

    public @NonNull LongValues resolve(long reverseValue) {
        IResolvable firstConcat = this.getFirstConcatenation();
        ReversionVariable variable = this.reversionVariable;
        if (variable == null) {
            throw new UnsupportedOperationException("Expression is not reversed expression");
        }
        variable.setValue((IValue)Value.valueOf((long)reverseValue));
        if (firstConcat != null && firstConcat instanceof ReverseConcatenationOperator) {
            ReverseConcatenationOperator concatenationOperator = (ReverseConcatenationOperator)firstConcat;
            this.getMainResolvable().resolve(this.context);
            return new LongValues(concatenationOperator.getResult());
        }
        IValue result = this.getMainResolvable().resolve(this.context);
        if (result.getType() == IValue.Type.LONG) {
            return new LongValues(result.getLong());
        }
        LOGGER.log(Level.SEVERE, "Reverse resolving of an expresion failed - wrong return type");
        return new LongValues(new Long[0]);
    }

    public @NonNull IValue reverseResolveForSetting(long reverseValue) {
        ReversionVariable variable = this.reversionVariable;
        if (variable == null) {
            throw new UnsupportedOperationException("Expression is not reversed expression");
        }
        variable.setValue((IValue)Value.valueOf((long)reverseValue));
        return this.getMainResolvable().resolve(this.context);
    }

    public @NonNull List<@NonNull BitFieldVariable> getBitFields() {
        ArrayList<@NonNull BitFieldVariable> bitFields = new ArrayList<BitFieldVariable>();
        this.addBitFields(bitFields);
        return bitFields;
    }

    public @NonNull Collection<@NonNull String> getSettings() {
        HashSet<@NonNull E> settings = new HashSet();
        HashSet<@NonNull String> settingIDs = new HashSet<String>();
        this.addSettings(settings);
        settings.stream().filter(x -> !x.startsWith("$")).forEach(x -> {
            boolean bl = settingIDs.add(this.getContext().getSettingId(x));
        });
        return settingIDs;
    }

    public @NonNull IContext getContext() {
        return this.context;
    }
}

