/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.expression;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.ARegistersContext;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.processor.properties.PackageProperties;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;

public class DefaultContext
extends ARegistersContext {
    @NonNull
    private static final DefaultContext INSTANCE = new DefaultContext();

    private DefaultContext() {
    }

    public static @NonNull IContext getInstance() {
        return INSTANCE;
    }

    public @NonNull Object getSettingValue(@NonNull String variable) {
        ICommonConfig commonConfig = SharedConfigurationFactory.getSharedConfigurationSingleton().getCommonConfig();
        Object propertyValue = PackageProperties.getProperty((String)variable, (IMcuIdentification)commonConfig.getMcuIdentification());
        if (propertyValue != null) {
            return propertyValue;
        }
        IClocksProfile profile = UiController.getInstance().getProfile();
        IMcu mcu = profile.getMcu();
        ISetting setting = SettingProvider.getSettingById(variable, mcu);
        IClocksConfig activeConfig = profile.getActiveConfig();
        if (activeConfig == null || setting == null) {
            throw new IllegalStateException("Can not resolve setting: " + variable);
        }
        SettingValue value = activeConfig.getSettingsConfig().getSettingValue(setting);
        return Converter.convertToLRBS(value.getValue());
    }

    @Override
    public @NonNull IRegistersDatabaseAPI getRegisters() {
        return UiController.getInstance().getProfile().getMcu().getRegisters();
    }

    public @NonNull String getSettingId(@NonNull String settingName) {
        return settingName;
    }
}

