/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.expression;

import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.FunctionInvocation;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.utils.registers.BitFieldProvider;

public class BitFieldsContext
implements IContext {
    @Nullable
    private IContext bitFieldIdContext;
    @NonNull
    private @NonNull BitFieldElement @NonNull [] bitFields;
    @NonNull
    private LongValues bitFieldValues;
    @NonNull
    private IRegistersDatabaseAPI registersDb;

    public BitFieldsContext(@NonNull IRegistersDatabaseAPI registersDb, @NonNull BitFieldElement @NonNull [] bitFields, @NonNull LongValues bitFieldValues, @Nullable IContext bitFieldIdContext) {
        this.registersDb = registersDb;
        this.bitFields = bitFields;
        this.bitFieldValues = bitFieldValues;
        this.bitFieldIdContext = bitFieldIdContext;
    }

    public long getBitFieldValue(@NonNull String registerName, @NonNull String bitFieldName) {
        BitFieldElement bitFieldRequested = ClocksBitFieldProvider.getBitFieldById(this.getBitFieldId(registerName, bitFieldName), this.registersDb);
        int i = 0;
        while (i < this.bitFields.length) {
            BitFieldElement bitField = this.bitFields[i];
            if (bitField.equals(bitFieldRequested)) {
                return this.bitFieldValues.getValue(i);
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown bit-filed: " + BitFieldsContext.toString(registerName, bitFieldName));
    }

    public @NonNull Object getSettingValue(@NonNull String settingName) {
        throw new IllegalArgumentException("Not supported (yet?)!");
    }

    public int getBitFiledWidth(@NonNull String registerName, @NonNull String bitFieldName) {
        BitFieldElement bitFieldRequested = ClocksBitFieldProvider.getBitFieldById(this.getBitFieldId(registerName, bitFieldName), this.registersDb);
        BitFieldElement[] bitFieldElementArray = this.bitFields;
        int n = this.bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            BitFieldElement bitField = bitFieldElementArray[n2];
            if (bitField.equals(bitFieldRequested)) {
                return bitField.getBitField().getWidth();
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown bit-field: " + BitFieldsContext.toString(registerName, bitFieldName));
    }

    private static @NonNull String toString(@NonNull String registerName, @NonNull String bitFieldName) {
        return String.valueOf(registerName) + "[" + bitFieldName + "]";
    }

    public @NonNull IValue resolveFunction(@NonNull FunctionInvocation function, @NonNull IContext argContext) {
        return Value.valueOf((boolean)false);
    }

    public @NonNull String getBitFieldId(@NonNull String registerName, @NonNull String bitFieldName) {
        if (this.bitFieldIdContext != null) {
            return this.bitFieldIdContext.getBitFieldId(registerName, bitFieldName);
        }
        return BitFieldProvider.createBitFieldId((String)registerName, (String)bitFieldName);
    }

    public @NonNull String getSettingId(@NonNull String settingName) {
        if (this.bitFieldIdContext != null) {
            return this.bitFieldIdContext.getSettingId(settingName);
        }
        return settingName;
    }
}

