/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.dependencies;

import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.dependencies.IFeatureData;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;

public class ProblemResolveHelper {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ProblemResolveHelper.class);

    public static boolean isLocked(@NonNull ClocksProblem problem) {
        IClockElement elem = UiController.getInstance().getProfile().getMcu().getClockElement(problem.getResource());
        if (elem != null && elem instanceof ClockOutput) {
            IClocksConfig config = problem.getConfig();
            ISetting setting = elem.getOutputFrequencySetting();
            return config.getSettingsConfig().isLocked(setting) && setting.isUserLockable();
        }
        return false;
    }

    public static void unlock(@NonNull ClocksProblem problem) {
        IClockElement elem = UiController.getInstance().getProfile().getMcu().getClockElement(problem.getResource());
        if (elem != null && elem instanceof ClockOutput) {
            IClocksConfig config = problem.getConfig();
            ISetting setting = elem.getOutputFrequencySetting();
            SettingEditorHelper.lockSetting(setting, config, false, new SettingValueChangeListener(problem));
            return;
        }
        LOGGER.warning("Unlock has been called on Clocks Problem (" + elem + "), which is not refering to Clock output. Such a functionality is not implemented.");
        assert (false);
    }

    public static void setOutputFrequency(@NonNull IValidationProblem problem) {
        IClockElement elem = UiController.getInstance().getProfile().getMcu().getClockElement(problem.getDependency().getResourceId());
        if (elem != null && elem instanceof ClockOutput) {
            String configurationName = problem.getConfiguration().getConfigurationName();
            IClocksConfig config = UiController.getInstance().getProfile().getConfigByName(configurationName);
            assert (config != null) : String.valueOf(configurationName) + ": no such fuctional group found";
            ISetting setting = elem.getOutputFrequencySetting();
            SettingEditorHelper.setValue(setting, config, ProblemResolveHelper.parseFrequency(problem), new SettingValueChangeListener(problem));
            return;
        }
        LOGGER.warning("'Set frequency' has been called on Validation problem (" + elem + "), which is not refering to Clock output. Such a functionality is not implemented.");
        assert (false);
    }

    public static void findNearOutputFrequency(@NonNull IValidationProblem problem) {
        IClockElement elem = UiController.getInstance().getProfile().getMcu().getClockElement(problem.getDependency().getResourceId());
        if (elem != null && elem instanceof ClockOutput) {
            ProblemResolveHelper.findNearOutputFrequency((ClockOutput)elem, (IBaseProblem)problem);
            return;
        }
        LOGGER.warning("'Find near frequency' has been called on Validation problem (" + elem + "), which is not refering to Clock output. Such a functionality is not implemented.");
        assert (false);
    }

    public static void findNearOutputFrequency(@NonNull ClocksProblem problem) {
        IClockElement elem = UiController.getInstance().getProfile().getMcu().getClockElement(problem.getResource());
        if (elem != null && elem instanceof ClockOutput) {
            ProblemResolveHelper.findNearOutputFrequency((ClockOutput)elem, (IBaseProblem)problem);
            return;
        }
        LOGGER.warning("'Find near frequency' has been called on Validation problem (" + elem + "), which is not refering to Clock output. Such a functionality is not implemented.");
        assert (false);
    }

    private static void findNearOutputFrequency(@NonNull ClockOutput elem, @NonNull IBaseProblem problem) {
        IClocksConfig config = ProblemResolveHelper.getProblemConfig(problem);
        ISetting setting = elem.getOutputFrequencySetting();
        SettingEditorHelper.findNearValue(setting, config, new SettingValueChangeListener(problem), Display.getCurrent().getActiveShell());
    }

    public static @Nullable String parseFrequency(@NonNull IValidationProblem problem) {
        Frequency freq = ProblemResolveHelper.parseToFrequency(problem);
        return freq == null ? null : freq.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable Frequency parseToFrequency(@NonNull IValidationProblem problem) {
        @NonNull List data = problem.getFeature().getData();
        if (data.size() == 1) {
            return Frequency.parse((String)(String.valueOf(((IFeatureData)data.get(0)).getValue()) + ((IFeatureData)data.get(0)).getUnit()));
        }
        return null;
    }

    public static boolean canSetFrequency(@NonNull IValidationProblem problem) {
        LockState lockState;
        boolean isSupportedEvaluation;
        IClocksProfile profile = UiController.getInstance().getProfile();
        IClockElement elem = profile.getMcu().getClockElement(problem.getDependency().getResourceId());
        boolean isOutput = elem != null && elem instanceof ClockOutput;
        IClocksConfig config = profile.getConfigByName(problem.getConfiguration().getConfigurationName());
        IClocksConfig configToUse = config != null ? config : UiController.getInstance().getProfile().getActiveConfig();
        boolean sameValueLocked = false;
        String evaluation = problem.getFeature().getEvaluation();
        boolean bl = isSupportedEvaluation = evaluation.equals("equal") || evaluation.equals("isInRange");
        if (isSupportedEvaluation && elem != null && configToUse != null && (lockState = configToUse.getSettingsConfig().getLockState(elem.getOutputFrequencySetting())) != null) {
            sameValueLocked = Objects.equals(lockState.getValue().getValue(), ProblemResolveHelper.parseToFrequency(problem));
        }
        return isOutput && !sameValueLocked && isSupportedEvaluation;
    }

    public static boolean canSetFrequency(@NonNull ClocksProblem problem) {
        IClockElement elem = UiController.getInstance().getProfile().getMcu().getClockElement(problem.getResource());
        return elem != null && elem instanceof ClockOutput;
    }

    private static @NonNull IClocksConfig getProblemConfig(@NonNull IBaseProblem problem) {
        if (problem instanceof ClocksProblem) {
            return ((ClocksProblem)problem).getConfig();
        }
        IClocksConfig activeConfig = UiController.getInstance().getProfile().getActiveConfig();
        assert (activeConfig != null);
        return activeConfig;
    }
}

