/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.dependencies;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemOpenHandler;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class OpenClocksProblemHandler
implements IProblemOpenHandler {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(OpenClocksProblemHandler.class);

    public void openProblem(@NonNull IBaseProblem problem) {
        GuiController controller = GuiController.getInstance();
        if (problem instanceof IValidationProblem) {
            this.openTool("Clocks");
            String configurationName = ((IValidationProblem)problem).getConfiguration().getConfigurationName();
            IClocksConfig config = controller.getProfile().getConfigByName(configurationName);
            if (config != null) {
                controller.getProfile().setActiveConfig(config);
                controller.fireListeners(new ToolEvent.Builder(32).setOriginator((Object)this).build());
                PerspectivesHelper.showView((String)"com.nxp.swtools.clocks.DiagramView");
                controller.setSelectedElement(((IValidationProblem)problem).getDependency().getResourceId(), this);
            } else {
                LOGGER.warning(String.valueOf(configurationName) + ": no such fuctional group found");
            }
        }
    }

    public @Nullable String getTargetToolId() {
        return "Clocks";
    }

    public @NonNull String getOpenProblemLabel(@NonNull IBaseProblem problem) {
        if (problem instanceof IValidationProblem) {
            IValidationProblem prob = (IValidationProblem)problem;
            return MessageFormat.format(Messages.get().OpenClocksProblemHandler_ShowProblemInConfig, prob.getConfiguration().getConfigurationName());
        }
        return super.getOpenProblemLabel(problem);
    }
}

