/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.dependencies;

import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryAnnotation;
import com.nxp.swtools.provider.configuration.dependencies.DependencyQueryResult;
import com.nxp.swtools.provider.configuration.dependencies.DependencyResourceAnotation;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQuery;
import com.nxp.swtools.provider.configuration.dependencies.IDependencyQueryResult;
import com.nxp.swtools.provider.configuration.storage.IDependenciesConfiguration;
import com.nxp.swtools.provider.configuration.storage.INamedTool;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@DependencyQueryAnnotation(resources={@DependencyResourceAnotation(resourceType="ClockOutput", features={"exists", "enabled", "frequency"}), @DependencyResourceAnotation(resourceType="ClockSetting", features={"value"})})
@NonNullByDefault
public class ClocksToolQuery
implements IDependencyQuery {
    public @NonNull Collection<@NonNull IDependencyQueryResult> query(@NonNull ISharedConfiguration configuration, @NonNull String resourceType, @NonNull String resourceId, @NonNull String featureName) {
        ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        StorageClocksTool clockTool = configuration.getTools().getClock();
        if (clockTool != null && clockTool.isEnabled()) {
            if ("ClockOutput".equalsIgnoreCase(resourceType)) {
                result.addAll(ClocksToolQuery.getClockOutputQueryResult(clockTool, resourceId, featureName));
            }
            if ("ClockSetting".equalsIgnoreCase(resourceType)) {
                result.addAll(ClocksToolQuery.getClockSettingQueryResult(clockTool, resourceId));
            }
        }
        return result;
    }

    private static Collection<@NonNull IDependencyQueryResult> getClockSettingQueryResult(StorageClocksTool clockTool, String resourceId) {
        return ClocksToolQuery.queryAllConfigs((config, storageConfig) -> {
            ISetting setting = config.getMcu().getSettings().findSettingWithId(resourceId);
            Object val = null;
            if (setting != null) {
                val = config.getSettingsConfig().getSettingValue(setting).getValue();
                val = Converter.convertToLDBS(val);
            }
            return Stream.of(new DependencyQueryResult(val, (INamedTool)clockTool, (IDependenciesConfiguration)storageConfig));
        });
    }

    private static List<@NonNull IDependencyQueryResult> getClockOutputQueryResult(StorageClocksTool clockTool, String resourceId, String featureName) {
        ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        Collection<IClockElement> elems = UiController.getInstance().getProfile().getMcu().getAllElements().values();
        List outputs = CollectionsUtils.getInstancesOf(elems, ClockOutput.class).collect(Collectors.toList());
        if ("exists".equalsIgnoreCase(featureName)) {
            result.addAll(ClocksToolQuery.queryAllConfigs((config, storageConfig) -> {
                Optional<ClockOutput> exists = outputs.stream().filter(x -> x.getID().equals(resourceId)).findAny();
                return Stream.of(new DependencyQueryResult((Object)ClocksToolQuery.trueOrNull(exists.isPresent()), (INamedTool)clockTool, (IDependenciesConfiguration)storageConfig));
            }));
        }
        if ("enabled".equalsIgnoreCase(featureName)) {
            result.addAll(ClocksToolQuery.queryAllConfigs((config, storageConfig) -> outputs.stream().filter(x -> x.getID().equals(resourceId)).map(x -> new DependencyQueryResult((Object)ClocksToolQuery.trueOrNull(x.isEnabled((IClocksConfig)config)), (INamedTool)clockTool, (IDependenciesConfiguration)storageConfig))));
        }
        if ("frequency".equalsIgnoreCase(featureName)) {
            result.addAll(ClocksToolQuery.queryAllConfigs((config, storageConfig) -> outputs.stream().filter(x -> x.getID().equals(resourceId)).map(x -> {
                ISetting setting = x.getOutputFrequencySetting();
                Frequency f = (Frequency)config.getSettingsConfig().getSettingValue(setting).getValue();
                return new DependencyQueryResult((Object)f, (INamedTool)clockTool, (IDependenciesConfiguration)storageConfig);
            })));
        }
        return result;
    }

    private static @Nullable Boolean trueOrNull(boolean value) {
        return value ? Boolean.TRUE : null;
    }

    private static List<@NonNull IDependencyQueryResult> queryAllConfigs(BiFunction<@NonNull IClocksConfig, @NonNull StorageClocksConfiguration, Stream<@NonNull IDependencyQueryResult>> usingQuery) {
        ArrayList<@NonNull IDependencyQueryResult> result = new ArrayList<IDependencyQueryResult>();
        UiController.getInstance().getProfile().getConfigs().forEach(config -> {
            StorageClocksConfiguration storageConfig = config.getStorageConfig();
            result.addAll(((Stream)usingQuery.apply((IClocksConfig)config, storageConfig)).collect(Collectors.toList()));
        });
        return result;
    }
}

