/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.dependencies;

import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.dependencies.FindFrequencyResolveHandler;
import com.nxp.swtools.clocks.dependencies.FrequencyRangeHandler;
import com.nxp.swtools.clocks.dependencies.FrequencyResolveHandler;
import com.nxp.swtools.clocks.dependencies.LockResolveHandler;
import com.nxp.swtools.clocks.dependencies.ProblemResolveHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemResolveHandler;
import com.nxp.swtools.validation.engine.IProblemResolveProvider;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.util.ArrayList;
import java.util.Collection;

public class ClocksProblemResolveProvider
implements IProblemResolveProvider {
    public @NonNull Collection<@NonNull IProblemResolveHandler> getResolveHandlers(@NonNull IBaseProblem problem) {
        IValidationProblem validationproblem;
        ArrayList<@NonNull IProblemResolveHandler> result = new ArrayList<IProblemResolveHandler>();
        if (problem instanceof ClocksProblem) {
            ClocksProblem p = (ClocksProblem)problem;
            if (ProblemResolveHelper.isLocked(p)) {
                result.add(new LockResolveHandler());
            }
            if (ProblemResolveHelper.canSetFrequency(p)) {
                result.add(new FindFrequencyResolveHandler());
            }
        }
        if (problem instanceof IValidationProblem && "ClockOutput".equals((validationproblem = (IValidationProblem)problem).getDependency().getResourceType()) && "frequency".equals(validationproblem.getFeature().getName()) && ProblemResolveHelper.canSetFrequency(validationproblem)) {
            String evaluation = validationproblem.getFeature().getEvaluation();
            if ("equal".equals(evaluation)) {
                result.add(new FrequencyResolveHandler(validationproblem));
            } else if ("isInRange".equals(evaluation)) {
                result.add(new FrequencyRangeHandler(validationproblem));
            }
        }
        return result;
    }
}

