/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.valueMaps.CalculatedValueMap;
import com.nxp.swtools.clocks.data.valueMaps.IValueMap;
import com.nxp.swtools.clocks.data.valueMaps.IValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.ValueMapBuilderFactory;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ICalculus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValueMap
implements IValueMap,
IValueMapBuilder {
    private boolean initialized = false;
    @Nullable
    private IValueMapBuilder valueMapBuilder;
    @Nullable
    private IValueMap valueMapInternal;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(ValueMap.class);

    public ValueMap(@NonNull Expression expression, @NonNull IRegistersDatabaseAPI registers, boolean optimalize) {
        this.valueMapBuilder = ValueMapBuilderFactory.getBuilder(expression, registers, optimalize);
    }

    @Override
    public IValueMapBuilder addRequirement(@NonNull String expressionResult, @Nullable String uiValue, @Nullable Object controlValue) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot add requirements to initialized value map");
        }
        IValueMapBuilder builder = this.valueMapBuilder;
        assert (builder != null);
        builder.addRequirement(expressionResult, uiValue, controlValue);
        return this;
    }

    @Override
    public @NonNull IValueMapBuilder setConstraint(@NonNull List<@NonNull Constraint> constraint) {
        assert (this.valueMapBuilder != null);
        this.valueMapBuilder.setConstraint(constraint);
        return this;
    }

    @Override
    public IValueMapBuilder setDescriptionsEnabled(boolean enabled) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot enable/disable descriptions on initialized value map");
        }
        IValueMapBuilder builder = this.valueMapBuilder;
        assert (builder != null);
        builder.setDescriptionsEnabled(enabled);
        return this;
    }

    @Override
    public @NonNull IValueMapBuilder setFractional(int fractionalBits) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot enable/disable descriptions on initialized value map");
        }
        IValueMapBuilder builder = this.valueMapBuilder;
        assert (builder != null);
        builder.setFractional(fractionalBits);
        return this;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        IValueMapBuilder builderLoc = this.valueMapBuilder;
        assert (builderLoc != null);
        try {
            this.valueMapInternal = builderLoc.build();
            this.initialized = true;
            this.valueMapBuilder = null;
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Can not initialize value map " + this.toString(), e);
        }
    }

    @Override
    public @NonNull Collection<@NonNull String> getUiValues() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getUiValues();
    }

    @Override
    public @NonNull List<@NonNull String> getSortedUiValues() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getSortedUiValues();
    }

    @Override
    public @NonNull Collection<@NonNull Object> getControlValues() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getControlValues();
    }

    @Override
    public void replaceControlValue(@NonNull Object old, @NonNull Object replacement) {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        valueMapInternalLoc.replaceControlValue(old, replacement);
    }

    @Override
    public @NonNull String getDefaultUiValue() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getDefaultUiValue();
    }

    @Override
    public @NonNull LongValues getDefaultBfValues() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getDefaultBfValues();
    }

    @Override
    public @NonNull Object getDefaultControlValue() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getDefaultControlValue();
    }

    @Override
    public @Nullable Object getControlValueByUiValue(@NonNull String value) {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getControlValueByUiValue(value);
    }

    @Override
    public @Nullable String getUiValueByBfValue(@NonNull LongValues values) {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getUiValueByBfValue(values);
    }

    @Override
    public @Nullable LongValues getBfFromUiValue(@NonNull String value) {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getBfFromUiValue(value);
    }

    @Override
    public LongValues getBfFromControlValue(@NonNull Object value) {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getBfFromControlValue(value);
    }

    @Override
    public @NonNull BitFieldElement @NonNull [] getBitFields() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getBitFields();
    }

    @Override
    public @NonNull Expression getExpression() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getExpression();
    }

    public String toString() {
        if (this.initialized) {
            return "ValueMap - initialized: " + this.valueMapInternal;
        }
        return "ValueMap - not initialized: " + this.valueMapBuilder;
    }

    @Override
    public @NonNull IValueMap build() {
        this.initialize();
        return this;
    }

    @Override
    public @Nullable Object getControlValueByBfValue(@NonNull LongValues values) {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getControlValueByBfValue(values);
    }

    @Override
    public @Nullable String getUiValueByControlValue(@NonNull Object value) {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getUiValueByControlValue(value);
    }

    @Override
    public int getFractionalBits() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getFractionalBits();
    }

    @Override
    public @Nullable Range getRange() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getRange();
    }

    public boolean isCalculatedValueMap() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc instanceof CalculatedValueMap;
    }

    @Override
    public @Nullable ICalculus getCalculus() {
        this.initialize();
        IValueMap valueMapInternalLoc = this.valueMapInternal;
        assert (valueMapInternalLoc != null);
        return valueMapInternalLoc.getCalculus();
    }
}

