/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.valueMaps.AValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.IValueMap;
import com.nxp.swtools.clocks.data.valueMaps.IValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.RangeValueMap;
import com.nxp.swtools.clocks.expression.BitFieldsContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.verification.ExpressionVerificator;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import java.math.BigInteger;

public class RangeValueMapBuilder
extends AValueMapBuilder {
    @NonNull
    private static final Long LONG_ONE = 1L;
    @NonNull
    private static final Long LONG_ZERO = 0L;
    @NonNull
    private Expression reverseExpression;

    public RangeValueMapBuilder(@NonNull Expression expression, @NonNull Expression reverseExpression, @NonNull IRegistersDatabaseAPI registers) {
        super(registers, expression);
        this.reverseExpression = reverseExpression;
    }

    @Override
    public @NonNull IValueMapBuilder addRequirement(@NonNull String expressionResult, @Nullable String uiValue, @Nullable Object controlValue) {
        return this;
    }

    @Override
    public @NonNull IValueMap build() {
        Range range = new Range(this.getMinValue(), this.getMaxValue());
        range.setStep(new BigRational(this.getStepValue()));
        RangeValueMap result = new RangeValueMap(this.expression, this.reverseExpression, range, this.fractionalBits, this.bitFields, this.registers);
        ExpressionVerificator.getInstance().addValueMap(result);
        return result;
    }

    private @NonNull LongValues getMinBfValues() {
        LongValues.Builder builder = new LongValues.Builder();
        int i = 0;
        while (i < this.bitFields.length) {
            builder.addValue(LONG_ZERO);
            ++i;
        }
        return builder.build();
    }

    private @NonNull LongValues getSecondMinimalBfValues() {
        LongValues.Builder builder = new LongValues.Builder();
        int i = 0;
        while (i < this.bitFields.length) {
            if (i == this.bitFields.length - 1) {
                builder.addValue(LONG_ONE);
            } else {
                builder.addValue(LONG_ZERO);
            }
            ++i;
        }
        return builder.build();
    }

    private @NonNull LongValues getMaxBfValues() {
        LongValues.Builder builder = new LongValues.Builder();
        BitFieldElement[] bitFieldElementArray = this.bitFields;
        int n = this.bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            BitFieldElement bitField = bitFieldElementArray[n2];
            Long maxBitFieldValue = BigInteger.valueOf(2L).pow(bitField.getWidth()).subtract(BigInteger.ONE).longValue();
            builder.addValue(maxBitFieldValue);
            ++n2;
        }
        return builder.build();
    }

    private long getMinValue() {
        BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, this.getMinBfValues(), this.expression.getContext());
        IValue expressionResult = this.expression.resolve(bfContext);
        return expressionResult.getLong();
    }

    private long getSecondValue() {
        BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, this.getSecondMinimalBfValues(), this.expression.getContext());
        IValue expressionResult = this.expression.resolve(bfContext);
        return expressionResult.getLong();
    }

    private long getMaxValue() {
        BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, this.getMaxBfValues(), this.expression.getContext());
        IValue expressionResult = this.expression.resolve(bfContext);
        return expressionResult.getLong();
    }

    private long getStepValue() {
        long second;
        long min = this.getMinValue();
        return min != (second = this.getSecondValue()) ? second - min : 1L;
    }
}

