/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.valueMaps.AValueMapInternal;
import com.nxp.swtools.clocks.expression.BitFieldsContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

public class RangeValueMap
extends AValueMapInternal {
    @NonNull
    private Expression reverseExpression;
    @NonNull
    protected IRegistersDatabaseAPI registers;
    @NonNull
    Range range;

    public RangeValueMap(@NonNull Expression expression, @NonNull Expression reverseExpression, @NonNull Range range, int fractionalBits, @NonNull BitFieldElement @NonNull [] bitFields, @NonNull IRegistersDatabaseAPI registers) {
        super(expression, bitFields, fractionalBits);
        this.reverseExpression = reverseExpression;
        this.registers = registers;
        this.range = range;
    }

    @Override
    public @NonNull Collection<@NonNull String> getUiValues() {
        return CollectionsUtils.emptyList();
    }

    @Override
    public @NonNull List<@NonNull String> getSortedUiValues() {
        return CollectionsUtils.emptyList();
    }

    @Override
    public @NonNull Collection<@NonNull Object> getControlValues() {
        return CollectionsUtils.emptyList();
    }

    @Override
    public void replaceControlValue(@NonNull Object old, @NonNull Object replacement) {
    }

    @Override
    public @Nullable String getUiValueByBfValue(@NonNull LongValues values) {
        Object controlValue = this.getControlValueByBfValue(values);
        if (controlValue != null) {
            return this.createFractionalUiValue(UtilsText.safeToString((Object)controlValue));
        }
        return null;
    }

    @Override
    public @Nullable String getUiValueByControlValue(@NonNull Object value) {
        BigDecimal defaultDecimal = BigDecimal.ONE;
        BigDecimal fractionDecimal = BigDecimal.ONE;
        try {
            defaultDecimal = new BigDecimal(UtilsText.safeToString((Object)value));
            fractionDecimal = new BigDecimal(BigInteger.ONE.shiftLeft(this.fractionalBits));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return UtilsText.safeString((String)defaultDecimal.divide(fractionDecimal).toString());
    }

    @Override
    public @Nullable Object getControlValueByUiValue(@NonNull String uiValue) {
        try {
            BigDecimal defaultDecimal = new BigDecimal(uiValue.trim());
            BigDecimal fractionDecimal = new BigDecimal(BigInteger.ONE.shiftLeft(this.fractionalBits));
            BigDecimal decimalResult = defaultDecimal.multiply(fractionDecimal);
            return UtilsText.safeString((String)decimalResult.toBigIntegerExact().toString());
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            LOGGER.log(Level.INFO, "'" + uiValue + "' is not valid fractional number");
            return null;
        }
    }

    @Override
    public @Nullable Object getControlValueByBfValue(@NonNull LongValues values) {
        BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, values, this.expression.getContext());
        IValue expressionResult = this.expression.resolve(bfContext);
        return expressionResult.toString();
    }

    @Override
    public LongValues getBfFromControlValue(@NonNull Object value) {
        try {
            return this.reverseExpression.resolve(Long.parseLong(UtilsText.safeToString((Object)value)));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.log(Level.INFO, value + "can not been parsed into long");
            return null;
        }
    }

    @Override
    public @Nullable LongValues getBfFromUiValue(@NonNull String uiValue) {
        Object controlValue = this.getControlValueByUiValue(uiValue);
        if (controlValue != null) {
            return this.getBfFromControlValue(controlValue);
        }
        return null;
    }

    @Override
    public @NonNull Object getDefaultControlValue() {
        BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, this.getDefaultBfValues(), this.expression.getContext());
        IValue expressionResult = this.expression.resolve(bfContext);
        return UtilsText.safeToString((Object)expressionResult);
    }

    @Override
    public @NonNull LongValues getDefaultBfValues() {
        LongValues.Builder builder = new LongValues.Builder();
        BitFieldElement[] bitFieldElementArray = this.bitFields;
        int n = this.bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            BitFieldElement bitField = bitFieldElementArray[n2];
            Long value = bitField.getBitField().getResetValue().longValue();
            assert (value != null);
            builder.addValue(value);
            ++n2;
        }
        return builder.build();
    }

    @Override
    public @NonNull String getDefaultUiValue() {
        return this.createFractionalUiValue(UtilsText.safeToString((Object)this.getDefaultControlValue()));
    }

    @Override
    public @Nullable Range getRange() {
        return this.range;
    }
}

