/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.valueMaps.AValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.EntryValueMap;
import com.nxp.swtools.clocks.data.valueMaps.IValueMapBuilder;
import com.nxp.swtools.clocks.expression.BitFieldsContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class EntryValueMapBuilder
extends AValueMapBuilder {
    @NonNull
    private @NonNull Map<@NonNull String, ValueEntryRequirement> requirements;

    EntryValueMapBuilder(@NonNull Expression expression, @NonNull IRegistersDatabaseAPI registers) {
        super(registers, expression);
        this.expression = expression;
        this.requirements = new HashMap<String, ValueEntryRequirement>();
    }

    private @NonNull Map<@NonNull LongValues, @NonNull EntryValueMap.ValueEntry> createEntryValues(Map<@NonNull String, @NonNull EntryValueMap.ValueEntry> uiEntries) {
        HashMap<@NonNull LongValues, @NonNull EntryValueMap.ValueEntry> entries = new HashMap<LongValues, EntryValueMap.ValueEntry>();
        long[] bfIndices = new long[this.bitFields.length];
        do {
            LongValues values = this.fromBfIndices(bfIndices);
            BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, values, this.expression.getContext());
            IValue resolvedVal = this.expression.resolve(bfContext);
            String expressionResult = resolvedVal.getString();
            IRegBitFieldValueAPI bfValue = this.getValueOfOnlyBf(values);
            String uiValue = bfValue != null && this.enableDescriptions ? bfValue.getDescription() : expressionResult;
            EntryValueMap.ValueEntry entry = null;
            if (this.requirements.isEmpty()) {
                if (this.fractionalBits != 0) {
                    String fractionalUiValue = this.createFractionalUiValue(uiValue);
                    entry = new EntryValueMap.ValueEntry(values, fractionalUiValue, uiValue);
                } else {
                    entry = new EntryValueMap.ValueEntry(values, uiValue, uiValue);
                }
            } else if (this.requirements.containsKey(expressionResult)) {
                Object controlValue;
                ValueEntryRequirement requirement = Objects.requireNonNull(this.requirements.get(expressionResult));
                uiValue = requirement.uiValue != null ? requirement.uiValue : uiValue;
                Object object = controlValue = requirement.controlValue != null ? requirement.controlValue : uiValue;
                if (this.fractionalBits != 0) {
                    String fractionalUiValue;
                    uiValue = fractionalUiValue = this.createFractionalUiValue(uiValue);
                }
                entry = new EntryValueMap.ValueEntry(values, uiValue, controlValue);
            }
            if (entry == null) continue;
            if (entries.containsKey(values)) {
                LOGGER.warning("Same expression result: " + expressionResult + " for different bit-field values: " + (Object)((Object)this.expression));
            }
            entries.put(values, entry);
            uiEntries.put(entry.uiValue, entry);
        } while (this.nextBfValues(bfIndices));
        return entries;
    }

    @Override
    public @NonNull EntryValueMap build() {
        HashMap<@NonNull String, @NonNull EntryValueMap.ValueEntry> uiEntries = new HashMap<String, EntryValueMap.ValueEntry>();
        Map<@NonNull LongValues, @NonNull EntryValueMap.ValueEntry> entries = this.createEntryValues(uiEntries);
        return new EntryValueMap(this.expression, this.bitFields, entries, uiEntries, this.fractionalBits);
    }

    @Override
    public IValueMapBuilder addRequirement(@NonNull String expressionResult, @Nullable String uiValue, @Nullable Object controlValue) {
        if (this.requirements.containsKey(expressionResult)) {
            LOGGER.warning("Requirement to expression result of " + expressionResult + " was already defined. Replacing old requirement with the new one");
        }
        this.requirements.put(expressionResult, new ValueEntryRequirement(uiValue, controlValue));
        return this;
    }

    private static class ValueEntryRequirement {
        @Nullable
        String uiValue;
        @Nullable
        Object controlValue;

        ValueEntryRequirement(@Nullable String uiValue, @Nullable Object controlValue) {
            this.uiValue = uiValue;
            this.controlValue = controlValue;
        }

        public String toString() {
            return "(" + this.uiValue + ", " + this.controlValue + ")";
        }
    }
}

