/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.valueMaps;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.elements.Calculus;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.valueMaps.AValueMapInternal;
import com.nxp.swtools.clocks.expression.BitFieldsContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ICalculus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.Triplet;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CalculatedValueMap
extends AValueMapInternal {
    @NonNull
    private BigRational currentValue = BigRational.ZERO;
    @NonNull
    protected IRegistersDatabaseAPI registers;
    @NonNull
    private LongValues currentBfValues = LongValues.EMPTY;
    @NonNull
    private Triplet<LongValues, String, Object> defaultEntry;
    @NonNull
    private ICalculus calculus;

    public CalculatedValueMap(@NonNull IRegistersDatabaseAPI registers, @NonNull Expression expression, @NonNull BitFieldElement @NonNull [] bitFields, @NonNull List<@NonNull Constraint> constraint, int fractionalBits) {
        super(expression, bitFields, fractionalBits);
        this.registers = registers;
        this.currentBfValues = this.getDefaultBfValues();
        this.defaultEntry = new Triplet((Object)this.getDefaultBfValues(), (Object)this.getDefaultUiValue(), this.getDefaultControlValue());
        Object controlValue = this.getControlValueByBfValue(this.currentBfValues);
        if (controlValue != null) {
            this.currentValue = BigRational.parse((String)controlValue.toString());
        }
        this.calculus = new Calculus(registers, expression, constraint);
    }

    @Override
    public @NonNull Collection<@NonNull String> getUiValues() {
        return CollectionsUtils.emptyUnmodifiableList();
    }

    @Override
    public @NonNull Collection<@NonNull Object> getControlValues() {
        return Arrays.asList(this.currentValue);
    }

    @Override
    public void replaceControlValue(@NonNull Object old, @NonNull Object replacement) {
    }

    @Override
    public @Nullable String getUiValueByControlValue(@NonNull Object value) {
        return value.toString();
    }

    @Override
    public @Nullable String getUiValueByBfValue(@NonNull LongValues values) {
        Object retString = this.getControlValueByBfValue(values);
        assert (retString != null);
        return retString.toString();
    }

    @Override
    public @Nullable Object getControlValueByUiValue(@NonNull String uiValue) {
        if (!uiValue.equals(this.currentValue.toString())) {
            CollectionsUtils.Pair result = this.calculus.calculate((Object)uiValue);
            if (result == null && this.calculus.getProblematicConstraint() != null) {
                result = this.calculus.calculate((Object)Double.toString(Math.ceil(BigRational.parse((String)uiValue).doubleValue())));
            }
            if (result == null) {
                return null;
            }
            BigRational bigRational = (BigRational)result.getFirst();
            if (bigRational == null || BigRational.ZERO.compareTo(bigRational) > 0) {
                return null;
            }
            this.currentBfValues = new LongValues((Long[])result.getSecond());
            this.currentValue = bigRational;
        }
        return this.currentValue.toExactDecimalString();
    }

    @Override
    public @Nullable Object getControlValueByBfValue(@NonNull LongValues values) {
        BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, values, this.expression.getContext());
        IValue expressionResult = this.expression.resolve(bfContext);
        return expressionResult.toString();
    }

    @Override
    public @Nullable LongValues getBfFromUiValue(@NonNull String uiValue) {
        Object controlValue = this.getControlValueByUiValue(uiValue);
        if (controlValue != null) {
            return this.getBfFromControlValue(controlValue);
        }
        return null;
    }

    @Override
    public @Nullable LongValues getBfFromControlValue(@NonNull Object value) {
        if (this.defaultEntry.getThird().equals(value)) {
            BigRational parsedValue = BigRational.tryParse((String)this.getDefaultControlValue().toString());
            assert (parsedValue != null);
            this.currentValue = parsedValue;
            this.currentBfValues = this.getDefaultBfValues();
        }
        return this.currentBfValues;
    }

    @Override
    public @NonNull Object getDefaultControlValue() {
        BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, this.getDefaultBfValues(), this.expression.getContext());
        IValue expressionResult = this.expression.resolve(bfContext);
        return UtilsText.safeToString((Object)expressionResult);
    }

    @Override
    public @NonNull LongValues getDefaultBfValues() {
        LongValues.Builder builder = new LongValues.Builder();
        BitFieldElement[] bitFieldElementArray = this.bitFields;
        int n = this.bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            BitFieldElement bitField = bitFieldElementArray[n2];
            Long value = bitField.getBitField().getResetValue().longValue();
            assert (value != null);
            builder.addValue(value);
            ++n2;
        }
        return builder.build();
    }

    @Override
    public @NonNull String getDefaultUiValue() {
        return this.getDefaultControlValue().toString();
    }

    @Override
    public @Nullable Range getRange() {
        return null;
    }

    @Override
    public @NonNull ICalculus getCalculus() {
        return this.calculus;
    }
}

