/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.settings.AGeneralSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.utils.ToolTipBuilder;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.text.MessageFormat;
import java.util.List;

public class OutputFrequencySetting
extends AGeneralSetting {
    @NonNull
    protected static final String ELLIPSIS = "...";
    @NonNull
    protected static final String ID_SUFFIX = "outFreq";

    public OutputFrequencySetting(@NonNull IClockElement clockElement) {
        super(clockElement.getName(), SettingType.FREQUENCY_OUTPUT, clockElement, false, true, true);
    }

    public OutputFrequencySetting(@NonNull IClockElement clockElement, boolean editable, boolean visible) {
        super(clockElement.getName(), SettingType.FREQUENCY_OUTPUT, clockElement, false, editable, visible);
    }

    @Override
    public @NonNull IClockElement getElement() {
        assert (this.element instanceof IClockElement);
        return (IClockElement)this.element;
    }

    @Override
    protected @NonNull String getIdSuffix() {
        return ID_SUFFIX;
    }

    @Override
    public @NonNull String getName() {
        return String.valueOf(this.name) + " Frequency";
    }

    @Override
    public @Nullable String getAllowedValueDescription(@NonNull IClocksConfig clocksConfig) {
        return Messages.get().OutputFrequencySetting_AllowedValueDescription;
    }

    @Override
    public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        Frequency frequencyValue = this.parseFrequency(uiValue, clocksConfig);
        if (frequencyValue != null && !BigRational.ZERO.equals((Object)frequencyValue.getValue())) {
            List<@NonNull SettingValue> values = this.getValues(clocksConfig);
            if (values == null) {
                return OutputFrequencySetting.parseValue(frequencyValue);
            }
            for (SettingValue value : values) {
                if (!value.getValue().toString().equals(frequencyValue.toString())) continue;
                return value;
            }
        }
        return null;
    }

    public @Nullable Frequency parseFrequency(String uiValue, IClocksConfig clocksConfig) {
        Object valueFromLock;
        LockState lockState = clocksConfig.getSettingsConfig().getLockState(this);
        Frequency prevValue = (Frequency)clocksConfig.getSettingsConfig().getSettingValue(this).getValue();
        if (lockState != null && (valueFromLock = lockState.getValue().getValue()) instanceof Frequency) {
            Frequency frequencyFromLock;
            prevValue = frequencyFromLock = (Frequency)valueFromLock;
        }
        Frequency frequencyValue = uiValue != null ? OutputFrequencySetting.fromUiValue(uiValue, prevValue) : null;
        return frequencyValue;
    }

    private static @Nullable Frequency fromUiValue(@NonNull String uiValue, @NonNull Frequency prevValue) {
        String uiValueToParse = uiValue.trim().replace(ELLIPSIS, "");
        Frequency parsedFrequency = Frequency.parse((String)uiValueToParse);
        if (parsedFrequency == null && !uiValue.isEmpty() && Character.isDigit(uiValue.charAt(uiValue.length() - 1))) {
            parsedFrequency = Frequency.parse((String)(String.valueOf(uiValue) + " " + prevValue.getUnit()));
        }
        return parsedFrequency;
    }

    @Override
    public boolean isValid(@NonNull SettingValue settingValue, @NonNull IClocksConfig clocksConfig) {
        return this.getElement().isValid(clocksConfig);
    }

    private static @NonNull SettingValue parseValue(@NonNull Frequency frequency) {
        Frequency freq = frequency;
        String uiValue = (freq = FrequencyCalculator.normalize((Frequency)freq, (long)1L)).toString();
        if (Frequency.parseNonNull((String)uiValue).compareTo(freq) != 0) {
            String uiValueEllipsis = freq.toStringWithEllipsis(ELLIPSIS);
            return new SettingValue(freq, uiValueEllipsis);
        }
        return new SettingValue(freq, freq.toString());
    }

    @Override
    public @Nullable SettingValue parseValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        if (value instanceof Frequency) {
            Frequency freq = (Frequency)value;
            return OutputFrequencySetting.parseValue(freq);
        }
        LOGGER.warning("Frequency expected, but got: " + value.getClass().getSimpleName() + ": " + value);
        return null;
    }

    @Override
    public boolean isUserLockable() {
        return false;
    }

    @Override
    public boolean isLockedByDefault() {
        return false;
    }

    @Override
    public boolean isVisible(@Nullable IClocksConfig config) {
        return this.visible;
    }

    @Override
    public boolean isEditable(@NonNull IClocksConfig clocksConfig) {
        return this.editable;
    }

    @Override
    public @Nullable SettingValue getDefaultValue(IClocksConfig clockConfig) {
        return SettingValue.FREQ_N_A;
    }

    @Override
    public @Nullable List<@NonNull SettingValue> getValues(@NonNull IClocksConfig clocksConfig) {
        return null;
    }

    @Override
    public @NonNull String toString(@NonNull SettingValue settingValue) {
        Object value = settingValue.getValue();
        if (value instanceof Frequency) {
            Frequency normalized = FrequencyCalculator.normalize((Frequency)((Frequency)value), (long)1L);
            return normalized.toExactString();
        }
        throw new IllegalArgumentException("SettingValue must be of the frequency type, actual type: " + value.getClass().getSimpleName());
    }

    @Override
    public @Nullable SettingValue fromString(@NonNull String string, @NonNull IClocksConfig clocksConfig) {
        Frequency frequency = Frequency.parseNonNull((String)string);
        if (frequency.compareTo((Frequency)SettingValue.FREQ_N_A.getValue()) == 0) {
            return SettingValue.FREQ_N_A;
        }
        return this.parseValue(frequency, clocksConfig);
    }

    @Override
    public @Nullable String getToolTipText(@NonNull IClocksConfig clocksConfig) {
        return ToolTipBuilder.create(this.getElement(), (ISetting)this, clocksConfig);
    }

    @Override
    public boolean shouldBeSaved(@NonNull IClocksConfig currentConfig) {
        return false;
    }

    @Override
    public @Nullable String getDescription() {
        return MessageFormat.format(Messages.get().OutputFrequencySetting_OutputFrequencyOf, this.getElement().getName());
    }

    @Override
    public boolean isFindNearValueSupported() {
        return true;
    }
}

