/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.ValueConfigElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.utils.ToolTipBuilder;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class GlobalConfigElementSetting
extends AGlobalSetting {
    @NonNull
    private IConfigElement configElement;

    public GlobalConfigElementSetting(@NonNull IConfigElement element) {
        super(element);
        this.configElement = element;
    }

    @Override
    public @NonNull String getId() {
        return this.configElement.getID();
    }

    @Override
    public @NonNull String getName() {
        return this.configElement.getName();
    }

    @Override
    public @NonNull SettingType getType() {
        return SettingType.GLOBAL_CONFIG_ELEMENT;
    }

    @Override
    public @Nullable List<@NonNull SettingValue> getValues(@NonNull IClocksConfig clocksConfig) {
        Collection<@NonNull IConfigElementItem> items = this.configElement.getItems();
        if (items == null) {
            return null;
        }
        return (List)items.stream().map(x -> new SettingValue(x.getID(), x.getName())).collect(CollectorsUtils.toList());
    }

    @Override
    public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        BigRational rationalValue;
        List<@NonNull SettingValue> values = this.getValues(clocksConfig);
        if (values != null) {
            for (SettingValue settingVal : values) {
                if (!settingVal.getUiValue().equals(uiValue)) continue;
                return settingVal;
            }
        } else if (this.configElement instanceof ValueConfigElement && (rationalValue = BigRational.tryParse((String)uiValue)) != null) {
            return new SettingValue(uiValue);
        }
        return null;
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        return this.configElement.createCurrentValue(config);
    }

    @Override
    public boolean canWrite(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) throws UnsupportedOperationException {
        if (this.configElement.isWritable()) {
            return resolvedSettingIds.containsAll(this.configElement.getDependencies(config.getMcu()));
        }
        return super.canWrite(config, resolvedSettingIds);
    }

    @Override
    public @Nullable SettingValue getDefaultValue(IClocksConfig clockConfig) {
        String defaultItem = this.configElement.getDefaultItem();
        Collection<@NonNull IConfigElementItem> items = this.configElement.getItems();
        if (items != null) {
            Optional<IConfigElementItem> item = items.stream().filter(it -> it.getID().equals(defaultItem)).findFirst();
            return new SettingValue(item.get().getID(), item.get().getName());
        }
        return new SettingValue(defaultItem, defaultItem);
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        Collection<@NonNull String> dependencies = this.configElement.getDependencies(mcu);
        dependencies.addAll(this.getInfluencedSettings(mcu));
        return dependencies;
    }

    @Override
    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        return this.configElement.getItemsBitFields();
    }

    @Override
    public @NonNull Collection<@NonNull String> getInfluencedSettings(@NonNull IMcu mcu) {
        return this.configElement.getAllControledSettings(mcu);
    }

    @Override
    public boolean canRead(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) {
        return resolvedSettingIds.containsAll(this.getDependencies(config.getMcu()));
    }

    @Override
    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull IClocksConfig config, @NonNull SettingValue value) throws UnsupportedOperationException {
        return this.configElement.getBitFieldsToWrite(UtilsText.safeToString((Object)value.getValue()), config);
    }

    @Override
    public boolean isUserLockable() {
        return false;
    }

    @Override
    public boolean isLockedByDefault() {
        return true;
    }

    @Override
    public @Nullable SettingValue parseValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        List<@NonNull SettingValue> values = this.getValues(clocksConfig);
        if (values != null) {
            for (SettingValue settingVal : values) {
                if (!settingVal.getValue().equals(value)) continue;
                return settingVal;
            }
        }
        LOGGER.warning("Didn't find coresponding setting value, creating one.");
        return new SettingValue(value);
    }

    @Override
    public boolean isValid(@NonNull SettingValue settingValue, @NonNull IClocksConfig clocksConfig) {
        return !settingValue.isN_A() && clocksConfig.getProblemsOfElement(this.element.getID(), 2).isEmpty();
    }

    @Override
    public @Nullable String getToolTipText(@NonNull IClocksConfig clocksConfig) {
        return ToolTipBuilder.create(this.configElement, (ISetting)this, clocksConfig);
    }

    @Override
    public boolean hasConflicts(@NonNull SettingValue value, @NonNull IClocksConfig clocksConfig) {
        String stringValue = UtilsText.safeToString((Object)value.getValue());
        List<@NonNull Constraint> constraints = this.configElement.getConstraintsOf(stringValue);
        for (Constraint constraint : constraints) {
            if (constraint.isValid(clocksConfig)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable String getToolTipText(@NonNull SettingValue value, @NonNull IClocksConfig clocksConfig) {
        String description = null;
        Collection<@NonNull IConfigElementItem> items = this.configElement.getItems();
        if (items == null) {
            description = this.configElement.getDescription();
        } else {
            assert (items != null);
            for (IConfigElementItem item : items) {
                if (!item.getID().equals(value.getValue())) continue;
                description = item.getDescription();
                break;
            }
        }
        return description;
    }
}

