/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.parser;

import com.nxp.swtools.clocks.data.ClockComponent;
import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.elements.BitFieldAssign;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ClockGate;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.ComponentOutput;
import com.nxp.swtools.clocks.data.elements.ConfigElement;
import com.nxp.swtools.clocks.data.elements.ConfigElementItem;
import com.nxp.swtools.clocks.data.elements.EnableDisableCondition;
import com.nxp.swtools.clocks.data.elements.Fll;
import com.nxp.swtools.clocks.data.elements.FnPll;
import com.nxp.swtools.clocks.data.elements.FnPllConfigElement;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.elements.Pll;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.elements.ValueConfigElement;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.parser.ClockSignalInterface;
import com.nxp.swtools.clocks.data.parser.ParserException;
import com.nxp.swtools.clocks.data.parser.XsdValidationHandler;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.valueMaps.IValueMap;
import com.nxp.swtools.clocks.data.valueMaps.IValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.RangeValueMap;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.ComponentContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.expression.RegistersContext;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.ui.diagram.XmlUtil;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.clocks.utils.ExpressionUtils;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.OperatorType;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsXmlDom;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ComponentParser {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ComponentParser.class);

    private static @NonNull Element getElementByTagName(Element parent, String tagName) throws ParserException {
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes.getLength() != 1) {
            throw new ParserException("Only one tag supported with name: " + tagName);
        }
        Element element = (Element)nodes.item(0);
        assert (element != null);
        return element;
    }

    public static @NonNull IClockComponent parse(@NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull InputStream file, @NonNull String id, @NonNull String name, @NonNull String peripheral, @NonNull String comp, @NonNull String filePath, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> notAvailableElements) throws ParserException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        Map<@NonNull String, IClockElement> elements = new LinkedHashMap<String, IClockElement>();
        HashMap<@NonNull String, @NonNull String> signalMapping = new HashMap<String, String>();
        HashMap<@NonNull String, @NonNull Pin> pins = new HashMap();
        HashMap<@NonNull String, ClockSignalInterface> signalInterfaces = new HashMap();
        ArrayList<@NonNull IConfigElement> configElements = new ArrayList<IConfigElement>();
        List<EnableDisableCondition> enableDisableConditions = null;
        try {
            DocumentBuilder dBuilder = factory.newDocumentBuilder();
            XsdValidationHandler handlerXSD = new XsdValidationHandler(LOGGER, filePath);
            dBuilder.setErrorHandler(handlerXSD);
            Document doc = dBuilder.parse(file);
            doc.normalize();
            Element root = doc.getDocumentElement();
            if (!comp.equals(root.getAttribute("id"))) {
                LOGGER.severe("Expected component " + comp + " in file " + filePath + " not found!");
            }
            NodeList rootChildNodes = root.getChildNodes();
            int i = 0;
            while (i < rootChildNodes.getLength()) {
                Node node = Objects.requireNonNull(rootChildNodes.item(i));
                if (node.getNodeType() == 1 && "interface".equals(node.getNodeName())) {
                    Element interfaceElement = (Element)node;
                    pins = ComponentParser.parsePins(id, interfaceElement, peripheral, mcuRegisters, notAvailableElements);
                    signalInterfaces = ComponentParser.parseSignalInterfaces(id, interfaceElement, mcuRegisters);
                }
                if (node.getNodeType() == 1 && "implementation".equals(node.getNodeName())) {
                    Element implementationElement = (Element)node;
                    ComponentContext componentContext = new ComponentContext(peripheral, id, mcuRegisters);
                    enableDisableConditions = ComponentParser.parseControlAndConstraints(implementationElement, id, componentContext, constraints);
                    elements = ComponentParser.parseImplementation(id, mcuRegisters, implementationElement, signalMapping, instanceMapping, false, notAvailableElements, constraints, configElements, componentContext, pins, signalInterfaces);
                }
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.SEVERE, "Error while parsing component '" + id + "' at path '" + filePath + "'.", e);
        }
        if (UtilsText.isEmpty((String)id)) {
            LOGGER.log(Level.WARNING, "Component ID must by specified.");
        }
        if (enableDisableConditions == null) {
            enableDisableConditions = new ArrayList<EnableDisableCondition>(0);
        }
        ClockComponent component = new ClockComponent(id, name, peripheral, elements, signalMapping, configElements, null);
        component.setEnableSetting(new EnableSetting(id, (IElement)component, enableDisableConditions));
        return component;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Map<@NonNull String, ClockSignalInterface> parseSignalInterfaces(@NonNull String componentID, @NonNull Element interfaceElement, @NonNull IRegistersDatabaseAPI mcuRegisters) {
        HashMap<@NonNull String, ClockSignalInterface> interfaceSignals = new HashMap<String, ClockSignalInterface>();
        @NonNull Stream elems = CollectionsUtils.getInstancesOf(XmlUtil.asList(interfaceElement.getChildNodes()), Element.class);
        elems.filter(x -> "input_clock_signal".equals(x.getTagName()) || "output_clock_signal".equals(x.getTagName())).forEach(x -> {
            String signalID = UtilsText.safeString((String)x.getAttribute("id"));
            String name = UtilsText.safeString((String)x.getAttribute("name"));
            String description = UtilsText.safeString((String)x.getAttribute("description"));
            String group = x.getAttribute("group");
            String availableExpr = UtilsText.safeString((String)x.getAttribute("available"));
            String isTopOutputText = UtilsText.safeString((String)x.getAttribute("top_output"));
            boolean available = availableExpr.isEmpty() ? true : Expression.create(availableExpr, (IContext)new RegistersContext(mcuRegisters)).resolve().getBoolean();
            boolean isInput = "output_clock_signal".equals(x.getTagName());
            String id = componentID.isEmpty() ? signalID : String.valueOf(componentID) + "." + signalID;
            boolean isTopOutput = componentID.isEmpty() || Boolean.parseBoolean(isTopOutputText);
            interfaceSignals.put(id, new ClockSignalInterface(id, name, isInput, isTopOutput, available, group, description));
        });
        return interfaceSignals;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull Map<@NonNull String, @NonNull Pin> parsePins(@NonNull String id, @NonNull Element interfaceElement, @NonNull String peripheral, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Map<@NonNull String, @NonNull String> notAvailableElements) {
        HashMap<@NonNull String, @NonNull Pin> result = new HashMap<String, Pin>();
        @NonNull Stream elems = CollectionsUtils.getInstancesOf(XmlUtil.asList(interfaceElement.getChildNodes()), Element.class);
        elems.filter(x -> "pin".equals(x.getTagName())).forEach(y -> {
            @NonNull String pinId = UtilsText.safeString((String)y.getAttribute("id"));
            String fullId = String.valueOf(id) + "." + pinId;
            if (ComponentParser.available(mcuRegisters, y)) {
                Pin p = ComponentParser.parsePin(fullId, y, peripheral);
                if (p != null) {
                    result.put(pinId, p);
                }
            } else {
                notAvailableElements.put(fullId, "");
            }
        });
        return result;
    }

    private static Pin parsePin(@NonNull String fullId, @NonNull Element pinElem, @NonNull String peripheral) {
        String id = pinElem.getAttribute("id");
        String name = pinElem.getAttribute("name");
        String direction = pinElem.getAttribute("direction");
        String description = pinElem.getAttribute("description");
        if (UtilsText.isEmpty((String)id) || UtilsText.isEmpty((String)name)) {
            LOGGER.warning("Invalid state for pin " + fullId + ". Expected nonNull,non-empty values of id:'" + id + "', name:'" + name + "'.");
            return null;
        }
        Pin.Direction dir = Pin.Direction.UNDEFINED;
        if ("in".equals(direction)) {
            dir = Pin.Direction.IN;
        }
        if ("out".equals(direction)) {
            dir = Pin.Direction.OUT;
        }
        String string = description = UtilsText.isEmpty((String)description) ? null : description;
        assert (name != null);
        Pin pin = new Pin(fullId, name, dir, description, peripheral);
        Stream children = CollectionsUtils.getInstancesOf(XmlUtil.asList(pinElem.getChildNodes()), Element.class);
        children.filter(x -> "peripheral_signal_ref".equals(x.getNodeName())).forEach(x -> {
            String refSignal = x.getAttribute("signal");
            if (UtilsText.isEmpty((String)refSignal)) {
                LOGGER.warning("Reference signal for pin " + fullId + " is empty.");
            } else {
                assert (refSignal != null);
                pin.addSignalRef(new Pin.PeripheralSignalRef(refSignal, x.getAttribute("channel")));
            }
        });
        return pin;
    }

    private static @NonNull List<@NonNull EnableDisableCondition> parseControlAndConstraints(@NonNull Element elem, @NonNull String id, @NonNull IContext componentContext, @NonNull List<@NonNull Constraint> constraints) {
        NodeList controlAndConstraintsElements = elem.getElementsByTagName("control_and_constraints");
        List<Object> enableDisableConditions = null;
        if (controlAndConstraintsElements.getLength() == 1) {
            Node controlAndConstraintsElement = Objects.requireNonNull(controlAndConstraintsElements.item(0));
            NodeList childNodes = controlAndConstraintsElement.getChildNodes();
            assert (childNodes != null);
            enableDisableConditions = ComponentParser.parseEnableAndConstraints(id, childNodes, componentContext, constraints, false);
            int i = 0;
            while (i < childNodes.getLength()) {
                if (Objects.requireNonNull(childNodes.item(i)).getNodeType() == 1) {
                    Element constraintElement = (Element)childNodes.item(i);
                    assert (constraintElement != null);
                    Constraint constraint = ComponentParser.parseConstraint(constraintElement, id, componentContext);
                    if (constraint != null) {
                        constraints.add(constraint);
                    }
                }
                ++i;
            }
        } else if (controlAndConstraintsElements.getLength() != 0) {
            LOGGER.warning(String.valueOf(id) + ": Exactly one control and constraints block expected");
        }
        if (enableDisableConditions == null) {
            enableDisableConditions = new ArrayList(0);
        }
        return enableDisableConditions;
    }

    public static @NonNull Map<@NonNull String, IClockElement> parseImplementation(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem, @NonNull Map<@NonNull String, @NonNull String> signalMapping, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, boolean highLevel, @NonNull Map<@NonNull String, @NonNull String> notAvailableElements, @NonNull List<@NonNull Constraint> constraints, @NonNull Collection<@NonNull IConfigElement> confElements, @NonNull IContext componentContext, @NonNull Map<@NonNull String, @NonNull Pin> pins, @NonNull Map<@NonNull String, ClockSignalInterface> signalInterfaces) throws ParserException {
        LinkedHashMap<@NonNull String, IClockElement> elements = new LinkedHashMap<String, IClockElement>();
        NodeList childNodes = elem.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element pllElement;
            String input;
            String id;
            IClockElement previousElement;
            Node node = Objects.requireNonNull(childNodes.item(i));
            if (node.getNodeType() == 1 && "configuration_element".equals(node.getNodeName())) {
                Element configElement = (Element)node;
                IConfigElement config = ComponentParser.parseConfigElement(mcuRegisters, configElement, constraints, true, componentContext);
                confElements.add(config);
            } else if (node.getNodeType() == 1 && "clock_source".equals(node.getNodeName())) {
                Element clocksSourceElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, clocksSourceElement)) {
                    ClockSource clockSource = ComponentParser.parseClockSource(componentID, mcuRegisters, clocksSourceElement, constraints, instanceMapping, componentContext, pins);
                    previousElement = elements.put(clockSource.getID(), clockSource);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, clocksSourceElement);
                    input = ComponentParser.parseInputSignalElement(componentID, id, clocksSourceElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "prescaler".equals(node.getNodeName())) {
                Element prescalerElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, prescalerElement)) {
                    Prescaler prescaler = ComponentParser.parsePrescaler(componentID, mcuRegisters, prescalerElement, constraints, instanceMapping, componentContext, false);
                    previousElement = elements.put(prescaler.getID(), prescaler);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, prescalerElement);
                    input = ComponentParser.parseInputSignalElement(componentID, id, prescalerElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "pll".equals(node.getNodeName())) {
                pllElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, pllElement)) {
                    Pll pll = ComponentParser.parsePll(componentID, mcuRegisters, pllElement, constraints, instanceMapping, componentContext);
                    previousElement = elements.put(pll.getID(), pll);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, pllElement);
                    input = ComponentParser.parseInputSignalElement(componentID, id, pllElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "fnpll".equals(node.getNodeName())) {
                pllElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, pllElement)) {
                    FnPll fnpll = ComponentParser.parseFnPll(componentID, mcuRegisters, pllElement, constraints, instanceMapping, componentContext);
                    previousElement = elements.put(fnpll.getID(), fnpll);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, pllElement);
                    input = ComponentParser.parseInputSignalElement(componentID, id, pllElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "clock_select".equals(node.getNodeName())) {
                Element clockSelectElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, clockSelectElement)) {
                    ClockSelect clockSelect = ComponentParser.parseClockSelect(componentID, mcuRegisters, clockSelectElement, instanceMapping, constraints, componentContext);
                    previousElement = elements.put(clockSelect.getID(), clockSelect);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, clockSelectElement);
                    input = ComponentParser.parseInputSignalElement(componentID, id, clockSelectElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "fll".equals(node.getNodeName())) {
                Element fllElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, fllElement)) {
                    Fll fll = ComponentParser.parseFll(componentID, mcuRegisters, fllElement, constraints, instanceMapping, componentContext);
                    previousElement = elements.put(fll.getID(), fll);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, fllElement);
                    input = ComponentParser.parseInputSignalElement(componentID, id, fllElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "map_output".equals(node.getNodeName()) && !highLevel) {
                Element outputMapElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, outputMapElement)) {
                    IClockElement output = ComponentParser.parseComponentOutput(componentID, mcuRegisters, outputMapElement, signalMapping, instanceMapping, constraints, componentContext, signalInterfaces);
                    previousElement = elements.put(output.getID(), output);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, outputMapElement);
                    input = ComponentParser.parseInputSignalElement(componentID, id, outputMapElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "clock_enable".equals(node.getNodeName())) {
                Element gateElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, gateElement)) {
                    ClockGate gate = ComponentParser.parseClockGate(componentID, mcuRegisters, gateElement, instanceMapping, constraints, componentContext);
                    previousElement = elements.put(gate.getID(), gate);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, gateElement);
                    input = ComponentParser.parseInputSignalElement(componentID, id, gateElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            }
            ++i;
        }
        for (IClockElement element : elements.values()) {
            EnableSetting enableSetting = element.getEnableSetting();
            if (enableSetting == null || componentID.isEmpty()) continue;
            enableSetting.setComponentEnableCondition(Expression.create(String.valueOf(componentID) + "." + "enable"));
        }
        return elements;
    }

    public static boolean available(@NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem) {
        boolean result = true;
        String availableExpr = UtilsText.safeString((String)elem.getAttribute("available"));
        if (!availableExpr.isEmpty()) {
            Expression available = Expression.create(availableExpr, (IContext)new RegistersContext(mcuRegisters));
            result = available.resolve().getBoolean();
        }
        return result;
    }

    private static @NonNull IClockElement parseComponentOutput(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem, Map<@NonNull String, @NonNull String> signalMapping, @NonNull Map<@NonNull String, String> instanceMapping, @NonNull List<@NonNull Constraint> constraints, @NonNull IContext componentContext, @NonNull Map<@NonNull String, ClockSignalInterface> signalInterfaces) throws ParserException {
        boolean isOutput = false;
        String group = "component";
        ClockElementData elementData = ComponentParser.parseElementData(componentID, mcuRegisters, elem, constraints, instanceMapping, componentContext, false);
        ClockSignalInterface clockSignalInterface = signalInterfaces.get(elementData.getId());
        if (clockSignalInterface != null) {
            elementData.setName(clockSignalInterface.getName());
            String description = clockSignalInterface.getDescription();
            if (description != null) {
                elementData.setDescription(description);
            }
            isOutput = clockSignalInterface.isTopOutput();
            group = clockSignalInterface.getGroup();
        } else {
            LOGGER.warning(String.valueOf(elementData.getId()) + " component output has no entry matching in component interface of component" + componentID);
        }
        String signal = elementData.getInputSignal();
        String instanceSignal = instanceMapping.get(signal);
        if (instanceSignal != null) {
            signal = instanceSignal;
        }
        assert (signal != null && !"".equals(signal));
        signalMapping.put(elementData.getId(), String.valueOf(elementData.getId()) + ".clk");
        if (isOutput) {
            ClockOutput clockOutput = new ClockOutput(elementData, signal, group);
            clockOutput.addNestedSetting(new EnableSetting(elementData.getId(), (IElement)clockOutput, elementData.getEnableDisableConditions()));
            return clockOutput;
        }
        return new ComponentOutput(elementData);
    }

    public static @NonNull List<@NonNull IConfigElement> parseLocalConfigElements(@NonNull IRegistersDatabaseAPI mcuRegisters, Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull IContext componentContext) throws ParserException {
        ArrayList<@NonNull IConfigElement> result = new ArrayList<IConfigElement>();
        NodeList configElements = elem.getElementsByTagName("configuration_element");
        int i = 0;
        while (i < configElements.getLength()) {
            Element configElement = (Element)configElements.item(i);
            result.add(ComponentParser.parseConfigElement(mcuRegisters, configElement, constraints, false, componentContext));
            ++i;
        }
        return result;
    }

    private static @NonNull IConfigElement parseConfigElement(@NonNull IRegistersDatabaseAPI mcuRegisters, Element elem, @NonNull List<@NonNull Constraint> constraints, boolean global, @NonNull IContext componentContext) throws ParserException {
        String id = UtilsText.safeString((String)elem.getAttribute("id"));
        String name = UtilsText.safeString((String)elem.getAttribute("name"));
        String description = UtilsText.safeString((String)elem.getAttribute("description"));
        NodeList defaultElements = elem.getElementsByTagName("default");
        String defaultValue = "";
        if (defaultElements.getLength() == 1) {
            Element defaultElement = (Element)Objects.requireNonNull(defaultElements.item(0));
            defaultValue = UtilsText.safeString((String)defaultElement.getAttribute("value"));
        } else {
            LOGGER.warning(MessageFormat.format("Exactly one default item expected at control element id={0}", id));
        }
        NodeList rangeItemElements = elem.getElementsByTagName("range_item");
        NodeList valueFieldElement = elem.getElementsByTagName("value_field");
        Map<@NonNull Object, @NonNull Object> items = new HashMap();
        List<@NonNull EnableDisableCondition> enableDisableConditions = ComponentParser.parseEnableAndConstraints(id, elem.getChildNodes(), componentContext, constraints, true);
        if (rangeItemElements.getLength() == 1) {
            items = ComponentParser.parseRangeItems(ComponentParser.getElementByTagName(elem, "range_item"), id, componentContext, mcuRegisters);
        } else {
            if (valueFieldElement.getLength() == 1) {
                items = ComponentParser.parseValueField(elem, id, constraints, componentContext, mcuRegisters);
                return new ValueConfigElement(id, name, description, Objects.requireNonNull((IConfigElementItem)items.get(id)), defaultValue, global, constraints, enableDisableConditions);
            }
            items = ComponentParser.parseItems(elem, id, constraints, componentContext, mcuRegisters);
        }
        return new ConfigElement(id, name, description, items, defaultValue, global, constraints, enableDisableConditions);
    }

    private static Map<@NonNull String, @NonNull IConfigElementItem> parseValueField(@NonNull Element valueItem, @NonNull String id, @NonNull List<@NonNull Constraint> constraints, @NonNull IContext componentContext, @NonNull IRegistersDatabaseAPI mcuRegisters) {
        String reverseExpr;
        HashMap<@NonNull String, @NonNull IConfigElementItem> valueConfigItems = new HashMap<String, IConfigElementItem>();
        HashMap<@NonNull String, @NonNull BitFieldAssign> assigns = new HashMap();
        HashMap<@NonNull String, @NonNull Expression> conditions = new HashMap<String, Expression>();
        NodeList assignsElements = valueItem.getElementsByTagName("assigns");
        NodeList valueFieldElement = valueItem.getElementsByTagName("value_field");
        Node node = valueFieldElement.item(0);
        String string = reverseExpr = node == null ? null : Objects.requireNonNull(node.getAttributes()).getNamedItem("description").getNodeValue();
        if (assignsElements.getLength() == 1) {
            Element assignElement = (Element)assignsElements.item(0);
            assert (assignElement != null);
            assigns = ComponentParser.parseAssigns(assignElement, componentContext, mcuRegisters);
        }
        String description = UtilsText.safeString((String)valueItem.getAttribute("description"));
        NodeList constraintElements = valueItem.getElementsByTagName("constraint");
        int j = 0;
        while (j < constraintElements.getLength()) {
            Element constraintElement = (Element)constraintElements.item(j);
            assert (constraintElement != null);
            Constraint constraint = ComponentParser.parseConstraint(constraintElement, String.valueOf(id) + "." + id, componentContext);
            if (constraint != null) {
                constraints.add(constraint);
            }
            ++j;
        }
        ConfigElementItem item = new ConfigElementItem(id, description, assigns, conditions, description, reverseExpr);
        valueConfigItems.put(id, item);
        return valueConfigItems;
    }

    private static @NonNull Map<@NonNull String, @NonNull IConfigElementItem> parseRangeItems(@NonNull Element rangeItem, String id, @NonNull IContext componentContext, @NonNull IRegistersDatabaseAPI mcuRegisters) throws ParserException {
        HashMap<@NonNull String, @NonNull IConfigElementItem> rangeItems = new HashMap<String, IConfigElementItem>();
        Element assign = ComponentParser.getElementByTagName(rangeItem, "assign");
        String register = UtilsText.safeString((String)assign.getAttribute("register"));
        String bitField = UtilsText.safeString((String)assign.getAttribute("bit_field"));
        String valueMapping = UtilsText.safeString((String)rangeItem.getAttribute("value_mapping"));
        Map<@NonNull String, @NonNull String> items = ComponentParser.parseValueMapping(valueMapping);
        String bitFieldId = componentContext.getBitFieldId(register, bitField);
        BitFieldElement bf = ClocksBitFieldProvider.getBitFieldById(bitFieldId, mcuRegisters);
        if (bf == null) {
            throw new ParserException(String.valueOf(bitFieldId) + ": no such bitfield exists in config element " + id);
        }
        items.forEach((k, v) -> {
            HashMap<@NonNull @NonNull String, @NonNull @NonNull BitFieldAssign> assigns = new HashMap<String, BitFieldAssign>();
            BitFieldAssign bitFieldAssign = new BitFieldAssign(bitFieldId);
            bitFieldAssign.addAssign(Expression.EXPRESSION_TRUE, Long.valueOf(v));
            assigns.put(bitFieldId, bitFieldAssign);
            rangeItems.put((String)k, new ConfigElementItem((String)k, (String)k, (Map<String, BitFieldAssign>)assigns, (Map<String, Expression>)new HashMap<String, Expression>(), ""));
        });
        return rangeItems;
    }

    private static @NonNull Map<@NonNull String, @NonNull IConfigElementItem> parseItems(Element elem, String parentID, @NonNull List<@NonNull Constraint> constraints, @NonNull IContext componentContext, @NonNull IRegistersDatabaseAPI mcuRegisters) {
        LinkedHashMap<@NonNull String, @NonNull IConfigElementItem> items = new LinkedHashMap<String, IConfigElementItem>();
        NodeList itemElements = elem.getElementsByTagName("item");
        int i = 0;
        while (i < itemElements.getLength()) {
            @NonNull HashMap<@NonNull String, BitFieldAssign> assigns = new HashMap();
            HashMap<@NonNull String, @NonNull Expression> conditions = new HashMap<String, Expression>();
            Element itemElement = (Element)Objects.requireNonNull(itemElements.item(i));
            String id = UtilsText.safeString((String)itemElement.getAttribute("id"));
            String description = UtilsText.safeString((String)itemElement.getAttribute("description"));
            NodeList longDescElements = itemElement.getElementsByTagName("long_description");
            String longDesc = longDescElements.getLength() == 1 ? Objects.requireNonNull(longDescElements.item(0)).getTextContent() : null;
            NodeList assignsElements = itemElement.getElementsByTagName("assigns");
            if (assignsElements.getLength() == 1) {
                Element assignElement = (Element)assignsElements.item(0);
                assert (assignElement != null);
                assigns = ComponentParser.parseAssigns(assignElement, componentContext, mcuRegisters);
            }
            NodeList constraintElements = itemElement.getElementsByTagName("constraint");
            int j = 0;
            while (j < constraintElements.getLength()) {
                Element constraintElement = (Element)constraintElements.item(j);
                assert (constraintElement != null);
                Constraint constraint = ComponentParser.parseConstraint(constraintElement, String.valueOf(parentID) + "." + id, componentContext);
                if (constraint != null) {
                    constraints.add(constraint);
                }
                ++j;
            }
            ConfigElementItem item = new ConfigElementItem(id, description, assigns, conditions, longDesc);
            items.put(id, item);
            ++i;
        }
        return items;
    }

    private static @NonNull Map<@NonNull String, @NonNull BitFieldAssign> parseAssigns(@NonNull Element elem, @NonNull IContext componentContext, @NonNull IRegistersDatabaseAPI mcuRegisters) {
        HashMap<@NonNull String, @NonNull BitFieldAssign> assigns = new HashMap<String, BitFieldAssign>();
        NodeList assignElements = elem.getElementsByTagName("assign");
        int i = 0;
        while (i < assignElements.getLength()) {
            Element assignElement = (Element)Objects.requireNonNull(assignElements.item(i));
            String register = UtilsText.safeString((String)assignElement.getAttribute("register"));
            String bitField = UtilsText.safeString((String)assignElement.getAttribute("bit_field"));
            String value = UtilsText.safeString((String)assignElement.getAttribute("value"));
            String whenExpression = UtilsText.safeString((String)assignElement.getAttribute("when"));
            String bitFieldId = componentContext.getBitFieldId(register, bitField);
            BitFieldElement bf = ClocksBitFieldProvider.getBitFieldById(bitFieldId, mcuRegisters);
            if (bf != null) {
                Long longValue = 0L;
                Expression valueExpression = null;
                try {
                    longValue = Long.valueOf(value);
                }
                catch (NumberFormatException numberFormatException) {
                    valueExpression = Expression.create(value, componentContext);
                }
                Expression condition = Expression.EXPRESSION_TRUE;
                if (!whenExpression.isEmpty()) {
                    condition = Expression.create(whenExpression, componentContext);
                }
                BitFieldAssign bitFieldAssign = null;
                if (assigns.containsKey(bf.getID())) {
                    bitFieldAssign = Objects.requireNonNull((BitFieldAssign)assigns.get(bf.getID()));
                    bitFieldAssign.addAssign(condition, longValue);
                    bitFieldAssign.setExpression(valueExpression);
                } else {
                    bitFieldAssign = new BitFieldAssign(bf.getID());
                    bitFieldAssign.addAssign(condition, longValue);
                    bitFieldAssign.setExpression(valueExpression);
                }
                assigns.put(bf.getID(), bitFieldAssign);
            } else {
                LOGGER.warning(String.valueOf(bitFieldId) + ": not found");
            }
            ++i;
        }
        return assigns;
    }

    private static @NonNull ClockSource parseClockSource(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull IContext componentContext, @NonNull Map<@NonNull String, @NonNull Pin> pins) throws ParserException {
        String simpleID = UtilsText.safeString((String)elem.getAttribute("id"));
        ClockElementData elementData = ComponentParser.parseElementData(componentID, mcuRegisters, elem, constraints, instanceMapping, componentContext, true);
        String defaultFrequency = "";
        boolean internal = false;
        boolean trimmable = false;
        ArrayList<@NonNull Frequency> frequencies = new ArrayList<Frequency>();
        ArrayList<@NonNull Pin> includedPins = new ArrayList<Pin>();
        HashMap<@NonNull Expression, @NonNull ValueMap> values = new HashMap<Expression, ValueMap>();
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "external_source".equals(node.getNodeName())) {
                internal = false;
                Element externalInputElement = (Element)node;
                defaultFrequency = ComponentParser.parseExternalInput(elementData.getId(), constraints, frequencies, externalInputElement, mcuRegisters, componentContext, values, pins, includedPins);
            } else if (node.getNodeType() == 1 && "internal_source".equals(node.getNodeName())) {
                Element internalInputElement = (Element)node;
                defaultFrequency = ComponentParser.parseInternalInput(internalInputElement, elementData.getId(), componentContext, values, constraints, frequencies, mcuRegisters);
                trimmable = internalInputElement.getElementsByTagName("trimmed").getLength() != 0;
                internal = true;
            }
            ++i;
        }
        ComponentParser.createPinSoftEnableConditions(includedPins, simpleID, componentContext);
        return new ClockSource(elementData, internal, trimmable, frequencies, defaultFrequency, values, includedPins);
    }

    private static void createPinSoftEnableConditions(@NonNull List<@NonNull Pin> includedPins, @NonNull String id, @NonNull IContext componentContext) {
        for (Pin pin : includedPins) {
            EnableSetting pinEnable = pin.getEnableSetting();
            if (pinEnable == null) continue;
            Expression softEnableCondition = pinEnable.getSoftEnableCondition();
            Expression clockEnableCondition = Expression.create(String.valueOf(id) + "." + "enable", componentContext);
            if (softEnableCondition != null) {
                pinEnable.setSoftEnableCondition(new Expression(OperatorType.OR, componentContext, softEnableCondition, clockEnableCondition));
                continue;
            }
            pinEnable.setSoftEnableCondition(clockEnableCondition);
        }
    }

    private static @Nullable String parseExternalInput(@NonNull String id, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull Frequency> frequencies, @NonNull Element elem, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull IContext componentContext, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull Map<@NonNull String, Pin> allPins, @NonNull List<Pin> includedPins) throws ParserException {
        String notSupported = MessageFormat.format("{0}: only one type of succesor supported in external clock source at once [value_map, conditional_block, range]", id);
        boolean rangeParsed = false;
        boolean valueMapParsed = false;
        boolean conditionParsed = false;
        NodeList childNodes = elem.getChildNodes();
        String defaultFrequency = UtilsXmlDom.getOptionalAttr((Element)elem, (String)"default_freq");
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = Objects.requireNonNull(childNodes.item(i));
            if (node.getNodeType() == 1 && "range".equals(node.getNodeName())) {
                if (valueMapParsed || conditionParsed) {
                    LOGGER.warning(notSupported);
                    break;
                }
                rangeParsed = true;
                Element rangeElement = (Element)node;
                Range range = ComponentParser.parseRange(id, constraints, rangeElement, Expression.EXPRESSION_TRUE);
                ValueMap rangeValue = new ValueMap(Expression.EXPRESSION_TRUE, mcuRegisters, false);
                rangeValue.addRequirement(UtilsText.safeString((String)Boolean.toString(true)), "", range);
                values.put(Expression.EXPRESSION_TRUE, rangeValue);
            } else if (node.getNodeType() == 1 && "value_map".equals(node.getNodeName())) {
                if (rangeParsed || conditionParsed) {
                    LOGGER.warning(notSupported);
                    break;
                }
                valueMapParsed = true;
                Element valueMapElement = (Element)node;
                ValueMap valueMap = ComponentParser.parseExternalInputValueMap(id, valueMapElement, mcuRegisters, componentContext, constraints, frequencies, Expression.EXPRESSION_TRUE);
                values.put(Expression.EXPRESSION_TRUE, valueMap);
            } else if (node.getNodeType() == 1 && "conditional_range".equals(node.getNodeName())) {
                if (rangeParsed || valueMapParsed) {
                    LOGGER.warning(notSupported);
                    break;
                }
                conditionParsed = true;
                Element conditionElement = (Element)node;
                NodeList caseElements = conditionElement.getElementsByTagName("case");
                NodeList otherwiseElements = conditionElement.getElementsByTagName("otherwise");
                ArrayList<@NonNull Expression> caseExpressions = new ArrayList<Expression>();
                int j = 0;
                while (j < caseElements.getLength()) {
                    Element caseElement = (Element)Objects.requireNonNull(caseElements.item(j));
                    if (Objects.requireNonNull(caseElement.getParentNode()).equals(conditionElement)) {
                        ComponentParser.parseClockSourceConditions(id, constraints, frequencies, mcuRegisters, componentContext, caseElement, values, caseExpressions);
                    } else {
                        LOGGER.warning("Unsupported syntax of the conditional block in element: " + id);
                    }
                    ++j;
                }
                if (otherwiseElements.getLength() == 1) {
                    Element otherwiseElement = (Element)otherwiseElements.item(0);
                    assert (otherwiseElement != null);
                    ComponentParser.parseClockSourceConditions(id, constraints, frequencies, mcuRegisters, componentContext, otherwiseElement, values, caseExpressions);
                } else {
                    LOGGER.warning("Unsupported syntax of the conditional block in element: " + id);
                }
            } else if (node.getNodeType() == 1 && "pin".equals(node.getNodeName())) {
                Element e = (Element)node;
                String pinId = e.getAttribute("id");
                NodeList pinChildNodes = node.getChildNodes();
                if (allPins.containsKey(pinId)) {
                    List<@NonNull EnableDisableCondition> enableConditions = ComponentParser.parseEnableAndConstraints(id, pinChildNodes, componentContext, constraints, false);
                    Pin pin = Objects.requireNonNull(allPins.get(pinId));
                    pin.setEnableSetting(new EnableSetting(pin.getID(), (IElement)pin, enableConditions));
                    includedPins.add(pin);
                } else {
                    LOGGER.warning("Clock source " + id + " refers to pin " + pinId + ", but no such pin exist");
                }
            }
            ++i;
        }
        return defaultFrequency;
    }

    private static void parseClockSourceConditions(@NonNull String id, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull Frequency> frequencies, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull IContext componentContext, @NonNull Element elem, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull List<@NonNull Expression> caseExpressions) throws ParserException {
        String condition = UtilsText.safeString((String)elem.getAttribute("cond_expr"));
        String powerModes = UtilsText.safeString((String)elem.getAttribute("power_modes"));
        Expression condExpr = (condition = ComponentParser.createPowerModesCondition(condition, powerModes)).isEmpty() ? Expression.EXPRESSION_TRUE : Expression.create(condition, componentContext);
        Expression fullCaseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, condExpr, componentContext);
        caseExpressions.add(Expression.negate(condExpr, componentContext));
        condExpr = fullCaseExpr;
        int k = 0;
        while (k < elem.getChildNodes().getLength()) {
            Node caseNode = Objects.requireNonNull(elem.getChildNodes().item(k));
            if (caseNode.getNodeType() == 1 && "range".equals(caseNode.getNodeName())) {
                Element rangeElement = (Element)caseNode;
                Range range = ComponentParser.parseRange(id, constraints, rangeElement, condExpr);
                ValueMap rangeValue = new ValueMap(Expression.EXPRESSION_TRUE, mcuRegisters, false);
                rangeValue.addRequirement(UtilsText.safeString((String)Boolean.toString(true)), "", range);
                values.put(condExpr, rangeValue);
            } else if (caseNode.getNodeType() == 1 && "value_map".equals(caseNode.getNodeName())) {
                Element valueMapElement = (Element)caseNode;
                ValueMap valueMap = ComponentParser.parseExternalInputValueMap(id, valueMapElement, mcuRegisters, componentContext, constraints, frequencies, condExpr);
                values.put(condExpr, valueMap);
            }
            ++k;
        }
    }

    private static @NonNull ValueMap parseExternalInputValueMap(@NonNull String id, @NonNull Element elem, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull IContext componentContext, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull Frequency> frequencies, @NonNull Expression condExpr) throws ParserException {
        String exprValue = UtilsText.safeString((String)elem.getAttribute("expr"));
        NodeList valueMapRanges = elem.getElementsByTagName("range");
        NodeList valueMapSettings = elem.getElementsByTagName("setting");
        ValueMap valueMap = null;
        if (valueMapRanges.getLength() > 0 && valueMapSettings.getLength() == 0) {
            valueMap = new ValueMap(ExpressionUtils.createOrDefault(exprValue, componentContext), mcuRegisters, false);
            int j = 0;
            while (j < valueMapRanges.getLength()) {
                Element rangeElement = (Element)valueMapRanges.item(j);
                if (rangeElement != null) {
                    String ctrlValue = UtilsText.safeString((String)rangeElement.getAttribute("ctrl_value"));
                    Range range = ComponentParser.parseRange(id, constraints, rangeElement, new Expression(OperatorType.AND, componentContext, condExpr, Expression.create(String.valueOf(exprValue) + "==" + ctrlValue, componentContext)));
                    valueMap.addRequirement(Expression.create(ctrlValue, componentContext).resolve().getString(), "", range);
                }
                ++j;
            }
        } else if (valueMapRanges.getLength() == 0 && valueMapSettings.getLength() > 0) {
            valueMap = ComponentParser.parseFrequencyValueMap(componentContext, frequencies, elem, mcuRegisters);
        } else {
            throw new ParserException("Element :'" + id + "' contains both frequency and range in value map element");
        }
        return valueMap;
    }

    private static @NonNull Range parseRange(@NonNull String id, @NonNull List<@NonNull Constraint> constraints, @NonNull Element rangeElement, @NonNull Expression condExpr) {
        Constraint rangeConstraint = new Constraint(id);
        rangeConstraint.setRestriction(condExpr);
        String min = UtilsText.safeString((String)rangeElement.getAttribute("min_freq"));
        String max = UtilsText.safeString((String)rangeElement.getAttribute("max_freq"));
        String description = UtilsText.safeString((String)rangeElement.getAttribute("description"));
        rangeConstraint.add("min_freq", min);
        rangeConstraint.add("max_freq", max);
        rangeConstraint.add("description", description);
        constraints.add(rangeConstraint);
        Range range = new Range(min, max, description);
        return range;
    }

    public static @NonNull List<@NonNull EnableDisableCondition> parseEnableAndConstraints(@NonNull String elementID, @NonNull NodeList nodes, @NonNull IContext componentContext, @NonNull List<@NonNull Constraint> constraints, boolean disableWarnings) {
        List<Object> conditions = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Element constraintElement;
            Constraint constraint;
            Node node = Objects.requireNonNull(nodes.item(i));
            if (node.getNodeType() == 1 && "conditional_block".equals(node.getNodeName())) {
                Element condBlock = (Element)node;
                List<@NonNull EnableDisableCondition> conditionsParsed = ComponentParser.parseConditionalBlock(elementID, condBlock, componentContext, constraints, disableWarnings);
                if (conditions == null) {
                    if (!conditionsParsed.isEmpty()) {
                        conditions = conditionsParsed;
                    }
                } else if (!disableWarnings) {
                    LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
                }
            } else if (node.getNodeType() == 1 && "enable".equals(node.getNodeName())) {
                Element enableElement = (Element)node;
                if (conditions == null) {
                    conditions = CollectionsUtils.asList((Object)ComponentParser.parseEnableDisableElement(enableElement, true, componentContext));
                } else {
                    LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
                }
            } else if (node.getNodeType() == 1 && "disable".equals(node.getNodeName())) {
                Element disableElement = (Element)node;
                if (conditions == null) {
                    conditions = CollectionsUtils.asList((Object)ComponentParser.parseEnableDisableElement(disableElement, false, componentContext));
                } else {
                    LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
                }
            } else if (node.getNodeType() == 1 && "constraint".equals(node.getNodeName()) && (constraint = ComponentParser.parseConstraint(constraintElement = (Element)node, elementID, componentContext)) != null) {
                constraints.add(constraint);
            }
            ++i;
        }
        if (conditions == null) {
            conditions = new ArrayList(0);
        }
        return conditions;
    }

    private static @NonNull List<@NonNull EnableDisableCondition> parseConditionalBlock(@NonNull String elementID, @NonNull Element elem, @NonNull IContext componentContext, @NonNull List<@NonNull Constraint> constraints, boolean disableWarnings) {
        Expression caseExpr;
        ArrayList<@NonNull EnableDisableCondition> enableDisables = new ArrayList<EnableDisableCondition>();
        ArrayList<@NonNull Expression> caseExpressions = new ArrayList<Expression>();
        NodeList cases = elem.getElementsByTagName("case");
        int i = 0;
        while (i < cases.getLength()) {
            Element caseElement = (Element)Objects.requireNonNull(cases.item(i));
            caseExpr = ComponentParser.parseCondition(caseElement, componentContext);
            Expression fullCaseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, caseExpr, componentContext);
            caseExpressions.add(Expression.negate(caseExpr, componentContext));
            caseExpr = fullCaseExpr;
            NodeList enables = caseElement.getElementsByTagName("enable");
            NodeList disables = caseElement.getElementsByTagName("disable");
            NodeList constraintElements = caseElement.getElementsByTagName("constraint");
            NodeList valueMapElements = caseElement.getElementsByTagName("value_map");
            assert (constraintElements != null);
            if (valueMapElements.getLength() == 1) {
                Element valueMap = (Element)valueMapElements.item(0);
                assert (valueMap != null);
            } else {
                ComponentParser.parseConditionalConstraints(elementID, componentContext, constraints, caseExpr, constraintElements);
            }
            if (enables.getLength() == 1) {
                Element enableElement = (Element)enables.item(0);
                assert (enableElement != null);
                enableDisables.add(ComponentParser.parseEnableDisableElement(enableElement, true, caseExpr, componentContext));
            } else if (disables.getLength() == 1) {
                Element disableElement = (Element)disables.item(0);
                assert (disableElement != null);
                enableDisables.add(ComponentParser.parseEnableDisableElement(disableElement, false, caseExpr, componentContext));
            } else if (!disableWarnings) {
                LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
            }
            ++i;
        }
        NodeList otherwise = elem.getElementsByTagName("otherwise");
        if (otherwise.getLength() == 1) {
            Element otherwiseElement = (Element)Objects.requireNonNull(otherwise.item(0));
            caseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, Expression.EXPRESSION_TRUE, componentContext);
            NodeList enables = otherwiseElement.getElementsByTagName("enable");
            NodeList disables = otherwiseElement.getElementsByTagName("disable");
            NodeList constraintElements = otherwiseElement.getElementsByTagName("constraint");
            assert (constraintElements != null);
            NodeList valueMapElements = otherwiseElement.getElementsByTagName("value_map");
            if (valueMapElements.getLength() == 1) {
                Element valueMap = (Element)valueMapElements.item(0);
                assert (valueMap != null);
                ComponentParser.parseValueMapConstraints(elementID, componentContext, constraints, valueMap);
            } else {
                ComponentParser.parseConditionalConstraints(elementID, componentContext, constraints, caseExpr, constraintElements);
            }
            if (enables.getLength() == 1) {
                Element enableElement = (Element)enables.item(0);
                assert (enableElement != null);
                enableDisables.add(ComponentParser.parseEnableDisableElement(enableElement, true, caseExpr, componentContext));
            } else if (disables.getLength() == 1) {
                Element disableElement = (Element)disables.item(0);
                assert (disableElement != null);
                enableDisables.add(ComponentParser.parseEnableDisableElement(disableElement, false, caseExpr, componentContext));
            } else if (!disableWarnings) {
                LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
            }
        }
        return enableDisables;
    }

    private static @NonNull Expression appendNegatedCaseConditions(@NonNull List<@NonNull Expression> caseExpressions, @NonNull Expression caseExpr, @NonNull IContext componentContext) {
        Expression fullCaseExpr = caseExpr;
        for (Expression previousCase : caseExpressions) {
            fullCaseExpr = new Expression(OperatorType.AND, componentContext, fullCaseExpr, previousCase);
        }
        return fullCaseExpr;
    }

    private static void parseValueMapConstraints(@NonNull String elementID, @NonNull IContext componentContext, @NonNull List<@NonNull Constraint> constraints, @NonNull Element valueMap) {
        NodeList valueMapChildNodes = valueMap.getChildNodes();
        int i = 0;
        while (i < valueMapChildNodes.getLength()) {
            Element valueMapItem;
            String uiVal;
            if (valueMapChildNodes.item(i) instanceof Element && !UtilsText.isEmpty((String)(uiVal = (valueMapItem = (Element)Objects.requireNonNull(valueMapChildNodes.item(i))).getAttribute("expr")))) {
                NodeList constraintElements = valueMapItem.getElementsByTagName("constraint");
                int j = 0;
                while (j < constraintElements.getLength()) {
                    if (constraintElements.item(j) instanceof Element) {
                        Element constraintElement = (Element)constraintElements.item(j);
                        assert (constraintElement != null);
                        Constraint constraint = ComponentParser.parseConstraint(constraintElement, elementID, componentContext);
                        if (constraint != null) {
                            constraint.setRestriction(Expression.create(UtilsText.safeString((String)uiVal), componentContext));
                            constraints.add(constraint);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static @NonNull List<@NonNull Constraint> parsePrescalerConstraints(@NonNull String elementID, @NonNull IContext componentContext, @NonNull List<@NonNull Constraint> constraints, @NonNull Element valueMap) {
        NodeList valueMapChildNodes = valueMap.getChildNodes();
        ArrayList<@NonNull Constraint> prescalerConstraints = new ArrayList<Constraint>();
        int i = 0;
        while (i < valueMapChildNodes.getLength()) {
            Constraint constraint;
            Element valueMapItem;
            String uiVal;
            if (valueMapChildNodes.item(i) instanceof Element && !UtilsText.isEmpty((String)(uiVal = (valueMapItem = (Element)Objects.requireNonNull(valueMapChildNodes.item(i))).getAttribute("cond_expr"))) && (constraint = ComponentParser.parseConstraint(valueMapItem, elementID, componentContext)) != null) {
                constraints.add(constraint);
                prescalerConstraints.add(constraint);
            }
            ++i;
        }
        return prescalerConstraints;
    }

    private static void parseConditionalConstraints(@NonNull String elementID, @NonNull IContext componentContext, @NonNull List<@NonNull Constraint> constraints, @NonNull Expression caseExpr, @NonNull NodeList constraintElements) {
        int j = 0;
        while (j < constraintElements.getLength()) {
            Element constraintElement = (Element)constraintElements.item(j);
            assert (constraintElement != null);
            Constraint constraint = ComponentParser.parseConstraint(constraintElement, elementID, componentContext);
            if (constraint != null) {
                Expression restriction = constraint.getRestriction();
                if (restriction != null) {
                    constraint.setRestriction(new Expression(OperatorType.OR, componentContext, restriction, caseExpr));
                } else {
                    constraint.setRestriction(caseExpr);
                }
                constraints.add(constraint);
            }
            ++j;
        }
    }

    private static @NonNull EnableDisableCondition parseEnableDisableElement(@NonNull Element elem, boolean isEnable, @Nullable Expression caseExpr, @NonNull IContext componentContext) {
        Expression expr = ComponentParser.parseCondition(elem, componentContext);
        if (caseExpr != null) {
            return new EnableDisableCondition(caseExpr, expr, UtilsText.safeString((String)elem.getAttribute("description")), isEnable);
        }
        return new EnableDisableCondition(expr, UtilsText.safeString((String)elem.getAttribute("description")), isEnable);
    }

    private static @NonNull EnableDisableCondition parseEnableDisableElement(@NonNull Element elem, boolean isEnable, @NonNull IContext componentContext) {
        return ComponentParser.parseEnableDisableElement(elem, isEnable, null, componentContext);
    }

    private static @NonNull Expression parseCondition(@NonNull Element elem, @NonNull IContext componentContext) {
        String condExpr = elem.getAttribute("cond_expr");
        String powerModes = elem.getAttribute("power_modes");
        String powerModesExpr = "";
        if (!powerModes.isEmpty()) {
            powerModesExpr = Converter.convertPowerModesToExpr(powerModes);
        }
        return new Expression(OperatorType.AND, componentContext, condExpr.isEmpty() ? Expression.EXPRESSION_TRUE : Expression.create(condExpr, componentContext), powerModesExpr.isEmpty() ? Expression.EXPRESSION_TRUE : Expression.create(powerModesExpr));
    }

    private static @NonNull String parseInternalInput(@NonNull Element elem, @NonNull String id, @NonNull IContext componentContext, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull Frequency> frequencies, @NonNull IRegistersDatabaseAPI mcuRegisters) {
        NodeList inputChildNodes = elem.getChildNodes();
        String defaultFrequency = "0 Hz";
        int i = 0;
        while (i < inputChildNodes.getLength()) {
            Node node = Objects.requireNonNull(inputChildNodes.item(i));
            if (node.getNodeType() == 1 && "trimmed".equals(node.getNodeName())) {
                Element trimedFreqElement = (Element)node;
                defaultFrequency = UtilsText.safeString((String)trimedFreqElement.getAttribute("default_freq"));
                NodeList rangeElements = trimedFreqElement.getElementsByTagName("range");
                if (rangeElements.getLength() == 1) {
                    Element rangeElement = (Element)rangeElements.item(0);
                    assert (rangeElement != null);
                    ComponentParser.parseRange(id, constraints, rangeElement, Expression.EXPRESSION_TRUE);
                }
            } else if (node.getNodeType() == 1 && "fixed_frequency".equals(node.getNodeName())) {
                String frequency;
                Element fixedFreq = (Element)node;
                defaultFrequency = frequency = UtilsText.safeString((String)fixedFreq.getAttribute("freq"));
                Frequency parsedFrequency = Frequency.parse((String)UtilsText.safeString((String)frequency));
                if (parsedFrequency != null) {
                    frequencies.add(parsedFrequency);
                } else {
                    LOGGER.warning("Fixed frequency is not valid frequency format ( {frequency_value}{Hz|kHz|MHz} )");
                }
            } else if (node.getNodeType() == 1 && "value_map".equals(node.getNodeName())) {
                Element valueMapElement = (Element)node;
                ValueMap valueMap = ComponentParser.parseFrequencyValueMap(componentContext, frequencies, valueMapElement, mcuRegisters);
                values.put(Expression.EXPRESSION_TRUE, valueMap);
            }
            ++i;
        }
        return defaultFrequency;
    }

    private static @NonNull ValueMap parseFrequencyValueMap(@NonNull IContext componentContext, @NonNull List<@NonNull Frequency> frequencies, @NonNull Element valueMapElement, @NonNull IRegistersDatabaseAPI mcuRegisters) {
        String exprValue = UtilsText.safeString((String)valueMapElement.getAttribute("expr"));
        ValueMap valueMap = new ValueMap(ExpressionUtils.createOrDefault(exprValue, componentContext), mcuRegisters, false);
        NodeList settings = valueMapElement.getElementsByTagName("setting");
        if (settings.getLength() > 0) {
            int j = 0;
            while (j < settings.getLength()) {
                Element settingElement = (Element)settings.item(j);
                if (settingElement != null) {
                    String ctrlValue = UtilsText.safeString((String)settingElement.getAttribute("ctrl_value"));
                    String freq = UtilsText.safeString((String)settingElement.getAttribute("freq"));
                    Frequency frequency = Frequency.parse((String)freq);
                    if (frequency != null) {
                        frequencies.add(frequency);
                        valueMap.addRequirement(ExpressionUtils.createOrDefault(ctrlValue, componentContext).resolve().getString(), "", frequency);
                    }
                }
                ++j;
            }
        }
        return valueMap;
    }

    private static @NonNull Prescaler parsePrescaler(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull IContext componentContext, boolean internal) throws ParserException {
        ClockElementData elementData = ComponentParser.parseElementData(componentID, mcuRegisters, elem, constraints, instanceMapping, componentContext, internal);
        ENodeType elementType = null;
        boolean isDivider = false;
        boolean isMaster = false;
        HashSet<@NonNull String> masters = new HashSet<String>();
        HashSet<@NonNull String> ratios = new HashSet<String>();
        HashMap<@NonNull Expression, @NonNull ValueMap> values = new HashMap<Expression, ValueMap>();
        Expression expressionTrue = Expression.EXPRESSION_TRUE;
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            List<Constraint> constraint;
            Element divideElement;
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "divide".equals(node.getNodeName())) {
                divideElement = (Element)node;
                constraint = ComponentParser.parsePrescalerConstraints(elementData.getId(), componentContext, constraints, divideElement);
                ComponentParser.parseDivideMultiply(elementData.getId(), divideElement, mcuRegisters, componentContext, values, expressionTrue, constraint);
                isDivider = true;
            } else if (node.getNodeType() == 1 && "multiply".equals(node.getNodeName())) {
                divideElement = (Element)node;
                constraint = ComponentParser.parsePrescalerConstraints(elementData.getId(), componentContext, constraints, divideElement);
                ComponentParser.parseDivideMultiply(elementData.getId(), divideElement, mcuRegisters, componentContext, values, expressionTrue, constraint);
            } else if (node.getNodeType() == 1 && "value_map".equals(node.getNodeName())) {
                Element valeMapElement = (Element)node;
                ValueMap value = ComponentParser.parsePrescalerValueMap(mcuRegisters, elementData.getId(), valeMapElement, componentContext);
                ComponentParser.parseValueMapConstraints(elementData.getId(), componentContext, constraints, valeMapElement);
                assert (value != null);
                values.put(expressionTrue, value);
            } else if (node.getNodeType() == 1 && ("conditional_block".equals(node.getNodeName()) || "conditional_scale".equals(node.getNodeName()))) {
                Element condBlock = (Element)node;
                ComponentParser.parsePrescalerConditionalBlock(condBlock, elementData.getId(), mcuRegisters, componentContext, values);
            } else if (node.getNodeType() == 1 && "interlock_master".equals(node.getNodeName())) {
                isMaster = true;
            } else if (node.getNodeType() == 1 && "interlock_slave".equals(node.getNodeName())) {
                boolean apply;
                Element slave = (Element)node;
                String ratioAttribute = UtilsText.safeString((String)slave.getAttribute("ratios"));
                String master = UtilsText.safeString((String)slave.getAttribute("master"));
                master = componentID.isEmpty() ? master : String.valueOf(componentID) + "." + master;
                String integerDivide = UtilsText.safeString((String)slave.getAttribute("integer_divide_freq"));
                boolean bl = apply = integerDivide.equals(Text.TRUE) || !ratioAttribute.isEmpty();
                if (apply) {
                    List<String> rationals = null;
                    String ratio = UtilsText.safeString((String)slave.getAttribute("max_ratio"));
                    if (!UtilsText.isEmpty((String)ratioAttribute)) {
                        @NonNull String @NonNull [] splittedRationalAttrributes = UtilsText.splitLines((String)ratioAttribute, (String)";");
                        rationals = Arrays.asList(splittedRationalAttrributes);
                    }
                    masters.add(master);
                    if (ratios.isEmpty()) {
                        if (rationals != null) {
                            ratios.addAll(rationals);
                        } else {
                            ratios.add(ratio);
                        }
                    } else if (ratios.size() != 1 || !ratio.equals(ratios.stream().findFirst().get())) {
                        LOGGER.warning(String.valueOf(elementData.getId()) + ": wrong master slave division ratios.");
                    }
                }
            }
            ++i;
        }
        if (elem.getElementsByTagName("divide").getLength() != 0) {
            elementType = isMaster ? (masters.isEmpty() ? ENodeType.DivMaster : ENodeType.DivMasterSlave) : (!masters.isEmpty() ? (masters.size() == 1 ? ENodeType.DivSlave : ENodeType.DivMultiSlave) : ENodeType.Divider);
            isDivider = true;
        } else if (elem.getElementsByTagName("multiply").getLength() != 0) {
            elementType = ENodeType.Multiplier;
        }
        if (elementType == null) {
            throw new ParserException("Missing divide/multiply tag in prescaler element");
        }
        return new Prescaler(elementData, elementType, isDivider, values, masters, ratios);
    }

    public static @NonNull ClockElementData parseElementData(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, String> instanceMapping, @NonNull IContext componentContext, boolean skipInputparsing) throws ParserException {
        String id = ComponentParser.getElementID(componentID, elem);
        String name = elem.getAttribute("name");
        String description = UtilsText.safeString((String)elem.getAttribute("description"));
        String min = elem.getAttribute("min");
        String max = elem.getAttribute("max");
        String powerModeSpecific = UtilsText.safeString((String)elem.getAttribute("power_mode_specific"));
        String inputSignal = skipInputparsing ? "" : ComponentParser.parseInputSignalElement(componentID, id, elem, instanceMapping);
        String priority = elem.getAttribute("master");
        long minScale = min.isEmpty() ? 0L : Long.parseLong(min);
        long maxScale = max.isEmpty() ? Long.MAX_VALUE : Long.parseLong(max);
        boolean isPowerModeSpecific = powerModeSpecific.isEmpty() ? false : Boolean.parseBoolean(powerModeSpecific);
        NodeList childNodes = elem.getChildNodes();
        List<@NonNull EnableDisableCondition> enableDisableConditions = ComponentParser.parseEnableAndConstraints(id, childNodes, componentContext, constraints, true);
        List<@NonNull IConfigElement> configElements = ComponentParser.parseLocalConfigElements(mcuRegisters, elem, constraints, componentContext);
        if ("".equals(id)) {
            throw new ParserException("Element ID must by specified.");
        }
        return new ClockElementData(mcuRegisters, componentContext, id, name, description, inputSignal, constraints, childNodes, enableDisableConditions, configElements, priority.equals(Text.TRUE), minScale, maxScale, isPowerModeSpecific);
    }

    private static void parseDivideMultiply(@NonNull String id, @NonNull Element element, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull IContext componentContext, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull Expression expression, @NonNull List<@NonNull Constraint> constraint) {
        int fractionalBits = ComponentParser.parseFracBits(element, id);
        String expressionValue = element.getAttribute("expr");
        assert (expressionValue != null);
        ValueMap value = ComponentParser.parseValueMapFromMapping(element, expressionValue, componentContext, mcuRegisters);
        value.setDescriptionsEnabled(false);
        value.setFractional(fractionalBits);
        values.put(expression, value);
        value.setConstraint(constraint);
    }

    private static @NonNull ValueMap parseValueMapFromMapping(@NonNull Element element, @NonNull String expressionValue, @NonNull IContext componentContext, @NonNull IRegistersDatabaseAPI mcuRegisters) {
        String valueMapping = UtilsText.safeString((String)element.getAttribute("value_mapping"));
        ValueMap valueMap = new ValueMap(Expression.create(expressionValue, componentContext), mcuRegisters, valueMapping.isEmpty());
        if (!valueMapping.isEmpty()) {
            Map<@NonNull String, @NonNull String> values = ComponentParser.parseValueMapping(valueMapping);
            values.forEach((x, y) -> {
                IValueMapBuilder iValueMapBuilder = valueMap.addRequirement((String)y, (String)x, null);
            });
        }
        return valueMap;
    }

    private static @NonNull Map<@NonNull String, @NonNull String> parseValueMapping(@NonNull String valueMapping) {
        HashMap<@NonNull String, @NonNull String> values = new HashMap<String, String>();
        String[] pairs = valueMapping.split(",");
        int i = 0;
        while (i < pairs.length) {
            String pair = pairs[i];
            String[] tokens = pair.split(":");
            if (tokens.length == 2) {
                values.put(UtilsText.safeString((String)tokens[0]), UtilsText.safeString((String)tokens[1]));
            }
            ++i;
        }
        return values;
    }

    private static int parseFracBits(@NonNull Element element, @NonNull String id) {
        String fracBits = UtilsText.safeString((String)element.getAttribute("frac_bits"));
        int fracBitsInt = 0;
        if (!fracBits.isEmpty()) {
            try {
                fracBitsInt = Integer.parseInt(fracBits);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, String.valueOf(fracBits) + " not parsed properly in element: " + id, e);
            }
        }
        return fracBitsInt;
    }

    private static void parsePrescalerConditionalBlock(@NonNull Element elem, @NonNull String id, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull IContext componentContext, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values) {
        Expression caseExpr;
        NodeList cases = elem.getElementsByTagName("case");
        ArrayList<@NonNull Expression> caseExpressions = new ArrayList<Expression>();
        int j = 0;
        while (j < cases.getLength()) {
            Element caseElement = (Element)cases.item(j);
            assert (caseElement != null);
            caseExpr = ComponentParser.parseCondition(caseElement, componentContext);
            Expression fullCaseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, caseExpr, componentContext);
            caseExpressions.add(Expression.negate(caseExpr, componentContext));
            caseExpr = fullCaseExpr;
            ComponentParser.parseCaseOtherwise(id, mcuRegisters, componentContext, caseExpr, values, caseElement);
            ++j;
        }
        NodeList otherwise = elem.getElementsByTagName("otherwise");
        if (otherwise.getLength() == 1) {
            Element otherwiseElement = (Element)otherwise.item(0);
            caseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, Expression.EXPRESSION_TRUE, componentContext);
            assert (otherwiseElement != null);
            ComponentParser.parseCaseOtherwise(id, mcuRegisters, componentContext, caseExpr, values, otherwiseElement);
        }
    }

    private static void parseCaseOtherwise(@NonNull String id, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull IContext componentContext, @NonNull Expression caseExpr, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull Element element) {
        NodeList valeMapElements = element.getElementsByTagName("value_map");
        NodeList divideElements = element.getElementsByTagName("divide");
        NodeList multiplyElements = element.getElementsByTagName("multiply");
        if (valeMapElements.getLength() == 1) {
            Element valeMapElement = (Element)valeMapElements.item(0);
            assert (valeMapElement != null);
            ValueMap value = ComponentParser.parsePrescalerValueMap(mcuRegisters, id, valeMapElement, componentContext);
            assert (value != null);
            values.put(caseExpr, value);
        } else if (divideElements.getLength() == 1) {
            Element divideElement = (Element)divideElements.item(0);
            assert (divideElement != null);
            ComponentParser.parseDivideMultiply(id, divideElement, mcuRegisters, componentContext, values, caseExpr, new ArrayList<Constraint>());
        } else if (multiplyElements.getLength() == 1) {
            Element multiplyElement = (Element)multiplyElements.item(0);
            assert (multiplyElement != null);
            ComponentParser.parseDivideMultiply(id, multiplyElement, mcuRegisters, componentContext, values, caseExpr, new ArrayList<Constraint>());
        } else {
            LOGGER.warning(String.valueOf(id) + ": Exactly one " + "value_map" + "expected as child of the " + "case" + " element");
        }
    }

    private static @Nullable ValueMap parsePrescalerValueMap(@NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull String id, @NonNull Element element, @NonNull IContext componentContext) {
        Expression valueMapExpr = ExpressionUtils.createOrDefault(UtilsText.safeString((String)element.getAttribute("expr")), componentContext);
        int fractionalBits = ComponentParser.parseFracBits(element, id);
        NodeList modifiers = element.getElementsByTagName("divide");
        if (modifiers.getLength() == 0) {
            modifiers = element.getElementsByTagName("multiply");
        }
        if (modifiers.getLength() > 0) {
            ValueMap valueMap = new ValueMap(valueMapExpr, mcuRegisters, false);
            valueMap.setDescriptionsEnabled(false);
            valueMap.setFractional(fractionalBits);
            int i = 0;
            while (i < modifiers.getLength()) {
                Element valueMapItem = (Element)Objects.requireNonNull(modifiers.item(i));
                String uiVal = UtilsText.safeString((String)valueMapItem.getAttribute("expr"));
                String ctrl_value = UtilsText.safeString((String)valueMapItem.getAttribute("ctrl_value"));
                String value = ctrl_value.isEmpty() ? uiVal : ctrl_value;
                valueMap.addRequirement(Expression.create(value, componentContext).resolve().getString(), uiVal, uiVal);
                ++i;
            }
            return valueMap;
        }
        LOGGER.severe(String.valueOf(id) + ": No divide or multiply element specified!");
        return null;
    }

    public static @Nullable Constraint parseConstraint(@NonNull Element element, @NonNull String parentElementID, @NonNull IContext componentContext) {
        Constraint constraint;
        String elementID = UtilsText.safeString((String)element.getAttribute("element_id"));
        String relatesTo = UtilsText.safeString((String)element.getAttribute("relates_to"));
        String condExpr = UtilsText.safeString((String)element.getAttribute("cond_expr"));
        String when = UtilsText.safeString((String)element.getAttribute("when"));
        String frequencies = UtilsText.safeString((String)element.getAttribute("freq_range"));
        String freq = UtilsText.safeString((String)element.getAttribute("freq"));
        String maxFreq = UtilsText.safeString((String)element.getAttribute("max_freq"));
        String minFreq = UtilsText.safeString((String)element.getAttribute("min_freq"));
        String description = UtilsText.safeString((String)element.getAttribute("description"));
        String powerModes = UtilsText.safeString((String)element.getAttribute("power_modes"));
        String level = UtilsText.safeString((String)element.getAttribute("level"));
        String accuracy = UtilsText.safeString((String)element.getAttribute("accuracy"));
        condExpr = ComponentParser.createPowerModesCondition(condExpr, powerModes);
        boolean isOnInput = relatesTo.equals("input");
        if (elementID.isEmpty()) {
            elementID = parentElementID;
        }
        Constraint constraint2 = constraint = level.isEmpty() ? new Constraint(elementID, isOnInput, Constraint.Level.ERROR) : new Constraint(elementID, isOnInput, level);
        if (!condExpr.isEmpty()) {
            constraint.setCondition(Expression.create(condExpr, componentContext));
        }
        if (!when.isEmpty()) {
            constraint.setRestriction(Expression.create(when, componentContext));
        }
        constraint.add("freq_range", frequencies);
        if (!frequencies.isEmpty()) {
            constraint.getFrequencyRanges();
        }
        constraint.add("freq", freq);
        constraint.add("max_freq", maxFreq);
        constraint.add("min_freq", minFreq);
        constraint.add("description", description);
        if (!accuracy.isEmpty()) {
            try {
                BigRational accuracyRational = new BigRational(new BigDecimal(accuracy));
                constraint.setAccuracy(accuracyRational);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warning("Expected decimal accuracy but got: " + accuracy);
            }
        }
        return constraint;
    }

    private static @NonNull String createPowerModesCondition(@NonNull String condExpr, @NonNull String powerModes) {
        String condition = condExpr;
        if (!powerModes.isEmpty()) {
            String conditionPowerModes = Converter.convertPowerModesToExpr(powerModes);
            condition = condition.isEmpty() ? conditionPowerModes : condition.concat("&&(" + conditionPowerModes + ")");
        }
        return UtilsText.safeString((String)condition);
    }

    private static @NonNull Pll parsePll(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull IContext componentContext) throws ParserException {
        Prescaler divider = null;
        Prescaler multiplier = null;
        Prescaler postDivider = null;
        ClockElementData elementData = ComponentParser.parseElementData(componentID, mcuRegisters, elem, constraints, instanceMapping, componentContext, false);
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Prescaler prescaler;
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "prescaler".equals(node.getNodeName())) {
                Element prescalerElement = (Element)node;
                prescaler = ComponentParser.parsePrescaler(componentID, mcuRegisters, prescalerElement, constraints, instanceMapping, componentContext, true);
                if (prescaler.isDivider()) {
                    divider = prescaler;
                } else {
                    multiplier = prescaler;
                }
            } else if (node.getNodeType() == 1 && "post_divider".equals(node.getNodeName())) {
                Element postDivElement = (Element)node;
                prescaler = ComponentParser.parsePrescaler(componentID, mcuRegisters, ComponentParser.getElementByTagName(postDivElement, "prescaler"), constraints, instanceMapping, componentContext, true);
                if (divider != null) {
                    String originalID = divider.getID();
                    String originalName = divider.getName();
                    String originalDescription = divider.getDescription();
                    postDivider = divider;
                    postDivider.setId(prescaler.getID());
                    postDivider.setName(prescaler.getName());
                    postDivider.setDescription(prescaler.getDescription());
                    divider = prescaler;
                    divider.setId(originalID);
                    divider.setName(originalName);
                    divider.setDescription(originalDescription);
                }
            }
            ++i;
        }
        if (divider == null || multiplier == null) {
            throw new ParserException("PLL must have exactly one divider and one multiplier element.");
        }
        return new Pll(elementData, divider, multiplier, postDivider);
    }

    private static FnPll parseFnPll(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element pllElement, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull IContext componentContext) throws ParserException {
        ClockElementData elementData = ComponentParser.parseElementData(componentID, mcuRegisters, pllElement, constraints, instanceMapping, componentContext, false);
        List<@NonNull FnPllConfigElement> configElements = ComponentParser.parseFnPllConfigElements(elementData);
        List<@NonNull BigRational> suitableFrequencies = ComponentParser.getSuitableFrequencies(pllElement);
        return new FnPll(elementData, configElements, suitableFrequencies, false);
    }

    private static @NonNull List<@NonNull BigRational> getSuitableFrequencies(Element pllElement) throws ParserException {
        ArrayList<@NonNull BigRational> suitableFrequencies = new ArrayList<BigRational>();
        Element selectListElement = ComponentParser.getElementByTagName(pllElement, "fnpll_select_list");
        Element listElement = ComponentParser.getElementByTagName(selectListElement, "list");
        NodeList itemElements = listElement.getElementsByTagName("item");
        int i = 0;
        while (i < itemElements.getLength()) {
            Node node = Objects.requireNonNull(itemElements.item(i));
            if (node.getNodeType() == 1) {
                Element item = (Element)node;
                String value = UtilsText.safeString((String)item.getAttribute("value"));
                try {
                    suitableFrequencies.add(Converter.toHertz(Frequency.parseNonNull((String)value)));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.WARNING, String.valueOf(value) + " is not valid frequency of fnpll select list", e);
                }
            }
            ++i;
        }
        return suitableFrequencies;
    }

    private static @NonNull List<@NonNull FnPllConfigElement> parseFnPllConfigElements(ClockElementData elementData) throws ParserException {
        ArrayList<@NonNull FnPllConfigElement> configElements = new ArrayList<FnPllConfigElement>();
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "fnpll_element".equals(node.getNodeName())) {
                Element confElement = (Element)node;
                String id = String.valueOf(elementData.getId()) + "." + UtilsText.safeString((String)confElement.getAttribute("id"));
                String name = UtilsText.safeString((String)confElement.getAttribute("name"));
                String description = UtilsText.safeString((String)confElement.getAttribute("description"));
                NodeList rangeElements = confElement.getElementsByTagName("range");
                if (rangeElements.getLength() == 1) {
                    Element rangeElement = (Element)Objects.requireNonNull(rangeElements.item(0));
                    String min = UtilsText.safeString((String)rangeElement.getAttribute("min"));
                    String max = UtilsText.safeString((String)rangeElement.getAttribute("max"));
                    String defaultValue = UtilsText.safeString((String)rangeElement.getAttribute("default"));
                    Range range = new Range(BigRational.parse((String)min), BigRational.parse((String)max), false);
                    Map<BitFieldElement, IValueMap> assigns = ComponentParser.parseFnPllAssigns(elementData, confElement, range);
                    configElements.add(new FnPllConfigElement(id, name, description, range, defaultValue, assigns));
                } else {
                    throw new ParserException("Only one range element allowed in fnpll_element");
                }
            }
            ++i;
        }
        return configElements;
    }

    private static @NonNull Map<BitFieldElement, IValueMap> parseFnPllAssigns(@NonNull ClockElementData elementData, @NonNull Element confElement, @NonNull Range range) {
        HashMap<BitFieldElement, IValueMap> assigns = new HashMap<BitFieldElement, IValueMap>();
        NodeList assignsElements = confElement.getElementsByTagName("assigns");
        if (assignsElements.getLength() == 1) {
            NodeList assignElements = ((Element)Objects.requireNonNull(assignsElements.item(0))).getElementsByTagName("assign");
            int j = 0;
            while (j < assignElements.getLength()) {
                Element assignElement = (Element)Objects.requireNonNull(assignElements.item(j));
                String register = UtilsText.safeString((String)assignElement.getAttribute("register"));
                String bitField = UtilsText.safeString((String)assignElement.getAttribute("bit_field"));
                String value = UtilsText.safeString((String)assignElement.getAttribute("value"));
                String bitFieldId = elementData.getComponentContext().getBitFieldId(register, bitField);
                BitFieldElement bf = ClocksBitFieldProvider.getBitFieldById(bitFieldId, elementData.getRegisters());
                Expression assignExpr = Expression.create(value, elementData.getComponentContext());
                BitFieldElement @NonNull [] bitFields = new BitFieldElement[]{};
                Expression reversedExpression = assignExpr.reverse();
                if (reversedExpression != null) {
                    RangeValueMap rangeValueMap = new RangeValueMap(assignExpr, reversedExpression, range, 0, bitFields, elementData.getRegisters());
                    assigns.put(bf, rangeValueMap);
                } else {
                    LOGGER.severe("FNPLL assign with expression: " + value + "can't be resolved!");
                }
                ++j;
            }
        }
        return assigns;
    }

    private static @NonNull ClockSelect parseClockSelect(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull List<@NonNull Constraint> constraints, @NonNull IContext componentContext) throws ParserException {
        ClockElementData elementData = ComponentParser.parseElementData(componentID, mcuRegisters, elem, constraints, instanceMapping, componentContext, false);
        HashMap<@NonNull Expression, @NonNull ValueMap> values = new HashMap<Expression, ValueMap>();
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "value_map".equals(node.getNodeName())) {
                Element switchElement = (Element)node;
                ValueMap valueMap = ComponentParser.parseClockSelectValueMap(switchElement, mcuRegisters, componentID, instanceMapping, componentContext);
                values.put(Expression.EXPRESSION_TRUE, valueMap);
            } else if (node.getNodeType() == 1 && ("conditional_block".equals(node.getNodeName()) || "conditional_select".equals(node.getNodeName()))) {
                Element conditionalValue = (Element)node;
                ComponentParser.parseClockSelectConditonalBlock(conditionalValue, elementData.getId(), componentID, componentContext, values, mcuRegisters, instanceMapping);
            }
            ++i;
        }
        return new ClockSelect(elementData, values);
    }

    private static void parseClockSelectConditonalBlock(@NonNull Element element, @NonNull String elementID, @NonNull String componentID, @NonNull IContext componentContext, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Map<@NonNull String, @NonNull String> instanceMapping) {
        Expression caseExpr;
        ArrayList<@NonNull Expression> caseExpressions = new ArrayList<Expression>();
        NodeList cases = element.getElementsByTagName("case");
        int j = 0;
        while (j < cases.getLength()) {
            Element caseElement = (Element)Objects.requireNonNull(cases.item(j));
            caseExpr = ComponentParser.parseCondition(caseElement, componentContext);
            Expression fullCaseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, caseExpr, componentContext);
            caseExpressions.add(Expression.negate(caseExpr, componentContext));
            NodeList valueMapElements = caseElement.getElementsByTagName("value_map");
            if (valueMapElements.getLength() == 1) {
                Element valueMapElement = (Element)valueMapElements.item(0);
                assert (valueMapElement != null);
                ValueMap valueMap = ComponentParser.parseClockSelectValueMap(valueMapElement, mcuRegisters, componentID, instanceMapping, componentContext);
                values.put(fullCaseExpr, valueMap);
            } else {
                LOGGER.warning(String.valueOf(elementID) + ": Exactly one value_map element expected in case/otherwise element");
            }
            ++j;
        }
        NodeList otherwise = element.getElementsByTagName("otherwise");
        if (otherwise.getLength() == 1) {
            Element otherwiseElement = (Element)Objects.requireNonNull(otherwise.item(0));
            caseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, Expression.EXPRESSION_TRUE, componentContext);
            NodeList valueMapElements = otherwiseElement.getElementsByTagName("value_map");
            if (valueMapElements.getLength() == 1) {
                Element valueMapElement = (Element)valueMapElements.item(0);
                assert (valueMapElement != null);
                ValueMap valueMap = ComponentParser.parseClockSelectValueMap(valueMapElement, mcuRegisters, componentID, instanceMapping, componentContext);
                values.put(caseExpr, valueMap);
            } else {
                LOGGER.warning(String.valueOf(elementID) + ": Exactly one value_map element expected in case/otherwise element");
            }
        }
    }

    private static @NonNull ValueMap parseClockSelectValueMap(@NonNull Element element, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull String componentID, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull IContext componentContext) {
        String expressionValue = UtilsText.safeString((String)element.getAttribute("expr"));
        ValueMap valueMap = new ValueMap(ExpressionUtils.createOrDefault(expressionValue, componentContext), mcuRegisters, false);
        NodeList switchElementchildNodes = element.getChildNodes();
        int j = 0;
        while (j < switchElementchildNodes.getLength()) {
            Element inputElement;
            Node inputNode = Objects.requireNonNull(switchElementchildNodes.item(j));
            if (inputNode.getNodeType() == 1 && "input".equals(inputNode.getNodeName())) {
                inputElement = (Element)inputNode;
                ComponentParser.parseSelectorInput(inputElement, valueMap, componentID, instanceMapping);
            } else if (inputNode.getNodeType() == 1 && "no_clock".equals(inputNode.getNodeName())) {
                inputElement = (Element)inputNode;
                ComponentParser.parseNoClock(inputElement, valueMap);
            }
            ++j;
        }
        return valueMap;
    }

    private static void parseNoClock(Element inputElement, ValueMap values) {
        String expressionControlValue = UtilsText.safeString((String)inputElement.getAttribute("ctrl_value"));
        String controlValueResolved = Expression.create(expressionControlValue).resolve().getString();
        String signalName = UtilsText.safeString((String)inputElement.getAttribute("name"));
        values.addRequirement(controlValueResolved, signalName.isEmpty() ? "No clock" : signalName, "NO_CLOCK");
    }

    private static void parseSelectorInput(@NonNull Element inputElement, @NonNull ValueMap values, @NonNull String componentID, @NonNull Map<@NonNull String, @NonNull String> instanceMapping) {
        String expressionControlValue = UtilsText.safeString((String)inputElement.getAttribute("ctrl_value"));
        String signalName = UtilsText.safeString((String)inputElement.getAttribute("name"));
        String signal = UtilsText.safeString((String)ComponentParser.parseInputSignalElement(componentID, signalName, inputElement, instanceMapping));
        if (signal.endsWith(".clk")) {
            signal = signal.substring(0, signal.length() - ".clk".length());
        }
        String controlValueResolved = expressionControlValue.isEmpty() ? "" : Expression.create(expressionControlValue).resolve().getString();
        values.addRequirement(controlValueResolved, signalName.isEmpty() ? null : signalName, signal);
    }

    private static @NonNull Fll parseFll(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull IContext componentContext) throws ParserException {
        Prescaler multiplier = null;
        ClockElementData elementData = ComponentParser.parseElementData(componentID, mcuRegisters, elem, constraints, instanceMapping, componentContext, false);
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "prescaler".equals(node.getNodeName())) {
                Element prescalerElement = (Element)node;
                Prescaler prescaler = ComponentParser.parsePrescaler(componentID, mcuRegisters, prescalerElement, constraints, new HashMap<String, String>(), componentContext, true);
                if (!prescaler.isDivider()) {
                    multiplier = prescaler;
                } else {
                    throw new AssertionError((Object)"FLL must have exactly one divider and one multiplier element.");
                }
            }
            ++i;
        }
        if (multiplier == null) {
            throw new ParserException("PLL must have exactly one divider and one multiplier element.");
        }
        Fll fll = new Fll(elementData, multiplier);
        return fll;
    }

    static @NonNull String parseInputSignalElement(@NonNull String componentID, @NonNull String elementID, @NonNull Element elem, @NonNull Map<@NonNull String, String> instanceMapping) {
        String inputSignalWithoutExt;
        Element input;
        if ("input".equals(elem.getNodeName())) {
            input = elem;
        } else {
            NodeList inputs = elem.getElementsByTagName("input");
            input = null;
            if (inputs.getLength() == 0) {
                LOGGER.warning(String.format(String.valueOf(elementID) + ": " + "Exactly one '%s' tag expected, but %s parsed.", "input", Integer.toString(inputs.getLength())));
            } else {
                input = (Element)inputs.item(0);
            }
        }
        String inputSignal = "";
        if (input != null) {
            String simpleID = input.getAttribute("signal");
            String string = inputSignal = componentID.isEmpty() ? simpleID : String.valueOf(componentID) + "." + simpleID;
        }
        if (instanceMapping.containsKey(inputSignalWithoutExt = inputSignal.replace(".clk", ""))) {
            inputSignal = instanceMapping.get(inputSignalWithoutExt);
        }
        return UtilsText.safeString((String)inputSignal);
    }

    private static @NonNull String getElementID(@NonNull String componentID, @NonNull Element elem) {
        String simpleID = UtilsText.safeString((String)elem.getAttribute("id"));
        return componentID.isEmpty() ? simpleID : String.valueOf(componentID) + "." + simpleID;
    }

    private static @NonNull ClockGate parseClockGate(@NonNull String componentID, @NonNull IRegistersDatabaseAPI mcuRegisters, @NonNull Element elem, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull List<@NonNull Constraint> constraints, @NonNull IContext componentContext) throws ParserException {
        ClockElementData elementData = ComponentParser.parseElementData(componentID, mcuRegisters, elem, constraints, instanceMapping, componentContext, false);
        return new ClockGate(elementData);
    }
}

