/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.data.settings.AGeneralSetting;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.ClockOutputSetting;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SettingsDB {
    @NonNull
    final @NonNull Collection<@NonNull ClockSourceSetting> clockSources = new ArrayList<ClockSourceSetting>();
    @NonNull
    final @NonNull Collection<@NonNull ClockOutputSetting> clockOutputs = new ArrayList<ClockOutputSetting>();
    @NonNull
    final @NonNull Collection<@NonNull AGeneralSetting> generalSettings = new ArrayList<AGeneralSetting>();
    @NonNull
    final @NonNull Collection<@NonNull AGlobalSetting> globalSettings = new ArrayList<AGlobalSetting>();
    @NonNull
    final @NonNull Collection<@NonNull ISetting> powerModeSpecificSettings = new ArrayList<ISetting>();
    @NonNull
    final @NonNull Map<@NonNull String, @NonNull ISetting> allSettings = new HashMap<String, ISetting>();

    SettingsDB() {
    }

    public @NonNull Collection<@NonNull ClockSourceSetting> getClockSources() {
        return CollectionsUtils.unmodifiableCollection(this.clockSources);
    }

    public @NonNull Collection<@NonNull ClockOutputSetting> getClockOutputs() {
        return CollectionsUtils.unmodifiableCollection(this.clockOutputs);
    }

    public @NonNull Collection<@NonNull AGlobalSetting> getGlobalSettings() {
        return CollectionsUtils.unmodifiableCollection(this.globalSettings);
    }

    public @NonNull Collection<@NonNull AGeneralSetting> getGeneralSettings() {
        return CollectionsUtils.unmodifiableCollection(this.generalSettings);
    }

    public @NonNull Collection<@NonNull ISetting> getAllSettings() {
        return CollectionsUtils.unmodifiableCollection(this.allSettings.values());
    }

    public @NonNull Collection<@NonNull ISetting> getAllEnableSettings() {
        return CollectionsUtils.unmodifiableCollection((Collection)((Collection)this.allSettings.values().stream().filter(x -> x.getType() == SettingType.ENABLE_DISABLE).collect(CollectorsUtils.toList())));
    }

    public @NonNull Collection<@NonNull ISetting> getAllConfigElementSettings() {
        return CollectionsUtils.unmodifiableCollection((Collection)((Collection)this.allSettings.values().stream().filter(x -> x.getType() == SettingType.GLOBAL_CONFIG_ELEMENT || x.getType() == SettingType.LOCAL_CONFIG_ELEMENT).collect(CollectorsUtils.toList())));
    }

    public @NonNull Collection<@NonNull ISetting> getAllBitFieldSettings() {
        return CollectionsUtils.unmodifiableCollection((Collection)((Collection)this.allSettings.values().stream().filter(x -> x.getType() == SettingType.BIT_FIELD).collect(CollectorsUtils.toList())));
    }

    public @NonNull Collection<@NonNull ISetting> getPowerModeSpecificSettings() {
        return CollectionsUtils.unmodifiableCollection(this.powerModeSpecificSettings);
    }

    public @Nullable ISetting findSettingWithId(@NonNull String id) {
        return this.allSettings.get(id);
    }

    public @Nullable ISetting findPowerModeSpecificSettingWithId(@NonNull String id, @NonNull String powerMode) {
        Optional<@NonNull ISetting> result = this.powerModeSpecificSettings.stream().filter(x -> Objects.equals(x.getPowerMode(), powerMode) && Objects.equals(x.getId(), String.valueOf(powerMode) + ":" + id)).findFirst();
        return (ISetting)CollectionsUtils.nullableOptionalGet(result);
    }

    public static class Builder {
        @NonNull
        private final @NonNull Collection<@NonNull ClockSourceSetting> clockSources = new LinkedHashSet<ClockSourceSetting>();
        @NonNull
        private final @NonNull Collection<@NonNull ClockOutputSetting> clockOutputs = new LinkedHashSet<ClockOutputSetting>();
        @NonNull
        private final @NonNull Collection<@NonNull AGeneralSetting> generalSettings = new LinkedHashSet<AGeneralSetting>();
        @NonNull
        private final @NonNull Collection<@NonNull AGlobalSetting> globalSettings = new LinkedHashSet<AGlobalSetting>();
        @NonNull
        final @NonNull Collection<@NonNull ISetting> powerModeSpecificSettings = new LinkedHashSet<ISetting>();
        @NonNull
        private final @NonNull Map<@NonNull String, @NonNull ISetting> allSettings = new HashMap<String, ISetting>();

        public @NonNull Builder addClockSource(@NonNull ClockSourceSetting clockSource) {
            this.clockSources.add(clockSource);
            this.addToAllSettings(clockSource);
            return this;
        }

        public @NonNull Builder addClockOutput(@NonNull ClockOutputSetting clockOutput) {
            this.clockOutputs.add(clockOutput);
            this.addToAllSettings(clockOutput);
            return this;
        }

        public @NonNull Builder addGlobalSetting(@NonNull AGlobalSetting globalSetting) {
            this.globalSettings.add(globalSetting);
            this.addToAllSettings(globalSetting);
            return this;
        }

        public @NonNull Builder addGeneralSetting(@NonNull AGeneralSetting generalSetting) {
            this.generalSettings.add(generalSetting);
            this.addToAllSettings(generalSetting);
            return this;
        }

        public @NonNull Builder addPowerModeSpecificSetting(@NonNull ISetting setting) {
            this.powerModeSpecificSettings.add(setting);
            return this;
        }

        private void addToAllSettings(@NonNull ISetting setting) {
            this.allSettings.put(setting.getId(), setting);
        }

        public @NonNull Collection<@NonNull ISetting> getAllSettings() {
            return CollectionsUtils.unmodifiableCollection(this.allSettings.values());
        }

        public @NonNull SettingsDB build() {
            SettingsDB settingsDB = new SettingsDB();
            settingsDB.clockOutputs.addAll(this.clockOutputs);
            settingsDB.clockSources.addAll(this.clockSources);
            settingsDB.globalSettings.addAll(this.globalSettings);
            settingsDB.generalSettings.addAll(this.generalSettings);
            settingsDB.powerModeSpecificSettings.addAll(this.powerModeSpecificSettings);
            settingsDB.allSettings.putAll(this.allSettings);
            return settingsDB;
        }
    }
}

