/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.OutputFrequencySetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class SettingsConfig
implements Cloneable {
    @NonNull
    public static final BigRational DEFAULT_ACCURACY = new BigRational(1, 1000);
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SettingsConfig.class);
    @NonNull
    private final @NonNull Map<@NonNull ISetting, @Nullable SettingValue> settingValues = new HashMap<ISetting, SettingValue>();
    @NonNull
    private final @NonNull Map<@NonNull ISetting, LockState> lockedSettings = new HashMap<ISetting, LockState>();
    @NonNull
    private final @NonNull Set<@NonNull ISetting> nonEditableSettings = new HashSet<ISetting>();
    @NonNull
    private final @NonNull Set<@NonNull ISetting> nonVisibleSettings = new HashSet<ISetting>();
    @NonNull
    private final @NonNull Set<@NonNull ISetting> invalidSettings = new HashSet<ISetting>();
    @NonNull
    private final @NonNull Set<@NonNull ISetting> userEnabledSettings = new HashSet<ISetting>();
    @NonNull
    private final @NonNull Map<@NonNull ISetting, @Nullable SettingValue> lastlyChanged = new HashMap<ISetting, SettingValue>();

    public void setSettingValue(@NonNull ISetting setting, @NonNull SettingValue value) {
        SettingValue currentValue = this.settingValues.get(setting);
        if (!value.equals(currentValue)) {
            SettingValue lastValue = this.lastlyChanged.get(setting);
            if (!value.equals(lastValue)) {
                if (lastValue == null) {
                    this.lastlyChanged.put(setting, currentValue);
                }
            } else {
                this.lastlyChanged.remove(setting);
            }
        }
        this.settingValues.put(setting, value);
    }

    public boolean isLastlyChanged(@NonNull ISetting setting) {
        return this.lastlyChanged.containsKey(setting);
    }

    public @NonNull SettingValue getSettingValue(@NonNull ISetting setting) {
        SettingValue settingValue = this.settingValues.get(setting);
        if (settingValue == null) {
            LOGGER.warning(() -> MessageFormat.format("Setting value of \"{0}\" has not been initialized yet.", setting.getId()));
            return setting instanceof OutputFrequencySetting ? SettingValue.FREQ_N_A : SettingValue.N_A;
        }
        return settingValue;
    }

    public boolean isLocked(@NonNull ISetting setting) {
        return this.lockedSettings.containsKey(setting);
    }

    public void lockSettingIfNotLocked(@NonNull ISetting setting) {
        if (!this.lockedSettings.containsKey(setting)) {
            this.lockSetting(setting);
        }
    }

    public void clearChanges() {
        this.lastlyChanged.clear();
    }

    public void lockSetting(@NonNull ISetting setting) {
        BigRational accuracy = null;
        SettingValue value = this.getSettingValue(setting);
        if (setting.getType() == SettingType.FREQUENCY_OUTPUT) {
            accuracy = DEFAULT_ACCURACY;
        }
        LockState lockState = new LockState(setting, value, accuracy);
        this.lockedSettings.put(setting, lockState);
    }

    public void updateLock(@NonNull ISetting setting, @NonNull SettingValue value) {
        LockState prevState = this.getLockState(setting);
        if (prevState != null) {
            LockState lockState = new LockState(prevState, value);
            this.lockedSettings.put(setting, lockState);
        } else {
            this.lockSetting(setting);
        }
    }

    public void unlockSetting(@NonNull ISetting setting) {
        this.lockedSettings.remove(setting);
    }

    public boolean isEditable(@NonNull ISetting setting) {
        return !this.nonEditableSettings.contains(setting);
    }

    public void addNonEditableSetting(@NonNull ISetting setting) {
        this.nonEditableSettings.add(setting);
    }

    public void removeNonEditableSetting(@NonNull ISetting setting) {
        this.nonEditableSettings.remove(setting);
    }

    public void clearNonEditableSettings() {
        this.nonEditableSettings.clear();
    }

    public boolean isVisible(@NonNull ISetting setting) {
        return !this.nonVisibleSettings.contains(setting);
    }

    public void setInvisivbleSettings(@NonNull Set<@NonNull ISetting> invisibles) {
        this.nonVisibleSettings.clear();
        this.nonVisibleSettings.addAll(invisibles);
    }

    public @NonNull Set<@NonNull ISetting> getInvalidSettings() {
        return CollectionsUtils.unmodifiableSet(this.invalidSettings);
    }

    public boolean isInvalid(@NonNull ISetting setting) {
        return this.invalidSettings.contains(setting);
    }

    public void invalidate(@NonNull ISetting setting) {
        this.invalidSettings.add(setting);
    }

    public void validate(@NonNull ISetting setting) {
        this.invalidSettings.remove(setting);
    }

    public void clearInvalid() {
        this.invalidSettings.clear();
    }

    protected @NonNull SettingsConfig clone() {
        SettingsConfig clone = new SettingsConfig();
        clone.settingValues.putAll(this.settingValues);
        clone.lockedSettings.putAll(this.lockedSettings);
        clone.invalidSettings.addAll(this.invalidSettings);
        clone.userEnabledSettings.addAll(this.userEnabledSettings);
        clone.lastlyChanged.putAll(this.lastlyChanged);
        clone.nonEditableSettings.addAll(this.nonEditableSettings);
        clone.nonVisibleSettings.addAll(this.nonVisibleSettings);
        return clone;
    }

    public @NonNull Map<@NonNull ISetting, LockState> getLockedSettings() {
        return CollectionsUtils.unmodifiableMap(this.lockedSettings);
    }

    public Map<ISetting, SettingValue> getSettingValues() {
        return CollectionsUtils.unmodifiableMap(this.settingValues);
    }

    public @Nullable BigRational getLockAccuracy(@NonNull ISetting setting) {
        LockState lockState = this.lockedSettings.get(setting);
        if (lockState != null) {
            return lockState.getAccuracy();
        }
        return null;
    }

    public @Nullable LockState getLockState(@NonNull ISetting setting) {
        return this.lockedSettings.get(setting);
    }

    public void setLockState(@NonNull ISetting setting, @NonNull LockState lockState) {
        this.lockedSettings.put(setting, lockState);
    }

    public void changeLockAccuracy(@NonNull ISetting setting, @NonNull BigRational accuracy) {
        LockState oldState = this.lockedSettings.get(setting);
        if (oldState != null && setting.getType() == SettingType.FREQUENCY_OUTPUT) {
            LockState newState = new LockState(oldState, accuracy);
            this.lockedSettings.put(setting, newState);
        } else {
            LOGGER.warning("Trying to set accuracy of not-explicitly locked or not-frequency setting: " + setting.getId());
        }
    }

    public void setUserEnabled(@NonNull ISetting setting, boolean enabled) {
        if (enabled) {
            this.userEnabledSettings.add(setting);
        } else {
            this.userEnabledSettings.remove(setting);
        }
    }

    public boolean isUserEnabled(ISetting setting) {
        return this.userEnabledSettings.contains(setting);
    }
}

