/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.model;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.clocks.data.elements.ComputationalModel;
import com.nxp.swtools.clocks.data.model.EmptyConfig;
import com.nxp.swtools.clocks.data.model.EmptyMcu;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.utils.scripting.ScriptResult;
import java.util.ArrayList;
import java.util.List;

public class EmptyProfile
implements IClocksProfile {
    @NonNull
    private final @NonNull List<@NonNull IClocksConfig> configs = new ArrayList<IClocksConfig>();
    @NonNull
    private final IMcu mcu;
    @NonNull
    private final IClocksConfig activeConfig;
    @NonNull
    private final StorageClocksTool storageTool = new StorageClocksTool();
    @NonNull
    private final ScriptResult generationResult;

    public EmptyProfile(@NonNull String reason) {
        this.mcu = new EmptyMcu(reason);
        this.activeConfig = new EmptyConfig(this.mcu, reason);
        this.activeConfig.setProfile(this);
        this.configs.add(this.activeConfig);
        this.generationResult = new ScriptResult.Builder().appendError(reason).fail().build();
    }

    @Override
    public @NonNull IMcu getMcu() {
        return this.mcu;
    }

    @Override
    public @NonNull IMcuDescriptor getMcuDescriptor() {
        return this.mcu.getMcuDescriptor();
    }

    @Override
    public @NonNull List<@NonNull IClocksConfig> getConfigs() {
        return this.configs;
    }

    @Override
    public @Nullable IClocksConfig getActiveConfig() {
        return this.activeConfig;
    }

    @Override
    public @NonNull IClocksConfig resetToDefaults(@NonNull IClocksConfig config) {
        return this.activeConfig;
    }

    @Override
    public @NonNull IClocksConfig resetActiveConfigToDefaults() {
        return this.activeConfig;
    }

    @Override
    public void recomputeActiveConfig(boolean forceAuto) {
    }

    @Override
    public boolean containsErrors() {
        return true;
    }

    @Override
    public @NonNull IClocksConfig createDefaultConfig() {
        return this.activeConfig;
    }

    @Override
    public void setActiveConfig(@NonNull IClocksConfig config) {
    }

    @Override
    public @Nullable IClocksConfig removeConfig(@NonNull IClocksConfig config) {
        return null;
    }

    @Override
    public @NonNull IClocksProfile clone(boolean useSameModel) {
        return this;
    }

    @Override
    public @NonNull StorageClocksTool toStorageProfile(@Nullable StorageClocksTool prevProfile) {
        if (prevProfile != null) {
            this.storageTool.setUpdateCode(prevProfile.getUpdateCode());
        }
        return this.storageTool;
    }

    @Override
    public void addConfig(@NonNull IClocksConfig config) {
    }

    @Override
    public void switchPositionsOf(@NonNull IClocksConfig config1, @NonNull IClocksConfig config2) {
    }

    @Override
    public void addConfigToPos(@NonNull IClocksConfig config, int position) {
    }

    @Override
    public @Nullable String getBoard() {
        return null;
    }

    @Override
    public @Nullable String getKit() {
        return null;
    }

    @Override
    public void regenerateCode() {
    }

    @Override
    public @NonNull ScriptResult getGeneratedCode() {
        return this.generationResult;
    }

    @Override
    public @NonNull ScriptResult getLastWorkingGeneratedCode() {
        return this.generationResult;
    }

    @Override
    public @NonNull IClocksConfig resetToStorageConfig(@NonNull IClocksConfig config, @NonNull StorageClocksConfiguration storageConfig) {
        return config;
    }

    @Override
    public @NonNull IClocksConfig resetActiveConfigToStorageConfig(@NonNull StorageClocksConfiguration storageConfig) {
        return this.activeConfig;
    }

    @Override
    public @NonNull String createUniqueConfigName() {
        return "";
    }

    @Override
    public void removeAllConfigs() {
    }

    @Override
    public void addConfigs(@NonNull List<@NonNull IClocksConfig> configurations) {
    }

    @Override
    public @Nullable IClocksConfig getConfigByName(@NonNull String configName) {
        return null;
    }

    @Override
    public boolean isYamlEnabled() {
        return false;
    }

    @Override
    public void setYamlEnabled(boolean generateYaml) {
    }

    @Override
    public @NonNull ComputationalModel getModel() {
        return ComputationalModel.createEmptyFor(this.getMcu());
    }

    @Override
    public boolean updateConfig(@NonNull IClocksConfig config) {
        return false;
    }
}

