/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ConfigElement;
import com.nxp.swtools.clocks.data.elements.EnableDisableCondition;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.ClocksProblem;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.ASetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.GlobalConfigElementSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.LocalConfigElementSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.ConfigContext;
import com.nxp.swtools.clocks.expression.DefaultContext;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.Expression;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValueConfigElement
implements IConfigElement {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(ConfigElement.class);
    @NonNull
    private String id;
    @NonNull
    private String name;
    @NonNull
    private String description;
    @NonNull
    IConfigElementItem valueItem;
    @NonNull
    String defaultItem;
    @NonNull
    ISetting setting;
    @NonNull
    @NonNull List<@NonNull Constraint> constraints;
    @Nullable
    EnableSetting enableSetting;
    private boolean isPowerModeSpecific;

    public ValueConfigElement(@NonNull String id, @NonNull String name, @NonNull String description, @NonNull IConfigElementItem item, @NonNull String defaultItem, boolean global, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull EnableDisableCondition> enableDisableConditions) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.valueItem = item;
        this.defaultItem = defaultItem;
        this.setting = global ? new GlobalConfigElementSetting(this) : new LocalConfigElementSetting(this);
        this.constraints = constraints;
        if (!enableDisableConditions.isEmpty()) {
            this.enableSetting = new EnableSetting(id, (IElement)this, enableDisableConditions);
        }
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String getID() {
        return this.id;
    }

    @Override
    public @NonNull String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        EnableSetting enableSetting = this.getEnableSetting();
        if (enableSetting != null) {
            config.getSettingsConfig().setSettingValue(enableSetting, enableSetting.createCurrentValue(config));
            return enableSetting.isEnabled(config);
        }
        return true;
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return this.enableSetting;
    }

    @Override
    public @Nullable Collection<@NonNull IConfigElementItem> getItems() {
        return null;
    }

    @Override
    public @NonNull Collection<@NonNull String> getItemNames() {
        return Arrays.asList(this.valueItem.getName());
    }

    @Override
    public @NonNull String getDefaultItem() {
        return this.defaultItem;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public @Nullable IConfigElementItem getActiveItem(@NonNull IClocksConfig config) {
        return this.valueItem;
    }

    @Override
    public @NonNull ISetting getSetting() {
        return this.setting;
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        String exp = this.valueItem.getReverseExpr();
        if (config.isImporting() && exp != null) {
            try {
                Expression revExp = Expression.create((String)exp);
                ConfigContext configContext = new ConfigContext(DefaultContext.getInstance(), config);
                IValue valueExpressionResult = revExp.resolve((IContext)configContext);
                BigInteger value = valueExpressionResult.getRational().toBigIntegerRounded(false);
                return new SettingValue(value.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.log(Level.SEVERE, "Fail parsing expression: " + this.id);
                return new SettingValue(BigRational.ZERO.toString());
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Fail resolving setting: " + this.id);
                return new SettingValue(BigRational.ZERO.toString());
            }
        }
        return config.getSettingsConfig().getSettingValue(this.setting);
    }

    @Override
    public @NonNull List<@NonNull Constraint> getElementConstraints(@NonNull IClocksConfig clocksConfig) {
        IConfigElementItem activeItem = this.getActiveItem(clocksConfig);
        if (activeItem != null) {
            return this.getConstraintsOf(activeItem.getID());
        }
        return CollectionsUtils.emptyList();
    }

    @Override
    public @NonNull Collection<@NonNull String> getAllControledSettings(@NonNull IMcu mcu) {
        HashSet<@NonNull String> bitFieldSettings = new HashSet<String>();
        this.valueItem.getUsedBitFields().forEach(x -> SettingProvider.addBitFieldSetting(bitFieldSettings, x, mcu));
        return bitFieldSettings;
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        HashSet<@NonNull String> dependencies = new HashSet<String>();
        dependencies.addAll(this.valueItem.getDependencies(mcu));
        dependencies.remove(this.id);
        return dependencies;
    }

    @Override
    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull String item, @NonNull IClocksConfig config) {
        @NonNull HashMap<@NonNull ISetting, @NonNull SettingValue> bitFieldSettings = new HashMap<ISetting, SettingValue>();
        IConfigElementItem configElementItem = this.valueItem;
        Set<Map.Entry<@NonNull String, @NonNull Long>> assignEntries = configElementItem.getBitFieldsToAssignForConfig(config).entrySet();
        for (Map.Entry<String, Long> assignEntry : assignEntries) {
            ISetting bitFieldSetting = SettingProvider.getBitFieldSetting(assignEntry.getKey(), config.getMcu());
            if (bitFieldSetting == null) continue;
            SettingValue settingValue = bitFieldSetting.parseValue(assignEntry.getValue(), config);
            if (settingValue == null) {
                Range range = bitFieldSetting.getRangeOfValues(config);
                if (range != null && range.getMax().longValue() < assignEntry.getValue()) {
                    config.addError(this.id, MessageFormat.format(Messages.get().BitFieldSetting_Overflow, assignEntry.getKey()), ClocksProblem.Type.LOCAL);
                }
                throw new UnsupportedOperationException();
            }
            bitFieldSettings.put(bitFieldSetting, settingValue);
        }
        return bitFieldSettings;
    }

    @Override
    public List<@NonNull Constraint> getConstraintsOf(@NonNull String itemId) {
        return (List)this.constraints.stream().filter(x -> x.getElementID().equals(String.valueOf(this.id) + "." + itemId)).collect(CollectorsUtils.toList());
    }

    @Override
    public @NonNull Collection<@NonNull String> getItemsBitFields() {
        return this.valueItem.getUsedBitFields();
    }

    @Override
    public boolean isSharingRegisters(@NonNull IClocksConfig config) {
        return false;
    }

    @Override
    public @NonNull List<@NonNull ISetting> getSharedList() {
        return new ArrayList<ISetting>();
    }

    @Override
    public @NonNull Map<@NonNull String, ISetting> createPowerModeSpecificSettings(@NonNull List<@NonNull PowerMode> powerModes) {
        HashMap<@NonNull String, ISetting> result = new HashMap<String, ISetting>();
        if (this.isPowerModeSpecific()) {
            powerModes.forEach(x -> {
                ASetting powerModeSpecificSetting = this.setting instanceof GlobalConfigElementSetting ? new GlobalConfigElementSetting(this) : new LocalConfigElementSetting(this);
                powerModeSpecificSetting.setPowerMode(x.getID());
                result.put(powerModeSpecificSetting.getId(), powerModeSpecificSetting);
            });
        }
        return result;
    }

    @Override
    public void setPowerModeSpecific(boolean isPowerModeSpecific) {
        this.isPowerModeSpecific = isPowerModeSpecific;
    }

    @Override
    public boolean isPowerModeSpecific() {
        return this.isPowerModeSpecific;
    }
}

