/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SettingIdResolver {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SettingIdResolver.class);
    @NonNull
    private static final Pattern PATTERN_ID = Pattern.compile("\\{\\{(\\w+)\\}\\}");

    public static @NonNull String resolve(@NonNull String text, @NonNull IMcu mcu) {
        Matcher matcher = PATTERN_ID.matcher(text);
        StringBuffer resolvedBuilder = new StringBuffer();
        while (matcher.find()) {
            String id = UtilsText.safeString((String)matcher.group(1));
            matcher.appendReplacement(resolvedBuilder, SettingIdResolver.resolveId(id, mcu));
        }
        matcher.appendTail(resolvedBuilder);
        return UtilsText.safeString((String)resolvedBuilder.toString());
    }

    private static @NonNull String resolveId(@NonNull String id, @NonNull IMcu mcu) {
        ISetting setting = SettingProvider.getSettingById(id, mcu);
        if (setting == null) {
            LOGGER.warning("Setting does not exist: " + id);
            return id;
        }
        return setting.getName();
    }
}

