/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.PrescalerSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ClockModel;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class Prescaler
extends AClockElement {
    @NonNull
    private static final String DEFAULT_SCALE = "1";
    private boolean isDivider;
    private long minScale;
    private long maxScale;

    public Prescaler(ClockElementData elementData, @NonNull ENodeType type, boolean isDivider, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull Collection<@NonNull String> masters, @NonNull Collection<@NonNull String> ratios) {
        super(elementData.getRegisters(), elementData.getId(), elementData.getName(), elementData.getDescription(), elementData.getInputSignal(), elementData.getConstraints(), elementData.getConfigElements(), elementData.isPrioritized());
        super.setPowerModeSpecific(elementData.isPowerModeSpecific);
        PrescalerSetting prescalerSetting = new PrescalerSetting(this);
        this.addNestedSetting(prescalerSetting);
        this.isDivider = isDivider;
        this.values = values;
        this.minScale = elementData.getMinScale();
        this.maxScale = elementData.getMaxScale();
        EnableSetting enableSetting = new EnableSetting(this.id, (IElement)this, elementData.getEnableDisableConditions());
        enableSetting.setAutoDisableCondition(Expression.create(String.valueOf(this.id) + "." + "scale" + "==" + BigInteger.ZERO.toString()));
        this.addNestedSetting(enableSetting);
        this.modelDevice = new PrescalerModel(this.id, type, masters, ratios);
    }

    @Override
    public String getType() {
        return ElementType.PRESCALER.toString();
    }

    @Override
    public @NonNull Map<@NonNull String, ISetting> createPowerModeSpecificSettings(@NonNull List<@NonNull PowerMode> powerModes) {
        HashMap<@NonNull String, ISetting> result = new HashMap<String, ISetting>();
        if (this.isPowerModeSpecific()) {
            powerModes.forEach(x -> {
                PrescalerSetting powerModeSpecificSetting = new PrescalerSetting(this);
                powerModeSpecificSetting.setPowerMode(x.getID());
                result.put(powerModeSpecificSetting.getId(), powerModeSpecificSetting);
                this.configElements.forEach(p -> {
                    p.setPowerModeSpecific(true);
                    result.putAll(p.createPowerModeSpecificSettings(powerModes));
                });
            });
            this.powerModeSpecificSettings.putAll(result);
        }
        return result;
    }

    public long getMinScale() {
        return this.minScale;
    }

    public long getMaxScale() {
        return this.maxScale;
    }

    public boolean isDivider() {
        return this.isDivider;
    }

    public @NonNull List<@NonNull String> getUiScaleValues(@Nullable IClocksConfig clocksConfig) {
        BigRational minRational = new BigRational(this.minScale);
        BigRational maxRational = new BigRational(this.maxScale);
        List<@NonNull Object> sortedScaleValues = new ArrayList();
        ValueMap activeValueMap = this.getActiveValueMap(clocksConfig);
        if (activeValueMap != null) {
            sortedScaleValues = activeValueMap.getSortedUiValues();
        }
        return (List)sortedScaleValues.stream().filter(x -> this.isInRange(BigRational.tryParse((String)x), minRational, maxRational)).collect(CollectorsUtils.toList());
    }

    public @NonNull List<@NonNull BigRational> getScaleValues(@Nullable IClocksConfig clocksConfig) {
        BigRational minRational = new BigRational(this.minScale);
        BigRational maxRational = new BigRational(this.maxScale);
        ValueMap activeValueMap = this.getActiveValueMap(clocksConfig);
        ArrayList<@NonNull BigRational> sortedScaleValues = new ArrayList<BigRational>();
        if (activeValueMap != null) {
            for (Object controlValueObject : activeValueMap.getControlValues()) {
                String controlValue = UtilsText.safeToString((Object)controlValueObject);
                try {
                    BigRational intValue = BigRational.tryParse((String)controlValue);
                    if (intValue == null) continue;
                    sortedScaleValues.add(intValue);
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.WARNING, String.valueOf(this.id) + ": scale value not an integer " + controlValue, e);
                }
            }
        }
        return (List)sortedScaleValues.stream().filter(x -> this.isInRange((BigRational)x, minRational, maxRational)).collect(CollectorsUtils.toList());
    }

    boolean isInRange(@Nullable BigRational x, @NonNull BigRational min, @NonNull BigRational max) {
        return x == null ? false : x.compareTo(min) >= 0 && x.compareTo(max) <= 0;
    }

    private void updateTiming(@NonNull Node compNode, @NonNull IClocksConfig config) {
        ModelCreationI.ScaleData scaleData = this.createScaleData(config);
        if (this.isScaleUpdateRequired(scaleData, config)) {
            TimingScale timingScale = ClockModel.makeTimingScale((ModelCreationI.ScaleData)scaleData);
            compNode.setTimingScaleValues(timingScale);
        }
    }

    private boolean isScaleUpdateRequired(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ModelCreationI.ScaleData scaleData, @NonNull IClocksConfig config) {
        TimingScale timingScale = ClockModel.makeTimingScale((ModelCreationI.ScaleData)scaleData);
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            return !compNode.getTimingScaleValues().equals((Object)timingScale);
        }
        return false;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ModelCreationI.ScaleData createSetScaleData(IClocksConfig config) {
        ModelCreationI.ScaleData scaleData = new ModelCreationI.ScaleData(EScaleType.SetSmall);
        ArrayList<@NonNull BigRational> scales = new ArrayList<BigRational>();
        for (BigRational scale : this.getScaleValues(config)) {
            if (BigInteger.ZERO.equals(scale)) continue;
            scales.add(new BigRational(scale));
        }
        Collections.sort(scales);
        scaleData.scalelist = scales;
        return scaleData;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ModelCreationI.ScaleData createLinearScaleData(@NonNull ValueMap activeValueMap) {
        Range range = activeValueMap.getRange();
        assert (range != null);
        BigRational max = new BigRational(this.maxScale);
        BigRational min = new BigRational(this.minScale);
        BigRational high = range.getMax().compareTo(max) < 0 ? range.getMax() : max;
        BigRational low = range.getMin().compareTo(min) > 0 ? range.getMin() : min;
        BigRational step = range.getStep();
        ModelCreationI.ScaleData data = new ModelCreationI.ScaleData(EScaleType.LinearSmall);
        data.step = step;
        data.high = high;
        data.low = low.equals((Object)BigRational.ZERO) ? step : low;
        data.n = high.subtract(low).divide(step).add(BigRational.ONE).getNumerator().longValue();
        return data;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ModelCreationI.ScaleData createCalculatedScaleData(IClocksConfig config) {
        ModelCreationI.ScaleData scaleData = new ModelCreationI.ScaleData(EScaleType.Calculated);
        ValueMap activeValueMap = this.getActiveValueMap(config);
        if (activeValueMap != null) {
            scaleData.calculus = activeValueMap.getCalculus();
        }
        return scaleData;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ModelCreationI.ScaleData createScaleData(@Nullable IClocksConfig config) {
        ValueMap activeValueMap = this.getActiveValueMap(config);
        ModelCreationI.ScaleData data = null;
        data = this.getScaleValues(config).isEmpty() && activeValueMap != null ? this.createLinearScaleData(activeValueMap) : (activeValueMap != null && activeValueMap.isCalculatedValueMap() ? this.createCalculatedScaleData(config) : this.createSetScaleData(config));
        return data;
    }

    public BigInteger getFraction(@NonNull IClocksConfig config) {
        ValueMap activeValueMap = this.getActiveValueMap(config);
        assert (activeValueMap != null);
        return BigInteger.ONE.shiftLeft(activeValueMap.getFractionalBits());
    }

    @Override
    protected void saveToModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        SettingsConfig settingsConfig = config.getSettingsConfig();
        ISetting prescalerSetting = this.getFrequencyModifierSetting();
        assert (prescalerSetting != null);
        SettingValue prescalerSettingValue = settingsConfig.getSettingValue(prescalerSetting);
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            compNode.clean();
            boolean isOutputFreqSaved = this.saveOutputFrequency(config, compNode, lockedOnly, false);
            this.updateTiming(compNode, config);
            if (isOutputFreqSaved) {
                return;
            }
            BigRational currentValue = null;
            if (prescalerSettingValue != SettingValue.N_A) {
                try {
                    currentValue = BigRational.tryParse((String)UtilsText.safeToString((Object)prescalerSettingValue.getValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.warning("Invalid value encountered for element " + this.name + ", using N_A instead.");
                    prescalerSettingValue = SettingValue.N_A;
                }
            }
            if (currentValue != null && currentValue.compareTo(BigRational.ZERO) != 0) {
                compNode.setDefaultScale(new BigRational(currentValue));
                BigRational dividerToSet = null;
                LockState lockState = settingsConfig.getLockState(prescalerSetting);
                if (!lockedOnly || lockState != null) {
                    BigRational bigRational = dividerToSet = lockState == null ? currentValue : BigRational.tryParse((String)UtilsText.safeToString((Object)lockState.getValue().getValue()));
                }
                if (dividerToSet == null) {
                    compNode.setScale(null);
                } else {
                    compNode.setScale(new BigRational(dividerToSet));
                    prescalerSetting.parseUiValue(dividerToSet.toString(), config);
                }
            } else {
                compNode.disable();
            }
        }
    }

    @Override
    public void loadFromModel(@NonNull IClocksConfig config) {
        ISetting prescalerSetting = this.getFrequencyModifierSetting();
        assert (prescalerSetting != null);
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            BigRational scale = compNode.getScale();
            SettingValue value = null;
            if (scale != null) {
                value = prescalerSetting.parseValue(scale, config);
                if (value == null) {
                    value = SettingValue.N_A;
                }
                config.setSettingValue(prescalerSetting, value, false, false);
            } else {
                LOGGER.warning("Not valid scale loaded for element: " + this.id);
            }
        }
    }

    @Override
    public @Nullable SettingValue getEnableValue(@NonNull IClocksConfig config) {
        ValueMap activeValuemap = this.getActiveValueMap(config);
        String newValue = null;
        if (activeValuemap == null) {
            newValue = DEFAULT_SCALE;
        } else {
            Range range = activeValuemap.getRange();
            assert (range != null);
            BigRational minValue = range.getMin();
            if (minValue.equals((Object)BigRational.ZERO)) {
                minValue = minValue.add(range.getStep());
            }
            newValue = minValue.toString();
        }
        ISetting mainSetting = this.getMainSetting();
        assert (mainSetting != null);
        return mainSetting.parseUiValue(newValue, config);
    }

    private class PrescalerModel
    extends AClockModelCreationElement {
        @NonNull
        private ModelCreationI.ScaleData scaleData;
        @NonNull
        @NonNull Collection<@NonNull String> masters;
        @NonNull
        @NonNull Collection<@NonNull String> ratios;

        public PrescalerModel(@NonNull String id, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull @NonNull ENodeType type, @NonNull Collection<@NonNull String> masters, Collection<String> ratios) {
            super(id, type);
            this.scaleData = Prescaler.this.createScaleData(null);
            this.masters = masters;
            this.ratios = ratios;
        }

        @Override
        public String getMasterDiv() {
            String master = (String)CollectionsUtils.nullableOptionalGet(this.masters.stream().findFirst());
            assert (master != null);
            return master;
        }

        @Override
        public @NonNull List<@NonNull String> getListOfMasters() {
            return new ArrayList<String>(this.masters);
        }

        @Override
        public @Nullable BigInteger getMasterSlaveRatio() {
            if (this.ratios.size() == 1) {
                String value = (String)CollectionsUtils.nullableOptionalGet(this.ratios.stream().findFirst());
                assert (value != null);
                try {
                    return new BigInteger(value);
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.WARNING, String.valueOf(value) + " is not valid integer", e);
                }
            }
            return null;
        }

        @Override
        public @Nullable List<@NonNull BigRational> getMasterSlaveAllowedRatios() {
            ArrayList<@NonNull BigRational> rationas = new ArrayList<BigRational>();
            try {
                this.ratios.forEach(x -> {
                    boolean bl = rationas.add(new BigRational(x.trim()));
                });
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, "Not valid rational number", e);
            }
            return rationas;
        }

        @Override
        public BigRational getDefaultScale() {
            ValueMap activeValueMap = Prescaler.this.getActiveValueMap(null);
            if (activeValueMap != null) {
                String defaultValue = UtilsText.safeToString((Object)activeValueMap.getDefaultControlValue());
                return new BigRational(defaultValue);
            }
            return new BigRational(Prescaler.DEFAULT_SCALE);
        }

        @Override
        public ModelCreationI.ScaleData getScaleData() {
            return this.scaleData;
        }
    }
}

