/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.ArrayList;
import java.util.List;

public class Pin
implements IElement {
    @NonNull
    private String mId;
    @NonNull
    private String mName;
    @NonNull
    private Direction mDir;
    @NonNull
    private @NonNull List<@NonNull PeripheralSignalRef> mPeriphSignalRefs;
    @Nullable
    private EnableSetting mSettings;
    @Nullable
    private String mDescription;
    @NonNull
    private String mPeripheral;

    public Pin(@NonNull String id, @NonNull String name, @NonNull Direction dir, @Nullable String description, @NonNull String peripheral) {
        this.mId = id;
        this.mName = name;
        this.mDir = dir;
        this.mPeriphSignalRefs = new ArrayList<PeripheralSignalRef>();
        this.mSettings = null;
        this.mDescription = description;
        this.mPeripheral = peripheral;
    }

    @Override
    public @NonNull String getName() {
        return this.mName;
    }

    @Override
    public @NonNull String getID() {
        return this.mId;
    }

    public @NonNull String getIDForPinsTool() {
        String signal = this.mPeriphSignalRefs.get(0).getSignal();
        if (signal.contains(".")) {
            return signal;
        }
        return String.valueOf(this.mPeripheral) + "." + signal;
    }

    public void setDirection(@NonNull Direction dir) {
        this.mDir = dir;
    }

    public @NonNull Direction getDirection() {
        return this.mDir;
    }

    public void addSignalRef(@NonNull PeripheralSignalRef ref) {
        this.mPeriphSignalRefs.add(ref);
    }

    public @NonNull List<@NonNull PeripheralSignalRef> getSignalRefs() {
        return this.mPeriphSignalRefs;
    }

    public String toString() {
        String str = String.valueOf(this.getClass().getSimpleName()) + ": " + this.mId + "(" + this.mName + ", peripheral: " + this.mPeripheral + "), direction: " + (Object)((Object)this.mDir) + ", signalRefs: " + this.mPeriphSignalRefs;
        if (this.mDescription != null) {
            str = String.valueOf(str) + ", description: " + this.mDescription;
        }
        return str;
    }

    public void setEnableSetting(@NonNull EnableSetting settings) {
        this.mSettings = settings;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        if (this.mSettings != null) {
            return this.mSettings.isEnabled(config);
        }
        return false;
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return this.mSettings;
    }

    @Override
    public @Nullable String getDescription() {
        return this.mDescription;
    }

    public static enum Direction {
        IN("INPUT"),
        OUT("OUTPUT"),
        UNDEFINED("NOT_SPECIFIED");

        @NonNull
        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public @NonNull String getValue() {
            return this.value;
        }
    }

    public static class PeripheralSignalRef {
        @NonNull
        private String mSignal;
        @Nullable
        private String mChannel;

        public PeripheralSignalRef(@NonNull String signal, @Nullable String channel) {
            this.mSignal = signal;
            this.mChannel = UtilsText.isEmpty((String)channel) ? null : channel;
        }

        public @NonNull String getSignal() {
            return this.mSignal;
        }

        public @Nullable String getChannel() {
            return this.mChannel;
        }

        public String toString() {
            String str = String.valueOf(this.getClass().getSimpleName()) + ": " + this.mSignal;
            if (this.mChannel != null) {
                str = String.valueOf(str) + ", channel: " + this.mChannel;
            }
            return str;
        }
    }
}

