/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.EnableDisableCondition;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.utils.registers.EmptyRegistersDB;

public class NoClock
extends AClockElement {
    @NonNull
    public static final String NAME = "No clock";
    @NonNull
    public static final String ID = "NO_CLOCK";

    public NoClock() {
        super((IRegistersDatabaseAPI)EmptyRegistersDB.INSTANCE, ID, NAME, "", CollectionsUtils.emptyList(), CollectionsUtils.emptyList(), false);
        this.addNestedSetting(new EnableSetting(ID, (IElement)this, new EnableDisableCondition(Expression.EXPRESSION_TRUE, ID, false)));
        this.modelDevice = new NoClockModel(ID);
    }

    @Override
    protected void loadFromModel(@NonNull IClocksConfig config) {
        ISetting outputFrequencySetting = this.getOutputFrequencySetting();
        config.setSettingValue(outputFrequencySetting, SettingValue.FREQ_N_A, false, false);
    }

    @Override
    protected void saveToModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        Node computationNodeLoc = this.getComputationNode(config);
        if (computationNodeLoc != null) {
            computationNodeLoc.disable();
        }
    }

    @Override
    public boolean isValid(@NonNull IClocksConfig config) {
        return true;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        return false;
    }

    @Override
    public boolean isEnabledForModel(@NonNull IClocksConfig config) {
        return false;
    }

    @Override
    public void setDevice(@NonNull Node nd) {
        super.setDevice(nd);
        nd.disable();
    }

    private static class NoClockModel
    extends AClockModelCreationElement {
        public NoClockModel(@NonNull String deviceID) {
            super(deviceID, ENodeType.ClockFixed);
        }

        @Override
        public BigRational getClockFrequency() {
            return BigRational.ZERO;
        }

        @Override
        public BigRational getDefaultClockFreq() {
            return BigRational.ZERO;
        }

        @Override
        public String getPredecessor() {
            return "#root#";
        }

        @Override
        public @Nullable String getSuccessor() {
            return super.getSuccessor();
        }
    }
}

