/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.FnPllConfigSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.IValueMap;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FnPllConfigElement
implements IElement {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(FnPllConfigElement.class);
    @NonNull
    private String id;
    @NonNull
    private String name;
    @NonNull
    private String description;
    @NonNull
    private Range valuesRange;
    @NonNull
    private ISetting setting;
    @NonNull
    private EnableSetting enableSetting;
    @NonNull
    private String defaultValue;
    @NonNull
    private Map<BitFieldElement, IValueMap> assigns;

    public FnPllConfigElement(@NonNull String id, @NonNull String name, @NonNull String description, @NonNull Range valuesRange, @NonNull String defaultValue, @NonNull Map<BitFieldElement, IValueMap> assigns) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.valuesRange = valuesRange;
        this.enableSetting = new EnableSetting(name, this);
        this.setting = new FnPllConfigSetting(name, SettingType.LOCAL_CONFIG_ELEMENT, this);
        this.assigns = assigns;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String getID() {
        return this.id;
    }

    @Override
    public @Nullable String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        return true;
    }

    @Override
    public @NonNull EnableSetting getEnableSetting() {
        return this.enableSetting;
    }

    public @NonNull Range getRange() {
        return this.valuesRange;
    }

    public @NonNull ISetting getSetting() {
        return this.setting;
    }

    public @Nullable SettingValue getDefaultValue() {
        return new SettingValue(this.defaultValue);
    }

    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull IClocksConfig config, @NonNull SettingValue value) {
        HashMap<@NonNull ISetting, @NonNull SettingValue> bitFieldSettings = new HashMap<ISetting, SettingValue>();
        this.assigns.forEach((k, v) -> {
            ISetting bitFieldSetting = SettingProvider.getBitFieldSetting(k.getID(), config.getMcu());
            if (bitFieldSetting != null) {
                IValue resolve = v.getExpression().resolve(config);
                try {
                    bitFieldSettings.put(bitFieldSetting, new SettingValue(resolve.getRational().toBigInteger()));
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.severe(resolve.getRational() + "is not a valid bit field value");
                }
            } else {
                LOGGER.severe("No bit field setting found for bit field:" + k);
            }
        });
        return bitFieldSettings;
    }

    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        return (Collection)this.assigns.keySet().stream().map(x -> x.getId()).collect(CollectorsUtils.toList());
    }

    public @NonNull Collection<@NonNull String> getDependencies() {
        HashSet<@NonNull String> dependencies = new HashSet<String>();
        this.assigns.forEach((k, v) -> {
            Expression expression = v.getExpression();
            Collection<@NonNull String> settings = expression.getSettings();
            @NonNull List collect = (List)settings.stream().filter(x -> !x.equals(this.id)).collect(CollectorsUtils.toList());
            dependencies.addAll(collect);
        });
        return dependencies;
    }

    public @NonNull Collection<@NonNull String> getAllControledSettings() {
        HashSet<@NonNull String> influenced = new HashSet<String>();
        this.assigns.keySet().forEach(x -> {
            boolean bl = influenced.add(SettingProvider.getBitFieldSettingID(x.getID()));
        });
        return influenced;
    }
}

