/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.FnPllConfigElement;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.OutputFrequencySetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.model.ClockGeneratorRational;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class FnPll
extends AClockElement {
    @NonNull
    private static final String DENOM = "denom";
    @NonNull
    private static final String NUM = "num";
    @NonNull
    private static final String DIV = "div";
    @NonNull
    private @NonNull List<@NonNull FnPllConfigElement> fnpllconfigElements;
    @NonNull
    private @NonNull List<@NonNull BigRational> suitableFrequencies;
    @Nullable
    private TypicalFrequenciesSetting typicalFrequenciesSetting;
    @NonNull
    EnableSetting enableSetting;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public FnPll(@NonNull ClockElementData elementData, @NonNull List<@NonNull FnPllConfigElement> fnpllconfigElements, @NonNull List<@NonNull BigRational> suitableFrequencies, boolean prioritized) {
        super(elementData.getRegisters(), elementData.getId(), elementData.getName(), elementData.getDescription(), elementData.getInputSignal(), elementData.getConstraints(), elementData.getConfigElements(), prioritized);
        this.fnpllconfigElements = fnpllconfigElements;
        fnpllconfigElements.forEach(x -> {
            this.addNestedSetting(x.getSetting());
            this.addNestedSetting(x.getEnableSetting());
        });
        this.suitableFrequencies = suitableFrequencies;
        if (!suitableFrequencies.isEmpty()) {
            @NonNull List outputConstraints = (List)this.getElementConstraints().stream().filter(x -> !x.isOnInput()).collect(CollectorsUtils.toList());
            BigRational minFreq = AClockElement.calculateMinFrequency(outputConstraints);
            BigRational maxFreq = AClockElement.calculateMaxFrequency(outputConstraints);
            if (minFreq != null && maxFreq != null) {
                TypicalFrequenciesSetting suitableFrequenciesSettingLoc;
                Range range = new Range(minFreq, maxFreq, true);
                this.typicalFrequenciesSetting = suitableFrequenciesSettingLoc = new TypicalFrequenciesSetting(this, suitableFrequencies, range);
                this.settings.put(suitableFrequenciesSettingLoc.getId(), suitableFrequenciesSettingLoc);
                this.outputFSetting = suitableFrequenciesSettingLoc;
            }
        }
        this.enableSetting = new EnableSetting(this.id, (IElement)this, elementData.getEnableDisableConditions());
        this.addNestedSetting(this.enableSetting);
        this.modelDevice = new FnPllModel(this.id, ENodeType.ClockGeneratorRat);
    }

    @Override
    protected void saveToModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            this.setLimits(compNode);
            boolean frequencySaved = false;
            TypicalFrequenciesSetting frequenciesLoc = this.typicalFrequenciesSetting;
            if (frequenciesLoc != null && config.isLocked(frequenciesLoc)) {
                SettingValue frequencyToSave = config.getSettingsConfig().getSettingValue(frequenciesLoc);
                if (!Objects.equals(frequencyToSave, frequenciesLoc.getDefaultValue(config))) {
                    frequencySaved = this.saveFrequencyValue(compNode, false, frequencyToSave.getValue());
                }
            } else {
                frequencySaved = this.saveOutputFrequency(config, compNode, lockedOnly, false);
            }
            if (!frequencySaved) {
                compNode.clean();
                compNode.setSuitableFrequencies(this.suitableFrequencies);
                boolean lockedValue = false;
                for (FnPllConfigElement element : this.fnpllconfigElements) {
                    boolean locked = config.getSettingsConfig().isLocked(element.getSetting());
                    boolean bl = lockedValue = lockedValue || locked;
                }
                if (!lockedOnly || lockedValue) {
                    this.setValuesFromConfig(config, compNode);
                }
            }
        }
    }

    @Override
    public EnableSetting getEnableSetting() {
        return this.enableSetting;
    }

    @Override
    protected void loadFromModel(@NonNull IClocksConfig config) {
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            this.setValuesFromModel(config, compNode);
        }
    }

    private void setValuesFromModel(IClocksConfig config, Node compNode) {
        this.fnpllconfigElements.forEach(x -> {
            String DIV_ID = this.getGeneratorID(DIV);
            String NUM_ID = this.getGeneratorID(NUM);
            String DENOM_ID = this.getGeneratorID(DENOM);
            BigInteger divValue = ((ClockGeneratorRational)compNode).getMul();
            BigInteger numValue = ((ClockGeneratorRational)compNode).getNumerator();
            BigInteger denomValue = ((ClockGeneratorRational)compNode).getDenominator();
            ISetting setting = x.getSetting();
            if (x.getID().equals(DIV_ID)) {
                config.setSettingValue(setting, new SettingValue(divValue), false, false);
            } else if (x.getID().equals(NUM_ID)) {
                config.setSettingValue(setting, new SettingValue(numValue), false, false);
            } else if (x.getID().equals(DENOM_ID) && this.getGeneratorRange(DENOM_ID).isInRange(new BigRational(denomValue))) {
                config.setSettingValue(setting, new SettingValue(denomValue), false, false);
            } else {
                LOGGER.warning("Not supported fnpll config element with ID: " + x.getID());
            }
        });
    }

    private void setValuesFromConfig(@NonNull IClocksConfig config, @NonNull Node compNode) {
        BigInteger div = this.getGeneratorValue(config, this.getGeneratorID(DIV));
        BigInteger num = this.getGeneratorValue(config, this.getGeneratorID(NUM));
        BigInteger denom = this.getGeneratorValue(config, this.getGeneratorID(DENOM));
        compNode.setGeneratorValues(div, num, denom);
    }

    public @Nullable BigInteger getDivValue(@NonNull IClocksConfig config) {
        BigInteger div = this.getGeneratorValue(config, this.getGeneratorID(DIV));
        return div.compareTo(BigInteger.valueOf(-1L)) == 0 ? null : div;
    }

    public @Nullable BigInteger getNumValue(@NonNull IClocksConfig config) {
        BigInteger div = this.getGeneratorValue(config, this.getGeneratorID(NUM));
        return div.compareTo(BigInteger.valueOf(-1L)) == 0 ? null : div;
    }

    public @Nullable BigInteger getDenomValue(@NonNull IClocksConfig config) {
        BigInteger div = this.getGeneratorValue(config, this.getGeneratorID(DENOM));
        return div.compareTo(BigInteger.valueOf(-1L)) == 0 ? null : div;
    }

    public @NonNull ISetting getDivSetting() {
        ISetting setting = this.getGeneratorSetting(this.getGeneratorID(DIV));
        assert (setting != null) : "Divider setting should be defined.";
        return setting;
    }

    public @NonNull ISetting getNumSetting() {
        ISetting setting = this.getGeneratorSetting(this.getGeneratorID(NUM));
        assert (setting != null) : "Numerator setting should be defined.";
        return setting;
    }

    public @NonNull ISetting getDenomSetting() {
        ISetting setting = this.getGeneratorSetting(this.getGeneratorID(DENOM));
        assert (setting != null) : "Denumerator setting should be defined.";
        return setting;
    }

    private void setLimits(@NonNull Node compNode) {
        Range divRange = this.getGeneratorRange(this.getGeneratorID(DIV));
        Range numRange = this.getGeneratorRange(this.getGeneratorID(NUM));
        Range denomRange = this.getGeneratorRange(this.getGeneratorID(DENOM));
        compNode.setAllowedLimits(divRange.getMin().toBigInteger(), divRange.getMax().toBigInteger(), numRange.getMax().toBigInteger(), denomRange.getMax().toBigInteger(), numRange.getMin().toBigInteger(), denomRange.getMin().toBigInteger());
    }

    private @NonNull BigInteger getGeneratorValue(@NonNull IClocksConfig config, @NonNull String valueType) {
        BigInteger value = BigInteger.ZERO;
        ISetting setting = this.getGeneratorSetting(valueType);
        if (setting != null) {
            SettingValue settingValue = SettingProvider.getValueBySettingId(setting.getId(), config.getMcu(), config.getSettingsConfig());
            if (settingValue != null && !settingValue.isN_A()) {
                value = new BigInteger(settingValue.getUiValue());
            } else {
                SettingValue defaultValue = setting.getDefaultValue(config);
                assert (defaultValue != null);
                value = new BigInteger(defaultValue.getUiValue());
                LOGGER.warning("Not valid generator value of " + valueType);
            }
        }
        assert (value != null);
        return value;
    }

    private @NonNull Range getGeneratorRange(@NonNull String valueType) {
        Range range = null;
        for (FnPllConfigElement configElement : this.fnpllconfigElements) {
            if (!valueType.equals(configElement.getID())) continue;
            range = configElement.getRange();
        }
        assert (range != null) : "No range found for FNPLL config element " + valueType;
        return range;
    }

    private @Nullable ISetting getGeneratorSetting(@NonNull String valueType) {
        for (FnPllConfigElement configElement : this.fnpllconfigElements) {
            if (!valueType.equals(configElement.getID())) continue;
            return configElement.getSetting();
        }
        return null;
    }

    @Override
    public void configureConfig(@NonNull IClocksConfig config) {
        BigRational freq;
        Frequency outFreq = null;
        Node compNode = this.getComputationNode(config);
        if (compNode != null && (freq = compNode.getFrequency()) != null) {
            outFreq = new Frequency(freq, FrequencyUnit.HERTZ);
        }
        SettingValue outFSettingValue = null;
        if (outFreq != null) {
            outFSettingValue = this.outputFSetting.parseValue(outFreq, config);
        }
        if (outFSettingValue == null) {
            outFSettingValue = SettingValue.FREQ_N_A;
        }
        config.setSettingValue(this.outputFSetting, outFSettingValue, false, false);
        if (this.isEnabled(config)) {
            this.loadFromModel(config);
        }
    }

    private @NonNull String getGeneratorID(@NonNull String type) {
        return String.valueOf(this.id) + "." + type;
    }

    public TypicalFrequenciesSetting getTypicalFrequenciesSetting() {
        return this.typicalFrequenciesSetting;
    }

    public static class FnPllModel
    extends AClockModelCreationElement {
        public FnPllModel(@NonNull String id, @NonNull ENodeType type) {
            super(id, type);
        }

        @Override
        public @Nullable BigRational getMinInput() {
            return new BigRational(0);
        }

        @Override
        public @Nullable BigRational getMaxInput() {
            return new BigRational(0);
        }

        @Override
        public @Nullable BigRational getMinOutput() {
            return new BigRational(0);
        }

        @Override
        public @Nullable BigRational getMaxOutput() {
            return new BigRational(0);
        }
    }

    public class TypicalFrequenciesSetting
    extends OutputFrequencySetting {
        @NonNull
        private @NonNull List<@NonNull BigRational> frequencies;
        @NonNull
        private Range range;

        public TypicalFrequenciesSetting(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull @NonNull IClockElement element, @NonNull List<BigRational> suitableFrequencies, Range range) {
            super(element);
            this.frequencies = suitableFrequencies;
            this.range = range;
        }

        private @NonNull SettingValue createFrequencySettingValue(@NonNull Frequency freq) {
            return new SettingValue(freq, freq.toExactString());
        }

        @Override
        public @Nullable List<@NonNull SettingValue> getValues(@NonNull IClocksConfig clocksConfig) {
            return (List)this.frequencies.stream().map(x -> this.createFrequencySettingValue(Frequency.parseRational((BigRational)x))).collect(CollectorsUtils.toList());
        }

        @Override
        public @Nullable Range getRangeOfValues(@NonNull IClocksConfig config) {
            return this.range;
        }

        @Override
        public @Nullable SettingValue parseUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
            Frequency frequency;
            SettingValue value = super.parseUiValue(uiValue, clocksConfig);
            if (value == null && (frequency = this.parseFrequency(uiValue, clocksConfig)) != null && this.range.isFrequencyInRange(frequency)) {
                return new SettingValue(frequency);
            }
            return value;
        }
    }
}

