/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.expression.ConfigContext;
import com.nxp.swtools.clocks.expression.DependencyContextWrapper;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.utils.ExpressionUtils;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.BitFieldVariable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EnableDisableCondition {
    private boolean enable;
    @NonNull
    private String description;
    @NonNull
    private Expression expression;
    @NonNull
    private Expression caseExpression;
    @NonNull
    public static final EnableDisableCondition DEFAULT = new EnableDisableCondition(Expression.EXPRESSION_TRUE, "", true);

    public EnableDisableCondition(@NonNull Expression caseExpression, @NonNull Expression expression, @NonNull String description, boolean enable) {
        this.expression = expression;
        this.enable = enable;
        this.description = description;
        this.caseExpression = caseExpression;
    }

    public EnableDisableCondition(@NonNull Expression expression, @NonNull String description, boolean enable) {
        this(Expression.EXPRESSION_TRUE, expression, description, enable);
    }

    public @NonNull String getDescription() {
        return this.description;
    }

    public boolean isResolvable(@NonNull IClocksConfig clocksConfig, @NonNull Set<@NonNull String> usedSettings) {
        DependencyContextWrapper contextWrapper = ExpressionUtils.getDependencyContextWrapper(this.caseExpression, clocksConfig);
        boolean result = this.caseExpression.resolve(contextWrapper).getBoolean();
        usedSettings.addAll(contextWrapper.getAllUsedSettings(clocksConfig));
        return result;
    }

    public boolean isEnabled(@NonNull IClocksConfig clocksConfig) {
        IContext context = this.expression.getContext();
        ConfigContext resolutionContext = new ConfigContext(context, clocksConfig);
        boolean resolution = this.expression.resolve((IValue)Value.valueOf((boolean)this.enable), resolutionContext).getBoolean();
        if (this.enable) {
            return resolution;
        }
        return !resolution;
    }

    public @NonNull Expression getExpression() {
        return this.expression;
    }

    public @NonNull Expression getCaseExpression() {
        return this.caseExpression;
    }

    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        HashSet<@NonNull String> usedBitFields = new HashSet<String>();
        List<@NonNull BitFieldVariable> bitFields = this.expression.getBitFields();
        bitFields.addAll(this.caseExpression.getBitFields());
        for (BitFieldVariable bitFieldVar : bitFields) {
            String bitFieldId = this.expression.getContext().getBitFieldId(bitFieldVar.getRegisterName(), bitFieldVar.getBitFieldName());
            usedBitFields.add(bitFieldId);
        }
        return CollectionsUtils.unmodifiableCollection(usedBitFields);
    }

    public @NonNull Collection<@NonNull String> getUsedSettings() {
        Collection<@NonNull String> settings = this.expression.getSettings();
        settings.addAll(this.caseExpression.getSettings());
        return CollectionsUtils.unmodifiableCollection(settings);
    }
}

