/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.EnableDisableCondition;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ASetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.GlobalConfigElementSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.LocalConfigElementSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;

public class ConfigElement
implements IConfigElement {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(ConfigElement.class);
    @NonNull
    private String id;
    @NonNull
    private String name;
    @NonNull
    private String description;
    @NonNull
    private @NonNull Map<@NonNull String, @NonNull IConfigElementItem> items;
    @NonNull
    String defaultItem;
    @NonNull
    ISetting setting;
    @NonNull
    @NonNull List<@NonNull Constraint> constraints;
    @Nullable
    EnableSetting enableSetting;
    @Nullable
    Set<@NonNull ISetting> sharedList;
    private boolean isPowerModeSpecific;

    public ConfigElement(@NonNull String id, @NonNull String name, @NonNull String description, @NonNull Map<@NonNull String, @NonNull IConfigElementItem> items, @NonNull String defaultItem, boolean global, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull EnableDisableCondition> enableDisableConditions) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.items = items;
        this.defaultItem = defaultItem;
        this.setting = global ? new GlobalConfigElementSetting(this) : new LocalConfigElementSetting(this);
        this.constraints = constraints;
        if (!enableDisableConditions.isEmpty()) {
            this.enableSetting = new EnableSetting(id, (IElement)this, enableDisableConditions);
        }
        this.isPowerModeSpecific = false;
    }

    @Override
    public @NonNull String getID() {
        return this.id;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String getDescription() {
        return this.description;
    }

    @Override
    public @NonNull Collection<@NonNull IConfigElementItem> getItems() {
        return this.items.values();
    }

    @Override
    public boolean isWritable() {
        for (IConfigElementItem item : this.items.values()) {
            if (item.getUsedBitFields().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull String getDefaultItem() {
        return this.defaultItem;
    }

    @Override
    public IConfigElementItem getActiveItem(IClocksConfig config) {
        return this.items.get(config.getSettingsConfig().getSettingValue(this.getSetting()).getValue());
    }

    @Override
    public @NonNull Collection<@NonNull String> getItemNames() {
        return this.items.keySet();
    }

    @Override
    public @NonNull ISetting getSetting() {
        return this.setting;
    }

    @Override
    public @NonNull List<@NonNull Constraint> getElementConstraints(@NonNull IClocksConfig clocksConfig) {
        IConfigElementItem activeItem = this.getActiveItem(clocksConfig);
        if (activeItem != null) {
            return this.getConstraintsOf(activeItem.getID());
        }
        return CollectionsUtils.emptyList();
    }

    @Override
    public @NonNull List<@NonNull Constraint> getConstraintsOf(@NonNull String itemId) {
        return (List)this.constraints.stream().filter(x -> x.getElementID().equals(String.valueOf(this.id) + "." + itemId)).collect(CollectorsUtils.toList());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [id=" + this.id + "]";
    }

    @Override
    public boolean isEnabled(@NonNull IClocksConfig config) {
        EnableSetting locEnableSetting = this.getEnableSetting();
        if (locEnableSetting != null) {
            config.getSettingsConfig().setSettingValue(locEnableSetting, locEnableSetting.createCurrentValue(config));
            return locEnableSetting.isEnabled(config);
        }
        return true;
    }

    @Override
    public @NonNull Collection<@NonNull String> getAllControledSettings(@NonNull IMcu mcu) {
        HashSet<@NonNull E> bitFieldIds = new HashSet();
        HashSet<@NonNull String> bitFieldSettings = new HashSet<String>();
        this.getItems().forEach(x -> {
            boolean bl = bitFieldIds.addAll(x.getUsedBitFields());
        });
        bitFieldIds.forEach(x -> SettingProvider.addBitFieldSetting(bitFieldSettings, x, mcu));
        return bitFieldSettings;
    }

    @Override
    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull String item, @NonNull IClocksConfig config) {
        @NonNull HashMap<@NonNull ISetting, @NonNull SettingValue> bitFieldSettings = new HashMap<ISetting, SettingValue>();
        if (this.items.containsKey(item)) {
            IConfigElementItem configElementItem = Objects.requireNonNull(this.items.get(item));
            Set<Map.Entry<@NonNull String, @NonNull Long>> assignEntries = configElementItem.getBitFieldsToAssignForConfig(config).entrySet();
            for (Map.Entry<String, Long> assignEntry : assignEntries) {
                SettingValue settingValue;
                ISetting bitFieldSetting = SettingProvider.getBitFieldSetting(assignEntry.getKey(), config.getMcu());
                if (bitFieldSetting == null || (settingValue = bitFieldSetting.parseValue(assignEntry.getValue(), config)) == null) continue;
                bitFieldSettings.put(bitFieldSetting, settingValue);
            }
        }
        return bitFieldSettings;
    }

    private void findSharedSettings(@NonNull IClocksConfig config) {
        Set<@NonNull ISetting> shared = this.sharedList;
        if (shared == null) {
            return;
        }
        HashSet<@NonNull String> settingList = new HashSet<String>();
        for (IConfigElementItem item : this.getItems()) {
            settingList.addAll(item.getUsedSettings());
        }
        if (!settingList.isEmpty()) {
            shared.add(this.setting);
        }
        for (String settingName : settingList) {
            Collection<IConfigElementItem> itemsList;
            IElement elem;
            ISetting settingFound = config.getMcu().getSettings().findSettingWithId(settingName);
            if (settingFound == null || !((elem = settingFound.getElement()) instanceof IConfigElement) || (itemsList = ((IConfigElement)elem).getItems()) == null) continue;
            for (IConfigElementItem item : itemsList) {
                if (!item.getUsedBitFields().isEmpty()) continue;
                shared.add(settingFound);
            }
        }
    }

    @Override
    public boolean isSharingRegisters(@NonNull IClocksConfig config) {
        if (this.sharedList == null) {
            this.sharedList = new HashSet<ISetting>();
            this.findSharedSettings(config);
        }
        return this.sharedList == null || !this.sharedList.isEmpty();
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        if (!this.isWritable()) {
            return config.getSettingsConfig().getSettingValue(this.setting);
        }
        boolean emptyAssignsPresent = false;
        for (IConfigElementItem item : this.getItems()) {
            Map<@NonNull String, @NonNull Long> bitFieldsToAssign = item.getBitFieldsToAssignForConfig(config);
            boolean matches = true;
            if (bitFieldsToAssign.isEmpty()) {
                emptyAssignsPresent = true;
            }
            for (Map.Entry<String, Long> assignEntry : bitFieldsToAssign.entrySet()) {
                BitFieldElement bitField = ClocksBitFieldProvider.getBitFieldById(assignEntry.getKey(), config.getMcu().getRegisters());
                Long value = assignEntry.getValue();
                if (bitField != null && value != null) {
                    IRegBitFieldValueAPI bfValue = ClocksBitFieldProvider.getBitFieldValueOrResetValueNullable(bitField, config);
                    long assignValue = value;
                    if (bfValue != null && bfValue.getValue() == assignValue) continue;
                    matches = false;
                    break;
                }
                LOGGER.severe("Failed to assign bit field: " + assignEntry.getKey() + " in config element: " + this.id);
            }
            if (!matches || emptyAssignsPresent) continue;
            return new SettingValue(item.getID(), item.getName());
        }
        if (emptyAssignsPresent) {
            return config.getSettingsConfig().getSettingValue(this.setting);
        }
        return SettingValue.N_A;
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return this.enableSetting;
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        HashSet<@NonNull String> dependencies = new HashSet<String>();
        this.items.values().forEach(x -> {
            boolean bl = dependencies.addAll(x.getDependencies(mcu));
        });
        return dependencies;
    }

    @Override
    public @NonNull Collection<@NonNull String> getItemsBitFields() {
        HashSet<@NonNull String> bitFields = new HashSet<String>();
        this.getItems().forEach(x -> {
            boolean bl = bitFields.addAll(x.getUsedBitFields());
        });
        return bitFields;
    }

    @Override
    public @NonNull List<@NonNull ISetting> getSharedList() {
        return new ArrayList<ISetting>(this.sharedList);
    }

    @Override
    public @NonNull Map<@NonNull String, ISetting> createPowerModeSpecificSettings(@NonNull List<@NonNull PowerMode> powerModes) {
        HashMap<@NonNull String, ISetting> result = new HashMap<String, ISetting>();
        if (this.isPowerModeSpecific()) {
            powerModes.forEach(x -> {
                ASetting powerModeSpecificSetting = this.setting instanceof GlobalConfigElementSetting ? new GlobalConfigElementSetting(this) : new LocalConfigElementSetting(this);
                powerModeSpecificSetting.setPowerMode(x.getID());
                result.put(powerModeSpecificSetting.getId(), powerModeSpecificSetting);
            });
        }
        return result;
    }

    @Override
    public void setPowerModeSpecific(boolean isPowerModeSpecific) {
        this.isPowerModeSpecific = isPowerModeSpecific;
    }

    @Override
    public boolean isPowerModeSpecific() {
        return this.isPowerModeSpecific;
    }
}

