/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.BitFieldValueWrapper;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.utils.registers.BitFieldProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class ClocksBitFieldProvider
extends BitFieldProvider {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ClocksBitFieldProvider.class);

    public static @Nullable BitFieldElement getBitFieldById(@NonNull String id, @NonNull IRegistersDatabaseAPI registersDB) {
        int colonPos = id.indexOf(58);
        int openingPos = id.indexOf(91);
        if (openingPos > 0 && openingPos < id.length() && colonPos > 0 && colonPos < id.length() - 1 && colonPos < openingPos) {
            String peripheralName = id.substring(0, colonPos);
            String registerName = id.substring(colonPos + 2, openingPos);
            String bitFieldName = id.substring(openingPos + 1, id.length() - 1);
            return BitFieldElement.valueOf(peripheralName, registerName, bitFieldName, registersDB);
        }
        return null;
    }

    public static @Nullable BitFieldElement getBitField(@NonNull String registerName, @NonNull String bitFieldName, @NonNull IRegistersDatabaseAPI registersDB) {
        String id = ClocksBitFieldProvider.createBitFieldId(registerName, bitFieldName);
        return ClocksBitFieldProvider.getBitFieldById(id, registersDB);
    }

    public static @NonNull String createBitFieldId(@NonNull String register, @NonNull String bitField) {
        return String.valueOf(register) + '[' + bitField + ']';
    }

    public static long getValueByBitFieldId(@NonNull String id, @NonNull IRegistersDatabaseAPI registersDB, @NonNull IClocksConfig config) {
        BitFieldElement bitField = ClocksBitFieldProvider.getBitFieldById(id, registersDB);
        if (bitField != null) {
            return ClocksBitFieldProvider.getBitFieldValueOrResetValue(bitField, config).getValue();
        }
        return -1L;
    }

    public static @NonNull IRegBitFieldValueAPI getBitFieldValueOrResetValue(@NonNull BitFieldElement bitField, @NonNull IClocksConfig config) {
        IRegBitFieldValueAPI value = ClocksBitFieldProvider.getBitFieldValueOrResetValueNullable(bitField, config);
        if (value != null) {
            return value;
        }
        LOGGER.severe(bitField + ": value not  found");
        return new BitFieldValueWrapper(-1L);
    }

    public static @Nullable IRegBitFieldValueAPI getBitFieldValueNullable(@NonNull BitFieldElement bitField, @NonNull IClocksConfig config) {
        BitFieldSetting bitFieldSetting = ClocksBitFieldProvider.getBitFieldSetting(bitField, config.getMcu());
        if (bitFieldSetting != null) {
            SettingValue settingValue = config.getSettingsConfig().getSettingValue(bitFieldSetting);
            return ClocksBitFieldProvider.toBitFieldValue(settingValue);
        }
        return null;
    }

    public static IRegBitFieldValueAPI getBitFieldValueOrResetValueNullable(@NonNull BitFieldElement bitField, @NonNull IClocksConfig config) {
        Object value = ClocksBitFieldProvider.getBitFieldValueNullable(bitField, config);
        if (value == null) {
            BitFieldSetting bitFieldSetting = ClocksBitFieldProvider.getBitFieldSetting(bitField, config.getMcu());
            value = bitFieldSetting != null ? ClocksBitFieldProvider.toBitFieldValue(bitFieldSetting.getDefaultValue(config)) : new BitFieldValueWrapper(bitField.getResetValue());
        }
        return value;
    }

    public static long getValueOfBitField(@NonNull String registerName, @NonNull String bitFieldName, @NonNull IRegistersDatabaseAPI registersDB, @NonNull IClocksConfig config) {
        String id = ClocksBitFieldProvider.createBitFieldId(registerName, bitFieldName);
        return ClocksBitFieldProvider.getValueByBitFieldId(id, registersDB, config);
    }

    public static boolean isBitFieldValueAvailable(@NonNull String register, @NonNull String bitFieldName, @NonNull IRegistersDatabaseAPI registersDB, @NonNull IClocksConfig config) {
        BitFieldElement bitField = ClocksBitFieldProvider.getBitField(register, bitFieldName, registersDB);
        return bitField != null && ClocksBitFieldProvider.getBitFieldValueNullable(bitField, config) != null;
    }

    public static boolean isBitFieldAvailable(@NonNull String register, @NonNull String bitFieldName, @NonNull IRegistersDatabaseAPI registers, @NonNull IClocksConfig config) {
        BitFieldElement bitField = ClocksBitFieldProvider.getBitField(register, bitFieldName, registers);
        if (bitField == null) {
            return false;
        }
        return ClocksBitFieldProvider.getBitFields(config.getMcu()).contains(bitField);
    }

    public static @NonNull Collection<@NonNull BitFieldElement> getConfiguredBitFields(@NonNull IClocksConfig config) {
        return ClocksBitFieldProvider.getBitFields(config.getMcu());
    }

    public static @NonNull Collection<@NonNull BitFieldElement> getBitFieldsNonDefault(@NonNull IClocksConfig config) {
        IMcu mcu = config.getMcu();
        Collection<@NonNull ISetting> allBitFieldSettings = mcu.getSettings().getAllBitFieldSettings();
        HashSet<@NonNull BitFieldElement> nonDefaultBitFields = new HashSet<BitFieldElement>();
        Map<ISetting, SettingValue> settingValues = config.getSettingsConfig().getSettingValues();
        for (ISetting bfSetting : allBitFieldSettings) {
            SettingValue settingValue = settingValues.get(bfSetting);
            SettingValue defaultValue = bfSetting.getDefaultValue(config);
            if (settingValue != null && Objects.equals(settingValue, defaultValue)) continue;
            nonDefaultBitFields.add(((BitFieldSetting)bfSetting).getBitField());
        }
        return nonDefaultBitFields;
    }

    public static @Nullable IRegBitFieldValueAPI getBitFieldValueFromLong(@NonNull BitFieldElement bitField, long value) {
        IRegBitFieldValueAPI[] iRegBitFieldValueAPIArray = bitField.getValues();
        int n = iRegBitFieldValueAPIArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRegBitFieldValueAPI bfValue = iRegBitFieldValueAPIArray[n2];
            if (bfValue.matchesValue(value)) {
                return bfValue;
            }
            ++n2;
        }
        return null;
    }

    private static @Nullable IRegBitFieldValueAPI toBitFieldValue(@Nullable SettingValue settingValue) {
        return settingValue != null && !settingValue.isN_A() ? new BitFieldValueWrapper((Number)settingValue.getValue()) : null;
    }

    public static @NonNull Collection<@NonNull BitFieldElement> getBitFields(@NonNull IMcu mcu) {
        HashSet<@NonNull BitFieldElement> bitFields = new HashSet<BitFieldElement>();
        mcu.getSettings().getAllBitFieldSettings().forEach(x -> {
            boolean bl = bitFields.add(((BitFieldSetting)x).getBitField());
        });
        return bitFields;
    }

    private static @Nullable BitFieldSetting getBitFieldSetting(@NonNull BitFieldElement bitField, @NonNull IMcu mcu) {
        for (ISetting setting : mcu.getSettings().getAllBitFieldSettings()) {
            if (!(setting instanceof BitFieldSetting) || !((BitFieldSetting)setting).getBitField().equals(bitField)) continue;
            return (BitFieldSetting)setting;
        }
        return null;
    }
}

