/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.elements.AClockElement;
import com.nxp.swtools.clocks.data.elements.AClockModelCreationElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ClockOutputSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.rational.BigRational;

public class ClockOutput
extends AClockElement {
    @NonNull
    private String group;

    public ClockOutput(@NonNull ClockElementData elementData, @NonNull String inputSignal, @NonNull String group) {
        super(elementData.getRegisters(), elementData.getId(), elementData.getName(), elementData.getDescription(), inputSignal, elementData.getConstraints(), elementData.getConfigElements(), elementData.isPrioritized());
        this.modelDevice = new ConsumerModel(this.id, ENodeType.Consumer);
        this.group = group;
    }

    @Override
    protected @NonNull ISetting createOutputFrequencySetting() {
        return new ClockOutputSetting(this);
    }

    @Override
    public String getType() {
        return ElementType.CLOCK_OUTPUT.toString();
    }

    public @NonNull String getGroup() {
        return this.group;
    }

    @Override
    public @Nullable Frequency getOutputFrequency(@NonNull IClocksConfig config) {
        BigRational freq;
        Node compNode = this.getComputationNode(config);
        if (compNode != null && (freq = compNode.getInputClock()) != null) {
            return new Frequency(freq, FrequencyUnit.HERTZ);
        }
        return null;
    }

    @Override
    protected void loadFromModel(@NonNull IClocksConfig config) {
    }

    @Override
    protected void saveToModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        Node compNode = this.getComputationNode(config);
        if (compNode != null) {
            this.saveOutputFrequency(config, compNode, lockedOnly, true);
        }
    }

    @Override
    public @Nullable ISetting getMainSetting() {
        return this.getOutputFrequencySetting();
    }

    public class ConsumerModel
    extends AClockModelCreationElement {
        public ConsumerModel(@NonNull String id, ENodeType type) {
            super(id, type);
        }
    }
}

