/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.LongValues;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.expression.BitFieldsContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ICalculus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.BitFieldVariable;
import com.nxp.swtools.common.utils.expression.Constant;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.IResolvable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Operator;
import com.nxp.swtools.common.utils.expression.OperatorType;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Calculus
implements ICalculus {
    @NonNull
    protected IRegistersDatabaseAPI registers;
    @NonNull
    protected @NonNull BitFieldElement @NonNull [] bitFields;
    @NonNull
    protected Expression expression;
    @NonNull
    private @NonNull List<@NonNull Constraint> expressionConstraints;
    @Nullable
    private Constraint problematicConstraint;

    public Calculus(@NonNull IRegistersDatabaseAPI registers, @NonNull Expression expression) {
        this.registers = registers;
        this.expression = expression;
        this.expressionConstraints = new ArrayList<Constraint>();
        this.bitFields = this.findBitFields();
    }

    public Calculus(@NonNull IRegistersDatabaseAPI registers, @NonNull Expression expression, @NonNull List<@NonNull Constraint> constraint) {
        this.registers = registers;
        this.expression = expression;
        this.expressionConstraints = constraint;
        this.bitFields = this.findBitFields();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CollectionsUtils.Pair<@NonNull BigRational, @NonNull Long[]> calculate(@NonNull Object requiredValue) {
        return this.calculateBitfieldsValue(requiredValue);
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CollectionsUtils.Pair<@NonNull BigRational, @NonNull Long[]> calculateBitfieldsValue(@NonNull Object requiredValue) {
        BigRational requiredRationalVal = BigRational.tryParse((String)requiredValue.toString());
        if (requiredValue instanceof BigRational) {
            requiredRationalVal = (BigRational)requiredValue;
        }
        this.problematicConstraint = null;
        BigRational returnValue = null;
        if (requiredRationalVal == null) {
            return null;
        }
        assert (requiredRationalVal != null);
        Long[] indexes = new Long[this.bitFields.length];
        LongValues bitfV = this.getDefaultBfValues();
        Arrays.setAll(indexes, i -> bitfV.getValue(i));
        Expression currentExpression = Expression.create(this.expression.getMainResolvable(), this.expression.getContext());
        IResolvable mainResolvable = currentExpression.getMainResolvable();
        if (mainResolvable instanceof Operator) {
            BigRational currentConstant;
            Operator op = (Operator)mainResolvable;
            IResolvable leftArgument = op.getArguments()[0];
            IResolvable rightArgument = op.getArguments()[1];
            IContext context = currentExpression.getContext();
            OperatorType operatorType = op.getOperatorType();
            if (leftArgument instanceof Constant) {
                currentConstant = BigRational.tryParse((String)((Constant)leftArgument).resolve(context).toString());
                assert (currentConstant != null);
                requiredRationalVal = Calculus.moveConstant(operatorType, requiredRationalVal, currentConstant, true);
                currentExpression.setMainResolvable(rightArgument);
            } else if (rightArgument instanceof Constant) {
                currentConstant = BigRational.tryParse((String)((Constant)rightArgument).resolve(context).toString());
                assert (currentConstant != null);
                requiredRationalVal = Calculus.moveConstant(operatorType, requiredRationalVal, currentConstant, false);
                currentExpression.setMainResolvable(leftArgument);
            }
            mainResolvable = currentExpression.getMainResolvable();
            if (mainResolvable instanceof Operator) {
                leftArgument = ((Operator)mainResolvable).getArguments()[0];
                requiredRationalVal = this.solve(leftArgument, indexes, requiredRationalVal);
                if (requiredRationalVal == null) {
                    return null;
                }
                rightArgument = ((Operator)mainResolvable).getArguments()[1];
                requiredRationalVal = this.solve(rightArgument, indexes, requiredRationalVal);
                if (requiredRationalVal == null) {
                    return null;
                }
            }
        }
        BitFieldsContext bfContext = new BitFieldsContext(this.registers, this.bitFields, new LongValues(indexes), this.expression.getContext());
        returnValue = this.expression.resolve(bfContext).getRational();
        if (!this.expressionConstraints.isEmpty()) {
            for (Constraint constraint : this.expressionConstraints) {
                if (constraint.getCondition() == null || constraint.getCondition().resolve(bfContext).getBoolean()) continue;
                this.problematicConstraint = constraint;
                return null;
            }
        }
        CollectionsUtils.Pair returnPair = new CollectionsUtils.Pair((Object)returnValue, (Object)indexes);
        return returnPair;
    }

    private static @NonNull BigRational moveConstant(@NonNull OperatorType operatorType, @NonNull BigRational requiredValue, @NonNull BigRational currentConstant, boolean constLeftPosition) {
        switch (operatorType) {
            case ADD: {
                requiredValue = requiredValue.subtract(currentConstant);
                break;
            }
            case SUBTRACT: {
                if (constLeftPosition) {
                    requiredValue = currentConstant.subtract(requiredValue);
                    break;
                }
                requiredValue = requiredValue.add(currentConstant);
                break;
            }
            case MULTIPLY: {
                requiredValue = requiredValue.divide(currentConstant);
                break;
            }
            case DIVIDE: {
                if (constLeftPosition) {
                    requiredValue = currentConstant.divide(requiredValue);
                    break;
                }
                requiredValue = requiredValue.multiply(currentConstant);
                break;
            }
        }
        return requiredValue;
    }

    private @Nullable BigRational solve(@NonNull IResolvable currentArg, @NonNull Long[] indexes, @NonNull BigRational requiredValue) {
        block26: {
            block25: {
                BigRational currentConstBigRational;
                BitFieldVariable currentBFVar;
                Constant currentConst;
                IResolvable rightArgument;
                Operator currentOperator;
                block27: {
                    IValue result;
                    BitFieldsContext bfContext;
                    BigRational solveResult;
                    BigRational currentConstant;
                    if (!(currentArg instanceof Operator)) break block25;
                    currentOperator = (Operator)currentArg;
                    IResolvable leftArgument = currentOperator.getArguments()[0];
                    rightArgument = currentOperator.getArguments()[1];
                    if (leftArgument instanceof Operator) {
                        if (rightArgument instanceof Constant) {
                            currentConstant = BigRational.tryParse((String)((Constant)rightArgument).resolve(this.expression.getContext()).toString());
                            assert (currentConstant != null);
                            requiredValue = Calculus.moveConstant(currentOperator.getOperatorType(), requiredValue, currentConstant, false);
                        }
                        assert (requiredValue != null);
                        solveResult = this.solve(leftArgument, indexes, requiredValue);
                        if (solveResult == null) {
                            return null;
                        }
                        requiredValue = solveResult;
                        if (rightArgument instanceof BitFieldVariable) {
                            bfContext = new BitFieldsContext(this.registers, this.bitFields, new LongValues(indexes), this.expression.getContext());
                            result = leftArgument.resolve((IContext)bfContext);
                            currentOperator.getArguments()[1] = (Constant)result;
                            solveResult = this.solve((IResolvable)currentOperator, indexes, requiredValue);
                            if (solveResult == null) {
                                return null;
                            }
                            requiredValue = solveResult;
                        }
                    }
                    if (rightArgument instanceof Operator) {
                        if (leftArgument instanceof Constant) {
                            currentConstant = BigRational.tryParse((String)((Constant)leftArgument).resolve(this.expression.getContext()).toString());
                            assert (currentConstant != null && requiredValue != null);
                            requiredValue = Calculus.moveConstant(currentOperator.getOperatorType(), requiredValue, currentConstant, true);
                        }
                        if ((solveResult = this.solve(rightArgument, indexes, requiredValue)) == null) {
                            return null;
                        }
                        requiredValue = solveResult;
                        if (leftArgument instanceof BitFieldVariable) {
                            bfContext = new BitFieldsContext(this.registers, this.bitFields, new LongValues(indexes), this.expression.getContext());
                            result = rightArgument.resolve((IContext)bfContext);
                            currentOperator.getArguments()[0] = (Constant)result;
                            solveResult = this.solve((IResolvable)currentOperator, indexes, requiredValue);
                            if (solveResult == null) {
                                return null;
                            }
                            requiredValue = solveResult;
                        }
                    }
                    if (leftArgument instanceof Operator || rightArgument instanceof Operator) break block26;
                    currentConst = null;
                    if (leftArgument instanceof Constant) {
                        currentConst = (Constant)leftArgument;
                    } else if (rightArgument instanceof Constant) {
                        currentConst = (Constant)rightArgument;
                    }
                    if (currentConst == null) break block26;
                    if (!(leftArgument instanceof BitFieldVariable)) break block27;
                    currentBFVar = (BitFieldVariable)leftArgument;
                    currentConstBigRational = BigRational.tryParse((String)currentConst.resolve(this.expression.getContext()).toString());
                    assert (currentConstBigRational != null);
                    BigRational methodResult = this.calculateBitfieldValue(currentBFVar, indexes, requiredValue, currentOperator.getOperatorType(), currentConstBigRational, true);
                    if (methodResult == null) {
                        return null;
                    }
                    requiredValue = methodResult;
                    break block26;
                }
                if (!(rightArgument instanceof BitFieldVariable)) break block26;
                currentBFVar = (BitFieldVariable)rightArgument;
                currentConstBigRational = BigRational.tryParse((String)currentConst.resolve(this.expression.getContext()).toString());
                assert (currentConstBigRational != null);
                BigRational methodResult = this.calculateBitfieldValue(currentBFVar, indexes, requiredValue, currentOperator.getOperatorType(), currentConstBigRational, false);
                if (methodResult == null) {
                    return null;
                }
                requiredValue = methodResult;
                break block26;
            }
            if (currentArg instanceof BitFieldVariable) {
                BitFieldVariable bfVar = (BitFieldVariable)currentArg;
                int i = 0;
                while (i < this.bitFields.length) {
                    if (this.bitFields[i].getName().equals(bfVar.getBitFieldName()) && bfVar.getRegisterName().contains(this.bitFields[i].getRegister().getName())) {
                        if (!this.setValueToBitfield(indexes, i, requiredValue)) {
                            return null;
                        }
                        if (indexes[i].compareTo(new Long((2 << this.bitFields[i].getWidth() - 1) - 1)) > 0) {
                            return null;
                        }
                        requiredValue = requiredValue.subtract(indexes[i].longValue());
                        break;
                    }
                    ++i;
                }
            }
        }
        return requiredValue;
    }

    private @Nullable BigRational calculateBitfieldValue(BitFieldVariable currentBFVar, Long[] indexes, @NonNull BigRational requiredValue, @NonNull OperatorType operatorType, @NonNull BigRational currentConstBigRational, boolean bitfieldPosition) {
        int i = 0;
        while (i < this.bitFields.length) {
            if (this.bitFields[i].getName().equals(currentBFVar.getBitFieldName()) && currentBFVar.getRegisterName().contains(this.bitFields[i].getRegister().getName())) {
                BigRational result = null;
                switch (operatorType) {
                    case MULTIPLY: {
                        result = requiredValue.divide(currentConstBigRational);
                        if (!this.setValueToBitfield(indexes, i, result)) {
                            return null;
                        }
                        requiredValue = requiredValue.subtract(currentConstBigRational.multiply(indexes[i].longValue()));
                        break;
                    }
                    case DIVIDE: {
                        if (bitfieldPosition) {
                            result = requiredValue.multiply(currentConstBigRational);
                            if (!this.setValueToBitfield(indexes, i, result)) {
                                return null;
                            }
                            BigRational indexVal = new BigRational(indexes[i].longValue());
                            requiredValue = requiredValue.subtract(indexVal.divide(currentConstBigRational));
                            break;
                        }
                        result = currentConstBigRational.divide(requiredValue);
                        if (!this.setValueToBitfield(indexes, i, result)) {
                            return null;
                        }
                        requiredValue = requiredValue.subtract(currentConstBigRational.divide(indexes[i].longValue()));
                        break;
                    }
                    case SUBTRACT: {
                        if (bitfieldPosition) {
                            result = requiredValue.add(currentConstBigRational);
                            if (!this.setValueToBitfield(indexes, i, result)) {
                                return null;
                            }
                            BigRational indexValSubtr = new BigRational(indexes[i].longValue());
                            requiredValue = requiredValue.subtract(indexValSubtr.subtract(currentConstBigRational));
                            break;
                        }
                        result = currentConstBigRational.subtract(requiredValue);
                        if (!this.setValueToBitfield(indexes, i, result)) {
                            return null;
                        }
                        BigRational indexValSubtr = new BigRational(indexes[i].longValue());
                        requiredValue = requiredValue.subtract(currentConstBigRational.subtract(indexValSubtr));
                        break;
                    }
                    case ADD: {
                        result = requiredValue.subtract(currentConstBigRational);
                        if (!this.setValueToBitfield(indexes, i, result)) {
                            return null;
                        }
                        requiredValue = requiredValue.subtract(currentConstBigRational.add(indexes[i].longValue()));
                        break;
                    }
                }
                if (indexes[i].compareTo(new Long((2 << this.bitFields[i].getWidth() - 1) - 1)) <= 0) break;
                return null;
            }
            ++i;
        }
        return requiredValue;
    }

    boolean setValueToBitfield(Long[] indexes, int position, BigRational requiredValue) {
        try {
            double numerator = requiredValue.getNumerator().longValueExact();
            double denominator = requiredValue.getDenominator().longValueExact();
            indexes[position] = this.bitFields.length - 1 == position ? new Long(Math.round(numerator / denominator)) : new Long((long)(numerator / denominator));
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
        return true;
    }

    public @NonNull LongValues getDefaultBfValues() {
        LongValues.Builder builder = new LongValues.Builder();
        BitFieldElement[] bitFieldElementArray = this.bitFields;
        int n = this.bitFields.length;
        int n2 = 0;
        while (n2 < n) {
            BitFieldElement bitField = bitFieldElementArray[n2];
            Long value = bitField.getBitField().getResetValue().longValue();
            assert (value != null);
            builder.addValue(value);
            ++n2;
        }
        return builder.build();
    }

    private @NonNull BitFieldElement @NonNull [] findBitFields() {
        ArrayList<@NonNull BitFieldElement> foundBitfields = new ArrayList<BitFieldElement>();
        for (BitFieldVariable bfVar : this.expression.getBitFields()) {
            String bitFieldId = this.expression.getContext().getBitFieldId(bfVar.getRegisterName(), bfVar.getBitFieldName());
            BitFieldElement foundBitField = ClocksBitFieldProvider.getBitFieldById(bitFieldId, this.registers);
            if (foundBitField == null) continue;
            foundBitfields.add(foundBitField);
        }
        return Calculus.toArray(foundBitfields);
    }

    private static @NonNull BitFieldElement @NonNull [] toArray(@NonNull List<@NonNull BitFieldElement> bitfields) {
        @NonNull BitFieldElement[] array = new BitFieldElement[bitfields.size()];
        array = bitfields.toArray(array);
        assert (array != null);
        return array;
    }

    public @Nullable Object getProblematicConstraint() {
        return this.problematicConstraint;
    }
}

