/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.elements;

import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.ErrorHelper;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ElementType;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.elements.Splitter;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.OutputFrequencySetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.ConfigContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.FrequencyRange;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IValue;
import com.nxp.swtools.common.utils.expression.Value;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AClockElement
implements IClockElement {
    @NonNull
    protected IRegistersDatabaseAPI registers;
    @NonNull
    protected String id;
    @Nullable
    protected String name;
    @NonNull
    protected String description;
    @Nullable
    protected String inputSignal;
    @NonNull
    protected ISetting outputFSetting;
    @Nullable
    protected ModelCreationI modelDevice;
    @NonNull
    protected Map<String, ISetting> settings;
    @NonNull
    protected Map<String, ISetting> powerModeSpecificSettings;
    @Nullable
    Splitter splitter;
    @NonNull
    protected @NonNull List<@NonNull Constraint> constraints;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(AClockElement.class);
    @NonNull
    protected final @NonNull Set<@NonNull IClockElement> successors = new HashSet<IClockElement>();
    @NonNull
    protected final @NonNull Set<@NonNull IClockElement> predecessors = new HashSet<IClockElement>();
    @NonNull
    protected @NonNull Map<@NonNull Expression, @NonNull ValueMap> values = new HashMap<Expression, ValueMap>();
    private boolean prioritized = false;
    private boolean isPowerModeSpecific;
    @NonNull
    protected @NonNull List<@NonNull IConfigElement> configElements;

    public AClockElement(@NonNull IRegistersDatabaseAPI registers, @NonNull String id, @Nullable String name, @NonNull String description, @Nullable String inputSignal, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull IConfigElement> configElements, boolean prioritized) {
        this.registers = registers;
        this.id = id;
        this.name = name;
        this.description = description;
        this.inputSignal = inputSignal;
        this.settings = new LinkedHashMap<String, ISetting>();
        this.powerModeSpecificSettings = new LinkedHashMap<String, ISetting>();
        this.outputFSetting = this.createOutputFrequencySetting();
        this.settings.put(this.outputFSetting.getId(), this.outputFSetting);
        this.constraints = constraints;
        for (IConfigElement config : configElements) {
            ISetting configSetting = config.getSetting();
            this.settings.put(configSetting.getId(), configSetting);
        }
        this.configElements = configElements;
        this.prioritized = prioritized;
    }

    public AClockElement(@NonNull IRegistersDatabaseAPI registers, @NonNull String id, @Nullable String name, @NonNull String description, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull IConfigElement> configElements, boolean prioritized) {
        this(registers, id, name, description, null, constraints, configElements, prioritized);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public @NonNull String getName() {
        String nameLoc = this.name;
        if (nameLoc != null && !nameLoc.isEmpty()) {
            return nameLoc;
        }
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public @NonNull String getType() {
        return ElementType.OTHER.toString();
    }

    @Override
    public String getInputSignal() {
        return this.inputSignal;
    }

    @Override
    public void setInputSignal(@NonNull String signal) {
        this.inputSignal = signal;
    }

    @Override
    public Node getComputationNode(@NonNull IClocksConfig config) {
        return config.getClocksModel().getNode(this.id);
    }

    public ModelCreationI getDevice() {
        assert (this.modelDevice != null);
        return this.modelDevice;
    }

    public void setDevice(Node nd) {
        if (!this.id.equals(nd.getID())) {
            LOGGER.severe(MessageFormat.format("Element {0} has wrong ID in computation model ({1})", this.id, nd.getID()));
        }
    }

    @Override
    public @Nullable IClockComponent getParentComponent(IMcu mcu) {
        String componentID = Text.getComponentID(this.id);
        return mcu.getClockComponent(componentID);
    }

    @Override
    public List<@NonNull ISetting> getSettings() {
        Collection<ISetting> settingValues = this.settings.values();
        assert (!settingValues.contains(null));
        return new ArrayList<ISetting>(settingValues);
    }

    @Override
    public List<@NonNull ISetting> getPowerModeSpecificSettings() {
        Collection<ISetting> settingValues = this.powerModeSpecificSettings.values();
        assert (!settingValues.contains(null));
        return new ArrayList<ISetting>(settingValues);
    }

    @Override
    public List<@NonNull IClockElement> getInternalElements() {
        return null;
    }

    @Override
    public void addNestedSetting(@NonNull ISetting setting) {
        this.settings.put(setting.getId(), setting);
    }

    @Override
    public @NonNull ISetting getOutputFrequencySetting() {
        return this.outputFSetting;
    }

    @Override
    public @Nullable ISetting getFrequencyModifierSetting() {
        return this.getSetting(SettingType.FREQUENCY_MODIFIER);
    }

    @Override
    public @Nullable ISetting getFrequencyGateSetting() {
        return this.getSetting(SettingType.FREQUENCY_GATE);
    }

    @Override
    public @Nullable EnableSetting getEnableSetting() {
        return (EnableSetting)this.getSetting(SettingType.ENABLE_DISABLE);
    }

    @Override
    public @NonNull List<@NonNull ISetting> getLocalConfigElementSettings() {
        return this.getSettings(SettingType.LOCAL_CONFIG_ELEMENT);
    }

    @Override
    public @NonNull List<@NonNull ISetting> getBitFieldSettings() {
        return this.getSettings(SettingType.BIT_FIELD);
    }

    @Override
    public @NonNull List<@NonNull ISetting> getSettings(SettingType ... types) {
        ArrayList<@NonNull ISetting> result = new ArrayList<ISetting>();
        for (ISetting setting : this.settings.values()) {
            if (!AClockElement.contains(types, setting.getType())) continue;
            result.add(setting);
        }
        return result;
    }

    @Override
    public @Nullable ISetting getSetting(SettingType ... types) {
        List<@NonNull ISetting> settingsFound = this.getSettings(types);
        return settingsFound.size() == 1 ? settingsFound.get(0) : null;
    }

    private static boolean contains(@NonNull SettingType @NonNull [] types, @NonNull SettingType type) {
        SettingType[] settingTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            SettingType arrayType = settingTypeArray[n2];
            if (arrayType == type) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public @Nullable Splitter getSplitter() {
        return this.splitter;
    }

    @Override
    public void setSplitter(Splitter splitter) {
        this.splitter = splitter;
    }

    protected @NonNull ISetting createOutputFrequencySetting() {
        return new OutputFrequencySetting(this);
    }

    @Override
    public @Nullable Frequency getOutputFrequency(@NonNull IClocksConfig config) {
        BigRational freq;
        Node compNode = this.getComputationNode(config);
        if (compNode != null && (freq = compNode.getOutputClock()) != null) {
            return new Frequency(freq, FrequencyUnit.HERTZ);
        }
        return null;
    }

    @Override
    public @NonNull IRegistersDatabaseAPI getRegisters() {
        return this.registers;
    }

    @Override
    public @Nullable String getEnableText(@NonNull IClocksConfig config) {
        EnableSetting enableSetting = this.getEnableSetting();
        if (enableSetting != null) {
            String activeCaseDescription = enableSetting.activeCase(config, new HashSet<String>()).getDescription();
            return activeCaseDescription.isEmpty() ? null : activeCaseDescription;
        }
        return null;
    }

    @Override
    public @Nullable String @Nullable [] getConstraintsText(@NonNull IClocksConfig config) {
        List<@NonNull Constraint> elementConstraints = this.getElementConstraints();
        ArrayList<@NonNull String> constraintDescriptions = new ArrayList<String>();
        for (Constraint constraint : elementConstraints) {
            Value result;
            Expression restriction = constraint.getRestriction();
            Object object = result = restriction == null ? Value.valueOf((boolean)true) : restriction.resolve();
            if (result.getType() == IValue.Type.LONG) {
                ValueMap activeValueMap = this.getActiveValueMap(config);
                assert (activeValueMap != null);
                Collection<@NonNull Object> controlValues = activeValueMap.getControlValues();
                for (Object allowedValue : controlValues) {
                    if (!allowedValue.toString().equals(result.toString())) continue;
                    String constraintDescription = MessageFormat.format(Messages.get().AClockElement_ConstraintDescriptionForValue, result.getString(), constraint.getDescription());
                    constraintDescriptions.add(UtilsText.safeString((String)constraintDescription));
                }
                continue;
            }
            if (!constraint.isApplicable(config)) continue;
            constraintDescriptions.add(constraint.getDescription());
        }
        @Nullable String[] results = new String[constraintDescriptions.size()];
        return constraintDescriptions.isEmpty() ? null : constraintDescriptions.toArray(results);
    }

    @Override
    public void configureConfig(@NonNull IClocksConfig config) {
        Frequency outFreq = this.getOutputFrequency(config);
        SettingValue outFSettingValue = null;
        if (outFreq != null) {
            outFSettingValue = this.outputFSetting.parseValue(outFreq, config);
        }
        if (outFSettingValue == null) {
            outFSettingValue = SettingValue.FREQ_N_A;
        }
        config.setSettingValue(this.outputFSetting, outFSettingValue, false, false);
        if (this.isEnabled(config)) {
            this.loadFromModel(config);
        }
    }

    @Override
    public void configureModel(@NonNull IClocksConfig config, boolean lockedOnly) {
        Node computationNodeLoc = this.getComputationNode(config);
        if (computationNodeLoc != null) {
            if (this.isEnabledForModel(config)) {
                computationNodeLoc.enable();
            } else {
                computationNodeLoc.disable();
            }
        }
        this.evaluateConstraints(config);
        this.saveToModel(config, lockedOnly);
    }

    protected boolean saveOutputFrequency(@NonNull IClocksConfig config, @NonNull Node compNode, boolean lockedOnly, boolean setInput) {
        boolean saved = false;
        ISetting outputSetting = this.getOutputFrequencySetting();
        SettingsConfig settingsConfig = config.getSettingsConfig();
        SettingValue value = settingsConfig.getSettingValue(outputSetting);
        if (!settingsConfig.isLocked(outputSetting) && (value.isN_A() || lockedOnly)) {
            compNode.clean();
        } else {
            Object valueObject = value.getValue();
            LockState lockState = config.getSettingsConfig().getLockState(outputSetting);
            if (lockState != null) {
                valueObject = lockState.getValue().getValue();
                if (valueObject instanceof Frequency) {
                    BigRational accuracy = settingsConfig.getLockAccuracy(outputSetting);
                    if (accuracy != null) {
                        compNode.setAccuracy(accuracy);
                    }
                    saved = this.saveFrequencyValue(compNode, setInput, valueObject);
                } else {
                    LOGGER.warning("Frequency expected, but got: " + valueObject + ": " + valueObject.getClass().getSimpleName());
                }
            }
        }
        return saved;
    }

    public boolean saveFrequencyValue(@NonNull Node compNode, boolean setInput, @NonNull Object valueObject) {
        Frequency oldFreq;
        boolean saved = false;
        Frequency freq = (Frequency)valueObject;
        BigRational outputClock = this.getOutputClockFromModel(compNode);
        Frequency frequency = oldFreq = outputClock != null ? Converter.toFrequency(outputClock) : null;
        if (!Objects.equals(oldFreq, freq)) {
            if (setInput) {
                compNode.setInputFrequency(Converter.toHertz(freq));
                saved = true;
            } else {
                compNode.setOutputFrequency(Converter.toHertz(freq));
                saved = true;
            }
        }
        return saved;
    }

    public @Nullable BigRational getOutputClockFromModel(Node compNode) {
        BigRational outputClock = null;
        try {
            outputClock = compNode.getOutputClock();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        return outputClock;
    }

    @Override
    public boolean isEnabledForModel(@NonNull IClocksConfig config) {
        EnableSetting.EnableType enableType;
        EnableSetting enableSetting = this.getEnableSetting();
        return enableSetting == null || !(enableType = enableSetting.findEnableType(config)).equals((Object)EnableSetting.EnableType.HARD_DISABLE);
    }

    @Override
    public boolean isValid(@NonNull IClocksConfig config) {
        return config.getProblemsOfElement(this.id, 2).isEmpty();
    }

    @Override
    public boolean isEnabled(IClocksConfig config) {
        EnableSetting enableSetting = this.getEnableSetting();
        if (enableSetting != null) {
            return enableSetting.isEnabled(config);
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public List<@NonNull Constraint> evaluateConstraints(@NonNull IClocksConfig config) {
        ArrayList<@NonNull Constraint> violatedConstraints = new ArrayList();
        try {
            violatedConstraints = this.getViolatedConstraints(config);
            List<@NonNull Constraint> applicableConstraints = this.getValidApplicableConstraints(config);
            Node computationNodeLocal = this.getComputationNode(config);
            if (computationNodeLocal != null) {
                this.updateMinMaxConstraints((List)applicableConstraints.stream().filter(x -> x.getLevel().equals((Object)Constraint.Level.ERROR)).collect(CollectorsUtils.toList()), computationNodeLocal);
                @NonNull List inputConstraints = (List)applicableConstraints.stream().filter(x -> x.getLevel().equals((Object)Constraint.Level.WARNING)).filter(x -> x.isOnInput()).collect(CollectorsUtils.toList());
                @NonNull List outputConstraints = (List)applicableConstraints.stream().filter(x -> x.getLevel().equals((Object)Constraint.Level.WARNING)).filter(x -> !x.isOnInput()).collect(CollectorsUtils.toList());
                this.checkFrequencyWarnings(this.outputFSetting, config, outputConstraints);
                this.predecessors.forEach(x -> this.checkFrequencyWarnings(x.getOutputFrequencySetting(), config, inputConstraints));
            }
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return violatedConstraints;
    }

    protected @NonNull List<@NonNull Constraint> getValidApplicableConstraints(@NonNull IClocksConfig config) {
        ArrayList<@NonNull Constraint> applicableConstraints = new ArrayList<Constraint>();
        for (Constraint constraint : this.getElementConstraints()) {
            if (!constraint.isValid(config) || !constraint.isApplicable(config)) continue;
            applicableConstraints.add(constraint);
        }
        return applicableConstraints;
    }

    protected @NonNull List<@NonNull Constraint> getValidApplicableConstraints(@NonNull IClocksConfig config, @NonNull BigRational value) {
        ArrayList<@NonNull Constraint> applicableConstraints = new ArrayList<Constraint>();
        for (Constraint constraint : this.getElementConstraints()) {
            if (!constraint.isApplicable(config, value) || !constraint.isValid(config, value)) continue;
            applicableConstraints.add(constraint);
        }
        return applicableConstraints;
    }

    protected @NonNull List<@NonNull Constraint> getViolatedConstraints(@NonNull IClocksConfig config) {
        ArrayList<@NonNull Constraint> violatedConstraints = new ArrayList<Constraint>();
        for (Constraint constraint : this.getElementConstraints()) {
            if (constraint.isValid(config)) continue;
            violatedConstraints.add(constraint);
        }
        return violatedConstraints;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void updateMinMaxConstraints(@NonNull List<@NonNull Constraint> applicableConstraints, @NonNull Node compNode) {
        @NonNull List inputConstraints = (List)applicableConstraints.stream().filter(x -> x.isOnInput()).collect(CollectorsUtils.toList());
        @NonNull List outputConstraints = (List)applicableConstraints.stream().filter(x -> !x.isOnInput()).collect(CollectorsUtils.toList());
        List<@NonNull FrequencyRange> inputRanges = AClockElement.calculateFrequencyRanges(inputConstraints);
        List<@NonNull FrequencyRange> outputRanges = AClockElement.calculateFrequencyRanges(outputConstraints);
        BigRational minOut = AClockElement.calculateMinFrequency(outputConstraints);
        BigRational maxOut = AClockElement.calculateMaxFrequency(outputConstraints);
        BigRational maxInput = AClockElement.calculateMaxFrequency(inputConstraints);
        BigRational minInput = AClockElement.calculateMinFrequency(inputConstraints);
        if (this instanceof ClockOutput) {
            if (minInput != null) {
                minOut = minInput;
            } else {
                minInput = minOut;
            }
            if (maxInput != null) {
                maxOut = maxInput;
            } else {
                maxInput = maxOut;
            }
        }
        if (inputRanges != null) {
            compNode.setInputFrequencyRanges(inputRanges);
        } else {
            compNode.setMaxInputFreq(maxInput);
            compNode.setMinInputFreq(minInput);
        }
        if (outputRanges != null) {
            compNode.setOutputFrequencyRanges(outputRanges);
        } else {
            compNode.setMinOutputFreq(minOut);
            compNode.setMaxOutputFreq(maxOut);
        }
    }

    static @Nullable BigRational calculateMinFrequency(@NonNull List<@NonNull Constraint> elementConstraints) {
        BigRational maxRational;
        BigRational minimal = maxRational = new BigRational(Integer.MAX_VALUE);
        boolean isDefined = false;
        for (Constraint constraint : elementConstraints) {
            Frequency minFrequency = constraint.getMinFrequencyWithAccuracy();
            if (minFrequency == null) {
                minFrequency = constraint.getFrequencyWithAccuracy();
            }
            if (minFrequency == null) continue;
            BigRational ratValue = Converter.toHertz(minFrequency);
            if (!minimal.equals((Object)maxRational) && minimal.compareTo(ratValue) >= 0) continue;
            minimal = ratValue;
            isDefined = true;
        }
        return isDefined ? minimal : null;
    }

    static @Nullable List<@NonNull FrequencyRange> calculateFrequencyRanges(@NonNull List<@NonNull Constraint> elementConstraints) {
        List<@NonNull FrequencyRange> ranges = null;
        for (Constraint constraint : elementConstraints) {
            List<@NonNull FrequencyRange> constraintRanges = constraint.getFrequencyRanges();
            if (constraintRanges == null) continue;
            ranges = ranges == null ? constraintRanges : AClockElement.mergeFrequencyRanges(ranges, constraintRanges);
        }
        return ranges;
    }

    static @NonNull List<@NonNull FrequencyRange> mergeFrequencyRanges(@NonNull List<@NonNull FrequencyRange> ranges, @NonNull List<@NonNull FrequencyRange> constraintRanges) {
        ArrayList<@NonNull FrequencyRange> merged = new ArrayList<FrequencyRange>();
        Iterator<FrequencyRange> firstIterator = ranges.iterator();
        Iterator<FrequencyRange> secondIterator = constraintRanges.iterator();
        FrequencyRange firstRange = firstIterator.hasNext() ? firstIterator.next() : null;
        FrequencyRange secondRange = secondIterator.hasNext() ? secondIterator.next() : null;
        while (firstRange != null || secondRange != null) {
            if (firstRange == null) {
                if (secondRange == null) continue;
                merged.add(secondRange);
                secondRange = secondIterator.hasNext() ? secondIterator.next() : null;
                continue;
            }
            if (secondRange == null) {
                merged.add(firstRange);
                firstRange = firstIterator.hasNext() ? firstIterator.next() : null;
                continue;
            }
            if (firstRange.getMinimalFrequency().compareTo(secondRange.getMinimalFrequency()) == -1) {
                merged.add(firstRange);
                firstRange = firstIterator.hasNext() ? firstIterator.next() : null;
                continue;
            }
            merged.add(secondRange);
            FrequencyRange frequencyRange = secondRange = secondIterator.hasNext() ? secondIterator.next() : null;
        }
        return merged;
    }

    protected static @Nullable BigRational calculateMaxFrequency(@NonNull List<@NonNull Constraint> elementConstraints) {
        BigRational maximal = BigRational.ZERO;
        boolean isDefined = false;
        for (Constraint constraint : elementConstraints) {
            Frequency maxFrequency = constraint.getMaxFrequencyWithAccuracy();
            if (maxFrequency == null) {
                maxFrequency = constraint.getFrequencyWithAccuracy();
            }
            if (maxFrequency == null) continue;
            BigRational ratValue = Converter.toHertz(maxFrequency);
            if (!maximal.equals((Object)BigRational.ZERO) && maximal.compareTo(ratValue) <= 0) continue;
            maximal = ratValue;
            isDefined = true;
        }
        return isDefined ? maximal : null;
    }

    protected abstract void loadFromModel(@NonNull IClocksConfig var1);

    protected abstract void saveToModel(@NonNull IClocksConfig var1, boolean var2);

    @Override
    public void addSuccessor(@NonNull IClockElement successor) {
        this.successors.add(successor);
    }

    @Override
    public void removeSuccessor(@NonNull IClockElement successor) {
        this.successors.remove(successor);
    }

    @Override
    public void setName(@NonNull String name) {
        this.name = name;
    }

    @Override
    public void setDescription(@Nullable String description) {
        this.description = UtilsText.safeString((String)description);
    }

    @Override
    public void setId(@NonNull String id) {
        this.id = id;
    }

    @Override
    public void setPowerModeSpecific(boolean isPowerModeSpecific) {
        this.isPowerModeSpecific = isPowerModeSpecific;
    }

    @Override
    public boolean isPowerModeSpecific() {
        return this.isPowerModeSpecific;
    }

    @Override
    public @NonNull Map<@NonNull String, ISetting> createPowerModeSpecificSettings(@NonNull List<@NonNull PowerMode> powerModes) {
        return new HashMap<String, ISetting>();
    }

    @Override
    public @NonNull Collection<@NonNull IClockElement> getSuccessors() {
        return this.successors;
    }

    @Override
    public @NonNull Collection<@NonNull IClockElement> getPredecessors() {
        return this.predecessors;
    }

    @Override
    public void addPredecessor(@NonNull IClockElement predecessor) {
        this.predecessors.add(predecessor);
    }

    @Override
    public @NonNull Map<@NonNull Expression, @NonNull ValueMap> getValues() {
        return this.values;
    }

    @Override
    public @NonNull List<@NonNull Constraint> getElementConstraints() {
        ArrayList<@NonNull Constraint> elementConstraints = new ArrayList<Constraint>();
        for (Constraint constraint : this.constraints) {
            if (!this.id.equals(constraint.getElementID())) continue;
            elementConstraints.add(constraint);
        }
        return elementConstraints;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [id=" + this.id + "]";
    }

    @Override
    public void addFrequencyError(boolean isOnInput, @NonNull Map<@NonNull String, @NonNull String> errors, @NonNull Node device) {
        String message = AClockElement.composeFrequencyErrorMessage(isOnInput, device);
        if (message == null) {
            LOGGER.warning("Error logged, but there is not any constraint on min or max frequency on " + this.getID());
            message = Messages.get().AClockElement_ErrorsInInternalElements;
            assert (message != null);
        }
        ErrorHelper.addErrorIfNotPresent(this.getID(), message, errors);
    }

    @Override
    public void addDivisionError(EDividerError errorType, @NonNull Map<@NonNull String, @NonNull String> errors, @NonNull IMcu mcu, @NonNull Node device, @NonNull IClocksConfig config) {
        String message = ErrorHelper.extractDivisionErrorMessage(errorType, device, mcu, config, this.getFrequencyModifierSetting());
        ErrorHelper.addErrorIfNotPresent(this.getID(), message, errors);
    }

    protected static @Nullable String composeFrequencyErrorMessage(boolean isOnInput, @NonNull Node device) {
        BigRational max;
        BigRational min;
        if (isOnInput) {
            min = device.getMinInputFreq();
            max = device.getMaxInputFreq();
        } else {
            min = device.getMinOutputFreq();
            max = device.getMaxOutputFreq();
        }
        String minText = null;
        String maxText = null;
        if (min != null && max != null && min.compareTo(max) == 1) {
            return Messages.get().AClockElement_InvalidState;
        }
        if (min != null) {
            minText = Converter.toNormalizedFrequency(min).toString();
        }
        if (max != null) {
            maxText = Converter.toNormalizedFrequency(max).toString();
        }
        return ErrorHelper.extractFrequencyErrorMessage(isOnInput, minText, maxText);
    }

    @Override
    public @Nullable ValueMap getActiveValueMap(@Nullable IClocksConfig config) {
        Iterator<ValueMap> valueMapIterator;
        ValueMap result = null;
        Map<@NonNull Expression, @NonNull ValueMap> valuesLoc = this.values;
        if (!valuesLoc.isEmpty() && config != null) {
            try {
                for (Map.Entry<Expression, ValueMap> entry : valuesLoc.entrySet()) {
                    ConfigContext context;
                    Expression expression = entry.getKey();
                    if (!expression.resolve(context = new ConfigContext(expression.getContext(), config)).getBoolean()) continue;
                    return entry.getValue();
                }
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Not resolvable condition for value map in: " + this.id, e);
            }
        }
        if ((valueMapIterator = valuesLoc.values().iterator()).hasNext()) {
            result = valueMapIterator.next();
            if (config != null) {
                LOGGER.warning("Not applicable condition for value map in: " + this.id);
            }
        }
        return result;
    }

    @Override
    public @Nullable ISetting getMainSetting() {
        return this.getFrequencyModifierSetting();
    }

    @Override
    public void cleanModel(@NonNull IClocksConfig clocksConfig) {
        Node compNodeLoc = this.getComputationNode(clocksConfig);
        if (compNodeLoc != null) {
            compNodeLoc.clean();
        } else {
            LOGGER.warning("Computation node is null");
        }
    }

    @Override
    public boolean isPrioritized() {
        return this.prioritized;
    }

    private void checkFrequencyWarnings(@NonNull ISetting setting, @NonNull IClocksConfig config, @NonNull List<@NonNull Constraint> warningConstraints) {
        SettingValue settingValue;
        Object value;
        if (setting instanceof OutputFrequencySetting && this.isEnabled(config) && (value = (settingValue = config.getSettingsConfig().getSettingValue(setting)).getValue()) instanceof Frequency) {
            BigRational rationalValue = Converter.toHertz((Frequency)value);
            BigRational minOut = AClockElement.calculateMinFrequency(warningConstraints);
            BigRational maxOut = AClockElement.calculateMaxFrequency(warningConstraints);
            List<@NonNull FrequencyRange> outputRanges = AClockElement.calculateFrequencyRanges(warningConstraints);
            if (setting instanceof ClockSourceSetting && outputRanges != null) {
                this.evalueteFrequencyRangeWarnings(config, rationalValue, outputRanges);
            } else {
                this.evaluateFrequencyWarnnings(config, rationalValue, minOut, maxOut);
            }
        }
    }

    private void evalueteFrequencyRangeWarnings(@NonNull IClocksConfig config, @NonNull BigRational rationalValue, @NonNull List<@NonNull FrequencyRange> outputRanges) {
        boolean isInrange = false;
        for (FrequencyRange range : outputRanges) {
            if (!range.isInRange(rationalValue)) continue;
            isInrange = true;
        }
        if (!isInrange) {
            config.addWarning(this.id, MessageFormat.format(Messages.get().Constraint_FrequencyMustBeInRange, outputRanges.toString()));
        }
    }

    private void evaluateFrequencyWarnnings(@NonNull IClocksConfig config, @NonNull BigRational actualFreq, @Nullable BigRational minOut, @Nullable BigRational maxOut) {
        if (minOut != null && actualFreq.compareTo(minOut) == -1) {
            config.addWarning(this.id, ErrorHelper.extractFrequencyErrorMessage(false, minOut, maxOut));
        } else if (maxOut != null && actualFreq.compareTo(maxOut) == 1) {
            config.addWarning(this.id, ErrorHelper.extractFrequencyErrorMessage(false, minOut, maxOut));
        }
    }

    @Override
    public @Nullable SettingValue getEnableValue(@NonNull IClocksConfig config) {
        ISetting mainSetting = this.getMainSetting();
        if (mainSetting != null) {
            return mainSetting.getDefaultValue(config);
        }
        return null;
    }
}

