/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.dependencies;

import com.nxp.swtools.clocks.data.dependencies.IEditableDirectedGraph;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DirectedGraph
implements IEditableDirectedGraph {
    @NonNull
    protected final @NonNull Map<@NonNull String, @Nullable Collection<@NonNull String>> successorsMap;
    @NonNull
    protected final @NonNull Map<@NonNull String, Collection<@NonNull String>> predecessorsMap;
    @NonNull
    protected final @NonNull Collection<@NonNull String> roots;

    private DirectedGraph(@NonNull Collection<@NonNull String> roots, @NonNull Map<@NonNull String, @Nullable Collection<@NonNull String>> successors) {
        this.successorsMap = successors;
        this.predecessorsMap = new HashMap<String, Collection<String>>();
        this.fillPredecessorsFromSuccessors();
        this.roots = roots;
    }

    public DirectedGraph(@NonNull Map<@NonNull String, @Nullable Collection<@NonNull String>> successors) {
        this.successorsMap = successors;
        this.predecessorsMap = new HashMap<String, Collection<String>>();
        this.fillPredecessorsFromSuccessors();
        this.roots = new HashSet<String>();
        this.refreshRoots();
    }

    protected void fillPredecessorsFromSuccessors() {
        this.predecessorsMap.clear();
        this.successorsMap.forEach((pred, successors) -> {
            if (successors != null) {
                successors.forEach(succ -> {
                    if (this.predecessorsMap.containsKey(succ)) {
                        Objects.requireNonNull(this.predecessorsMap.get(succ)).add((String)pred);
                    } else {
                        HashSet<@NonNull String> predcessors = new HashSet<String>();
                        predcessors.add((String)pred);
                        this.predecessorsMap.put((String)succ, (Collection<String>)predcessors);
                    }
                });
            }
        });
    }

    public DirectedGraph() {
        this.successorsMap = new HashMap<String, Collection<String>>();
        this.predecessorsMap = new HashMap<String, Collection<String>>();
        this.roots = new HashSet<String>();
    }

    @Override
    public @NonNull Collection<@NonNull String> getRoots() {
        return CollectionsUtils.unmodifiableCollection(this.roots);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Collection<@NonNull String> getPredecessors(@NonNull String node) {
        @NonNull List predecessors = this.predecessorsMap.get(node);
        return predecessors != null ? predecessors : CollectionsUtils.emptyUnmodifiableList();
    }

    @Override
    public @NonNull Collection<@NonNull String> getSuccessors(@NonNull String node) {
        Collection<@NonNull String> successors = this.successorsMap.get(node);
        return successors == null ? CollectionsUtils.emptyUnmodifiableList() : CollectionsUtils.unmodifiableCollection(successors);
    }

    @Override
    public boolean removeNode(@NonNull String node) {
        boolean change = this.roots.remove(node);
        change = this.successorsMap.remove(node) != null || change;
        for (Collection<String> successors : this.successorsMap.values()) {
            if (successors == null) continue;
            boolean bl = change = successors.remove(node) || change;
        }
        change = !Objects.isNull(this.predecessorsMap.remove(node)) || change;
        for (Collection<String> predecessors : this.predecessorsMap.values()) {
            if (predecessors == null) continue;
            boolean bl = change = predecessors.remove(node) || change;
        }
        return change;
    }

    @Override
    public boolean removeEdge(@NonNull String from, @NonNull String to) {
        Collection<String> predecessors;
        boolean change = false;
        Collection<@NonNull String> successors = this.successorsMap.get(from);
        if (successors != null) {
            boolean bl = change = successors.remove(to) || change;
            if (successors.isEmpty()) {
                this.successorsMap.put(from, null);
            }
        }
        if ((predecessors = this.predecessorsMap.get(to)) != null) {
            boolean bl = change = predecessors.remove(from) || change;
            if (predecessors.isEmpty()) {
                this.predecessorsMap.remove(to);
            }
        }
        return change;
    }

    @Override
    public boolean addEdge(@NonNull String from, @NonNull String to) {
        boolean change = this.addNode(to);
        Collection<@NonNull String> successors = this.successorsMap.get(from);
        if (successors != null) {
            change = successors.add(to) || change;
        } else {
            successors = new HashSet<String>();
            successors.add(to);
            this.successorsMap.put(from, successors);
        }
        if (this.predecessorsMap.containsKey(to)) {
            change = Objects.requireNonNull(this.predecessorsMap.get(to)).add(from) || change;
        } else {
            HashSet<@NonNull String> predecessors = new HashSet<String>();
            predecessors.add(from);
            change = !Objects.isNull(this.predecessorsMap.put(to, predecessors)) || change;
        }
        return change;
    }

    @Override
    public boolean addRoot(@NonNull String node) {
        boolean change = this.addNode(node);
        return this.roots.add(node) || change;
    }

    @Override
    public boolean removeRoot(@NonNull String node) {
        return this.roots.remove(node);
    }

    public void refreshRoots() {
        HashSet<String> unvisitedNodes;
        this.roots.clear();
        this.roots.addAll(this.findIndependentNodes());
        HashSet<@NonNull String> allNodes = new HashSet<String>();
        allNodes.addAll(this.successorsMap.keySet());
        do {
            unvisitedNodes = new HashSet<String>();
            unvisitedNodes.addAll(allNodes);
            for (String root : this.roots) {
                unvisitedNodes.remove(root);
                this.inspectSuccessors(root, unvisitedNodes);
            }
            if (unvisitedNodes.isEmpty()) continue;
            this.roots.add((String)unvisitedNodes.iterator().next());
        } while (!unvisitedNodes.isEmpty());
        HashSet<@NonNull String> newRoots = new HashSet<String>(this.roots);
        for (String root : this.roots) {
            if (!newRoots.contains(root)) continue;
            unvisitedNodes = new HashSet();
            unvisitedNodes.addAll(allNodes);
            unvisitedNodes.remove(root);
            this.inspectSuccessors(root, unvisitedNodes);
            newRoots.retainAll(unvisitedNodes);
            newRoots.add(root);
        }
        this.roots.clear();
        this.roots.addAll(newRoots);
    }

    private void inspectSuccessors(@NonNull String node, @NonNull Set<@NonNull String> unvisitedNodes) {
        Collection<@NonNull String> successors = this.successorsMap.get(node);
        if (successors != null) {
            for (String successor : successors) {
                if (!unvisitedNodes.contains(successor)) continue;
                unvisitedNodes.remove(successor);
                this.inspectSuccessors(successor, unvisitedNodes);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Collection<@NonNull String> findIndependentNodes() {
        @NonNull Collection settingsWithPredcessors = CollectionsUtils.safeCollection((Collection)CollectionsUtils.union(this.successorsMap.values()));
        HashSet<@NonNull String> settingsWithoutPredcessors = new HashSet<String>();
        settingsWithoutPredcessors.addAll(this.successorsMap.keySet());
        settingsWithoutPredcessors.removeAll(settingsWithPredcessors);
        return settingsWithoutPredcessors;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("digraph").append(" ").append("{").append("\n");
        HashSet<@NonNull String> allNodes = new HashSet<String>();
        allNodes.addAll(this.successorsMap.keySet());
        for (String string : this.successorsMap.keySet()) {
            sb.append(DirectedGraph.escape(string));
            sb.append(this.roots.contains(string) ? this.getRootStyle(string) : this.getNonRootStyle(string));
            sb.append("\n");
        }
        for (Map.Entry entry : this.successorsMap.entrySet()) {
            @NonNull Collection successorList = (Collection)entry.getValue();
            if (successorList == null) continue;
            successorList.forEach(x -> {
                String xString = DirectedGraph.escape(x);
                String yString = DirectedGraph.escape((String)entry.getKey());
                sb.append(yString).append("->").append(xString);
                sb.append(this.getEdgeStyle((String)entry.getKey(), (String)x));
                sb.append("\n");
            });
        }
        sb.append("}");
        return sb.toString();
    }

    private static @NonNull String escape(@NonNull String id) {
        return "\"" + id + "\"";
    }

    protected @NonNull String getRootStyle(@NonNull String node) {
        return "[style=filled,fillcolor=grey]";
    }

    protected @NonNull String getNonRootStyle(@NonNull String node) {
        return "";
    }

    protected @NonNull String getEdgeStyle(@NonNull String from, @NonNull String to) {
        return "";
    }

    @Override
    public @NonNull IEditableDirectedGraph createEditableCopy() {
        HashMap<@NonNull String, @Nullable Collection<@NonNull String>> successors = new HashMap<String, Collection<String>>();
        this.successorsMap.forEach((x, y) -> {
            if (y == null) {
                successors.put((String)x, (Collection<String>)y);
            } else {
                successors.put((String)x, new HashSet(y));
            }
        });
        return new DirectedGraph(new HashSet<String>(this.roots), successors);
    }

    @Override
    public @NonNull Collection<@NonNull String> getAllNodes() {
        return new HashSet<String>(this.successorsMap.keySet());
    }

    @Override
    public boolean addNode(@NonNull String node) {
        if (!this.successorsMap.containsKey(node)) {
            this.successorsMap.put(node, null);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.roots.clear();
        this.successorsMap.clear();
        this.predecessorsMap.clear();
    }
}

