/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.DiagramData;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.IMcuDescriptor;
import com.nxp.swtools.clocks.data.dependencies.IDirectedGraph;
import com.nxp.swtools.clocks.data.dependencies.SettingDependencyGraph;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.ComputationalModel;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.NoClock;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.elements.PowerMode;
import com.nxp.swtools.clocks.data.elements.Root;
import com.nxp.swtools.clocks.data.elements.Splitter;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.ClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.AGeneralSetting;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.BitFieldSetting;
import com.nxp.swtools.clocks.data.settings.ClockOutputSetting;
import com.nxp.swtools.clocks.data.settings.ClockSourceSetting;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.PowerModeSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.model.ModelCreationI;
import com.nxp.swtools.clocks.model.ModelDataComI;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.clocks.verification.ExpressionVerificator;
import com.nxp.swtools.clocks.verification.ModelVerificator;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.clock.modules.PeripheralComponentFile;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.script.CompiledScript;

public class Mcu
implements IMcu {
    @NonNull
    public static final String SPLITTER_SUFFIX = "_SPLIT";
    @NonNull
    private Map<String, IClockComponent> components;
    @NonNull
    private IMcuDescriptor descriptor;
    @NonNull
    private final SettingsDB settings;
    @NonNull
    private final IRegistersDatabaseAPI registers;
    @NonNull
    private @NonNull Map<@NonNull String, IClockElement> mcuElements;
    @NonNull
    private @NonNull List<@NonNull IConfigElement> mcuConfigElements;
    private AGlobalSetting powerModeSetting;
    @NonNull
    private @NonNull Map<@NonNull String, String> outputSignals;
    @NonNull
    public static final String REGEX_CLOCK_OUTPUT = "(\\w+)(.)(\\w+)";
    @NonNull
    private static final String INPUT_NOT_VALID = "Input not valid!";
    @NonNull
    private final CompiledScript script;
    @NonNull
    private SettingsConfig defaultSettingsConfig;
    @NonNull
    private ClocksConfig defaultClocksConfig;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(Mcu.class);
    @NonNull
    private @NonNull List<@NonNull PowerMode> powerModes;
    @NonNull
    private @NonNull Map<@NonNull String, String> notAvailableElements;
    @NonNull
    private NoClock noClockElement = new NoClock();
    @NonNull
    private IDirectedGraph settingDependencyGraph;
    @NonNull
    private @NonNull Set<@NonNull BitFieldSetting> bitFieldSettings = new HashSet<BitFieldSetting>();
    @NonNull
    private @NonNull Map<@NonNull String, Set<@NonNull String>> controlledSettings = new HashMap<String, Set<String>>();
    @NonNull
    private @NonNull Collection<@NonNull DiagramSymbol> diagramSymbols;
    @NonNull
    private final PeripheralComponentFile peripheralComponentFile;
    @NonNull
    private @NonNull Collection<@NonNull Pin> pins;

    public Mcu(@NonNull CompiledScript script, @NonNull IRegistersDatabaseAPI registers, @NonNull IMcuDescriptor descriptor, @NonNull Map<@NonNull String, IClockComponent> components, @NonNull Map<@NonNull String, IClockElement> mcuElements, @NonNull List<@NonNull IConfigElement> configElements, @NonNull Map<@NonNull String, String> outputSignals, @NonNull List<@NonNull PowerMode> powerModes, @NonNull Map<@NonNull String, String> notAvailableElements, @NonNull Collection<@NonNull DiagramSymbol> diagramSymbols, @NonNull PeripheralComponentFile peripheralComponentFile) {
        this.descriptor = descriptor;
        this.components = components;
        this.mcuElements = mcuElements;
        this.mcuConfigElements = configElements;
        this.outputSignals = outputSignals;
        this.powerModes = powerModes;
        this.script = script;
        this.registers = registers;
        this.notAvailableElements = notAvailableElements;
        this.settings = this.loadSettingsDB();
        assert (this.settings != null);
        this.defaultSettingsConfig = this.createDefaultSettingsConfig();
        this.defaultClocksConfig = this.createDefaultClocksConfig();
        this.diagramSymbols = diagramSymbols;
        this.peripheralComponentFile = peripheralComponentFile;
        this.pins = this.findAllPins();
        this.fillElementConnections(this.defaultClocksConfig);
        this.settingDependencyGraph = this.createSettingDependencyGraph();
        this.createControlledSettingsRelation();
        this.defaultClocksConfig.setModel(ComputationalModel.createFor(this));
        this.defaultClocksConfig.recompute(false, null);
        this.defaultClocksConfig.getSettingsConfig().clearChanges();
        this.defaultClocksConfig.setModel(ComputationalModel.createEmptyFor(this));
        if (SWToolsProperties.isVerificationOn()) {
            ModelVerificator.verify(this, this.getDiagramDataCopy());
            ModelVerificator.verifyDependencies(this);
            LOGGER.fine("Setting dependency graph: \n" + this.settingDependencyGraph);
            ExpressionVerificator verificator = ExpressionVerificator.getInstance();
            verificator.verifyExpressions(this.defaultClocksConfig);
            verificator.verifyBitFields();
            verificator.clearExpressions();
        }
    }

    @Override
    public IRegistersDatabaseAPI getRegisters() {
        return this.registers;
    }

    private @NonNull SettingsDB loadSettingsDB() {
        this.powerModeSetting = new PowerModeSetting(this.powerModes);
        SettingsDB.Builder builder = new SettingsDB.Builder().addGlobalSetting(this.powerModeSetting);
        for (IConfigElement element : this.getAllGlobalConfigElements()) {
            builder.addGlobalSetting((AGlobalSetting)element.getSetting());
        }
        Collection<@NonNull IClockElement> elements = this.getAllElements().values();
        for (IClockElement element : elements) {
            if (element.isPowerModeSpecific()) {
                Map<@NonNull String, ISetting> powerModeSpecificSettings = element.createPowerModeSpecificSettings(this.powerModes);
                powerModeSpecificSettings.values().forEach(x -> {
                    SettingsDB.Builder builder2 = builder.addPowerModeSpecificSetting((ISetting)x);
                });
            }
            Mcu.extractSettingsFromElement(element, builder);
            List<@NonNull IClockElement> internalElements = element.getInternalElements();
            if (internalElements == null) continue;
            internalElements.forEach(x -> Mcu.extractSettingsFromElement(x, builder));
        }
        for (IClockComponent component : this.getClockComponents().values()) {
            EnableSetting enableSetting = component.getEnableSetting();
            if (enableSetting == null) continue;
            builder.addGeneralSetting(enableSetting);
        }
        for (Pin pin : this.findAllPins()) {
            EnableSetting pinEnable = pin.getEnableSetting();
            if (pinEnable == null) continue;
            builder.addGeneralSetting(pinEnable);
        }
        EnableSetting enableSetting = this.noClockElement.getEnableSetting();
        if (enableSetting != null) {
            builder.addGeneralSetting(enableSetting);
        }
        for (ISetting setting : builder.getAllSettings()) {
            for (String bitFieldID : setting.getUsedBitFields()) {
                BitFieldElement bitField = ClocksBitFieldProvider.getBitFieldById(bitFieldID, this.registers);
                if (bitField == null) continue;
                BitFieldSetting bfSetting = null;
                for (BitFieldSetting bitFieldSetting : this.bitFieldSettings) {
                    if (!bitFieldSetting.getBitField().equals(bitField)) continue;
                    bfSetting = bitFieldSetting;
                }
                if (bfSetting != null) continue;
                bfSetting = new BitFieldSetting(bitField);
                this.bitFieldSettings.add(bfSetting);
            }
        }
        this.bitFieldSettings.forEach(x -> {
            SettingsDB.Builder builder2 = builder.addGeneralSetting((AGeneralSetting)x);
        });
        @NonNull SettingsDB settingsDB = builder.build();
        return settingsDB;
    }

    private static void extractSettingsFromElement(@NonNull IClockElement element, @NonNull SettingsDB.Builder builder) {
        List<ISetting> elementSettings = element.getSettings();
        for (ISetting setting : elementSettings) {
            if (setting instanceof ClockSourceSetting) {
                builder.addClockSource((ClockSourceSetting)setting);
                continue;
            }
            if (setting instanceof ClockOutputSetting) {
                builder.addClockOutput((ClockOutputSetting)setting);
                continue;
            }
            if (!(setting instanceof AGeneralSetting)) continue;
            builder.addGeneralSetting((AGeneralSetting)setting);
        }
    }

    @Override
    public IMcuDescriptor getMcuDescriptor() {
        return this.descriptor;
    }

    @Override
    public Map<String, IClockComponent> getClockComponents() {
        return this.components;
    }

    @Override
    public IClockComponent getClockComponent(String id) {
        return this.components.get(id);
    }

    @Override
    public Map<@NonNull String, IClockElement> getAllElements() {
        LinkedHashMap<@NonNull String, IClockElement> allElements = new LinkedHashMap<String, IClockElement>(this.mcuElements);
        for (IClockComponent component : this.components.values()) {
            allElements.putAll(component.getElementsMap());
        }
        return allElements;
    }

    public @NonNull Map<@NonNull String, @NonNull Splitter> getSplitterElements() {
        HashMap<@NonNull String, @NonNull Splitter> splitters = new HashMap<String, Splitter>();
        for (IClockElement element : this.getAllElements().values()) {
            Splitter splitter = element.getSplitter();
            if (splitter == null) continue;
            splitters.put(splitter.getID(), splitter);
        }
        return splitters;
    }

    @Override
    public @Nullable IClockElement getClockElement(@NonNull String id) {
        if (id.equals(this.noClockElement.getID())) {
            return this.noClockElement;
        }
        @NonNull String[] idParts = id.split("\\.");
        IClockElement clockElement = null;
        if (idParts.length == 2) {
            clockElement = this.getClockElement(idParts[0], id);
        }
        if (clockElement == null) {
            clockElement = this.getAllElements().get(id);
        }
        return clockElement;
    }

    public @Nullable IClockElement getClockElement(@NonNull String componentID, @NonNull String id) {
        IClockComponent clockComponent = this.getClockComponent(componentID);
        if (clockComponent != null) {
            return clockComponent.getClockElement(id);
        }
        return this.mcuElements.get(componentID);
    }

    @Override
    public @NonNull Collection<@NonNull ModelDataComI> getAllModelElements() {
        boolean addNoClockElement;
        Collection<IClockElement> elementValues = this.getAllElements().values();
        if (CollectionsUtils.containsNullValue(elementValues)) {
            LOGGER.severe("Elements contains null value(s)!");
        }
        HashSet<@NonNull ModelDataComI> modelElements = new HashSet<ModelDataComI>();
        boolean bl = addNoClockElement = !this.noClockElement.getSuccessors().isEmpty();
        if (addNoClockElement) {
            modelElements.add(this.noClockElement);
            Splitter splitter = this.noClockElement.getSplitter();
            if (splitter != null) {
                modelElements.add(splitter);
            }
        }
        for (IClockElement element : elementValues) {
            if (element == null) continue;
            modelElements.add(element);
        }
        Root root = new Root(this.registers);
        ArrayList<@NonNull String> clockSourceIDs = new ArrayList<String>();
        if (addNoClockElement) {
            clockSourceIDs.add(this.noClockElement.getID());
        }
        for (ModelDataComI element : modelElements) {
            if (!(element instanceof ClockSource)) continue;
            clockSourceIDs.add(((ClockSource)element).getID());
        }
        root.getDevice().setSuccessors(clockSourceIDs);
        modelElements.add(root);
        modelElements.addAll(this.getSplitterElements().values());
        return modelElements;
    }

    private void fillElementConnections(@NonNull IClocksConfig config) {
        HashMap<@NonNull String, @NonNull String> notPairedElements = new HashMap<String, String>();
        Map<@NonNull String, IClockElement> elements = this.getAllElements();
        for (IClockElement element : elements.values()) {
            String predecessorID;
            String inputSignal = element.getInputSignal();
            String string = predecessorID = UtilsText.isEmpty((String)inputSignal) ? "" : this.getPredecessorID(UtilsText.safeString((String)inputSignal));
            if (element instanceof ClockSelect) {
                this.connectClockSelect(element);
                continue;
            }
            if (inputSignal == null || "".equals(inputSignal) || predecessorID == null) continue;
            IClockElement predecessor = this.getClockElement(predecessorID);
            element.getDevice().setPredecessorID(predecessorID);
            if (predecessor != null) {
                this.connect(element, predecessor);
                continue;
            }
            if (this.isElementNotAvailable(predecessorID)) {
                notPairedElements.put(predecessorID, element.getID());
                config.setDisabledByDefault(element);
                element.getDevice().setPredecessorID(this.noClockElement.getID());
                this.connect(element, this.noClockElement);
                continue;
            }
            LOGGER.warning("No predeccessor found for element: " + element.getID());
        }
        this.reconnect(notPairedElements, elements);
        this.verifyConnections();
    }

    private void connectClockSelect(@NonNull IClockElement element) {
        ClockSelect clockSelect = (ClockSelect)element;
        Collection<@NonNull Object> inputs = clockSelect.getInputs();
        ArrayList<@NonNull String> branches = new ArrayList<String>();
        for (Object input : inputs) {
            String pred = UtilsText.safeString((String)input.toString());
            IClockElement predecessor = null;
            predecessor = this.noClockElement.getID().equals(pred) ? this.noClockElement : this.getClockElement(pred);
            if (predecessor != null) {
                this.connect(element, predecessor, branches);
                continue;
            }
            if (this.isElementNotAvailable(pred)) continue;
            LOGGER.warning(MessageFormat.format("No element has been found for clock selector {0} input branch named: {1}", element.getID(), pred));
        }
        clockSelect.setBranches(branches);
    }

    private void reconnect(@NonNull Map<@NonNull String, String> notPairedElements, @NonNull Map<@NonNull String, IClockElement> elements) {
        for (IClockElement element : elements.values()) {
            if (element.getDevice().getSuccessor() != null) continue;
            String outputSignal = "";
            for (Map.Entry<String, String> entry : this.notAvailableElements.entrySet()) {
                if (!entry.getValue().replaceAll("\\.clk", "").equals(element.getID())) continue;
                outputSignal = entry.getKey();
            }
            if (!notPairedElements.containsKey(outputSignal)) continue;
            String successor = notPairedElements.get(outputSignal);
            if (successor != null) {
                IClockElement successorElement = this.getClockElement(successor);
                if (successorElement == null) continue;
                this.connect(successorElement, element);
                continue;
            }
            LOGGER.severe("No succesor durring connection reconstruction for output signal: " + outputSignal);
        }
    }

    private void verifyConnections() {
        if (SWToolsProperties.isVerificationOn()) {
            for (IClockElement element : this.getAllElements().values()) {
                ModelCreationI device = element.getDevice();
                if (device.getSuccessor() == null && device.getSuccList() == null && !(element instanceof ClockOutput)) {
                    LOGGER.severe("Successor missing: " + element.getID());
                }
                if (device.getPredecessor() != null || device.getPredList() != null) continue;
                LOGGER.severe("Predecessor missing: " + element.getID());
            }
        }
    }

    private @NonNull String connect(@NonNull IClockElement element, @NonNull IClockElement predecessor, @Nullable List<@NonNull String> branches) {
        String predID = predecessor.getID();
        String successor = predecessor.getDevice().getSuccessor();
        predecessor.addSuccessor(element);
        element.addPredecessor(predecessor);
        if (successor == null) {
            predecessor.getDevice().setSuccessorID(element.getID());
        } else {
            Splitter splitter = predecessor.getSplitter();
            if (splitter == null) {
                String splitterID = String.valueOf(predID) + SPLITTER_SUFFIX;
                splitter = new Splitter(splitterID, predID);
                splitter.addSuccessor(successor);
                IClockElement clockElement = this.getClockElement(successor);
                if (clockElement instanceof ClockSelect) {
                    ((ClockSelect)clockElement).replaceBranch(predID, splitterID);
                }
                if (branches != null) {
                    Collections.replaceAll(branches, predID, splitterID);
                }
                predecessor.setSplitter(splitter);
            }
            predID = splitter.getID();
            splitter.addSuccessor(element.getID());
            element.getDevice().setPredecessorID(splitter.getID());
            predecessor.getDevice().setSuccessorID(splitter.getID());
        }
        if (branches != null) {
            branches.add(predID);
        }
        return predID;
    }

    private @NonNull String connect(@NonNull IClockElement element, @NonNull IClockElement predecessor) {
        return this.connect(element, predecessor, null);
    }

    @Override
    public String getPredecessorID(@NonNull String inputSignal) {
        String parsedSignal = inputSignal;
        while (parsedSignal != null && !UtilsText.isEmpty((String)parsedSignal)) {
            if (parsedSignal.endsWith(".clk")) {
                parsedSignal = parsedSignal.replaceAll(".clk$", "");
                break;
            }
            Pattern pattern = Pattern.compile(REGEX_CLOCK_OUTPUT);
            Matcher matcher = pattern.matcher(parsedSignal);
            if (matcher.find()) {
                String firsGroup = matcher.group(1);
                assert (firsGroup != null) : "Input not valid!";
                IClockComponent clockComponent = this.getClockComponent(firsGroup);
                if (clockComponent == null) break;
                parsedSignal = clockComponent.getOutputMapping().get(parsedSignal);
                continue;
            }
            return null;
        }
        return parsedSignal;
    }

    @Override
    public SettingsDB getSettings() {
        return this.settings;
    }

    @Override
    public @NonNull Map<@NonNull String, String> getOutputMapping() {
        return this.outputSignals;
    }

    @Override
    public @NonNull CompiledScript getCodeGeneratingScript() {
        return this.script;
    }

    @Override
    public @NonNull IClocksConfig getDefaultConfig() {
        return this.defaultClocksConfig;
    }

    private @NonNull ClocksConfig createDefaultClocksConfig() {
        ClocksConfig clocksConfig = new ClocksConfig(this.defaultSettingsConfig, this);
        return clocksConfig;
    }

    private @NonNull SettingsConfig createDefaultSettingsConfig() {
        SettingsConfig settingsConfig = new SettingsConfig();
        ClocksConfig config = new ClocksConfig(settingsConfig, this);
        for (AGlobalSetting aGlobalSetting : this.settings.getGlobalSettings()) {
            SettingValue defaultValue = aGlobalSetting.getDefaultValue(config);
            if (defaultValue != null) {
                settingsConfig.setSettingValue(aGlobalSetting, defaultValue);
            } else {
                settingsConfig.setSettingValue(aGlobalSetting, SettingValue.N_A);
            }
            if (!aGlobalSetting.isLockedByDefault()) continue;
            settingsConfig.lockSettingIfNotLocked(aGlobalSetting);
        }
        for (ClockSourceSetting clockSourceSetting : this.settings.getClockSources()) {
            List<SettingValue> values = clockSourceSetting.getValues(config);
            SettingValue value = SettingValue.FREQ_N_A;
            if (values == null) {
                if (clockSourceSetting.getDefaultValue(config) != null) {
                    value = clockSourceSetting.getDefaultValue(config);
                } else {
                    LOGGER.warning("No default value found for setting: " + clockSourceSetting.getId());
                }
            } else {
                value = !values.isEmpty() ? values.get(0) : SettingValue.FREQ_N_A;
            }
            assert (value != null);
            settingsConfig.setSettingValue(clockSourceSetting, value);
            if (!clockSourceSetting.isLockedByDefault()) continue;
            settingsConfig.lockSettingIfNotLocked(clockSourceSetting);
        }
        Mcu.createDefaultValues(config, this.settings.getGeneralSettings(), settingsConfig);
        Mcu.createDefaultValues(config, this.settings.getPowerModeSpecificSettings(), settingsConfig);
        Mcu.createDefaultValues(config, this.settings.getClockOutputs(), settingsConfig);
        return settingsConfig;
    }

    private static void createDefaultValues(@NonNull IClocksConfig clocksConfig, @NonNull Collection<? extends @NonNull ISetting> settings, @NonNull SettingsConfig settingsConfig) {
        for (ISetting iSetting : settings) {
            SettingValue defaultValue = iSetting.getDefaultValue(clocksConfig);
            if (defaultValue != null) {
                settingsConfig.setSettingValue(iSetting, defaultValue);
            } else {
                List<@NonNull SettingValue> values = iSetting.getValues(clocksConfig);
                if (values != null && !values.isEmpty()) {
                    settingsConfig.setSettingValue(iSetting, values.get(0));
                }
                LOGGER.warning("No default value found for setting: " + iSetting.getId());
            }
            if (!iSetting.isLockedByDefault()) continue;
            settingsConfig.lockSettingIfNotLocked(iSetting);
        }
    }

    @Override
    public @NonNull PeripheralComponentFile getPeripheralComponentFile() {
        return this.peripheralComponentFile;
    }

    @Override
    public @NonNull String getVersion() {
        return this.descriptor.getVersion();
    }

    @Override
    public @NonNull Collection<@NonNull String> getNotAvailableElements() {
        return CollectionsUtils.unmodifiableSet(this.notAvailableElements.keySet());
    }

    @Override
    public boolean isElementNotAvailable(@NonNull String elementID) {
        boolean elementAvailable = this.getNotAvailableElements().contains(elementID);
        boolean componentAvailable = this.getNotAvailableElements().contains(Text.getComponentID(elementID));
        return componentAvailable || elementAvailable;
    }

    @Override
    public @Nullable IClockElement getClockElementFromSplitter(@NonNull String splitterId) {
        String componentID = UtilsText.safeString((String)splitterId.replaceAll("\\..*", ""));
        IClockComponent parentComponent = this.getClockComponent(componentID);
        if (parentComponent != null) {
            for (IClockElement element : parentComponent.getElements()) {
                Splitter elemSplitter = element.getSplitter();
                if (elemSplitter == null || !splitterId.equals(elemSplitter.getID())) continue;
                return element;
            }
        } else {
            for (IClockElement element : this.mcuElements.values()) {
                Splitter elemSplitter = element.getSplitter();
                if (elemSplitter == null || !splitterId.equals(elemSplitter.getID())) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public @NonNull Collection<@NonNull IConfigElement> getGlobalConfigElements() {
        return this.mcuConfigElements;
    }

    @Override
    public @NonNull Collection<@NonNull IConfigElement> getAllGlobalConfigElements() {
        ArrayList<@NonNull IConfigElement> allConfigElements = new ArrayList<IConfigElement>(this.mcuConfigElements);
        for (IClockComponent component : this.components.values()) {
            allConfigElements.addAll(component.getGlobalConfigElements());
        }
        return allConfigElements;
    }

    @Override
    public @NonNull IClockElement getNoClockElement() {
        return this.noClockElement;
    }

    @Override
    public @Nullable AGlobalSetting getPowerModeSetting() {
        return this.powerModeSetting;
    }

    private @NonNull Collection<@NonNull Pin> findAllPins() {
        ArrayList<@NonNull Pin> result = new ArrayList<Pin>();
        Stream cs = CollectionsUtils.getInstancesOf(this.getAllElements().values(), ClockSource.class);
        cs.forEach(x -> {
            boolean bl = result.addAll(x.getPins());
        });
        return result;
    }

    private @NonNull IDirectedGraph createSettingDependencyGraph() {
        this.createSoftDisableConditions();
        SettingDependencyGraph dependencyGraph = new SettingDependencyGraph(this.settings);
        this.settings.getAllSettings().forEach(x -> {
            boolean bl = dependencyGraph.addNode(x.getId());
        });
        for (ISetting setting : this.settings.getAllSettings()) {
            setting.getDependencies(this).forEach(x -> {
                boolean bl = dependencyGraph.addEdge((String)x, setting.getId());
            });
            setting.getInfluencedSettings(this).forEach(x -> {
                boolean bl = dependencyGraph.addEdge(setting.getId(), (String)x);
            });
        }
        dependencyGraph.refreshRoots();
        if (SWToolsProperties.isVerificationOn()) {
            dependencyGraph.verifyBitFieldSettings();
        }
        return dependencyGraph;
    }

    private void createSoftDisableConditions() {
        for (ISetting setting : this.settings.getAllEnableSettings()) {
            EnableSetting enableSetting;
            if (!(setting instanceof EnableSetting) || !((enableSetting = (EnableSetting)setting).getElement() instanceof IClockElement)) continue;
            IClockElement element = (IClockElement)enableSetting.getElement();
            if (element instanceof ClockSelect) {
                Mcu.createSoftDisableConditionForSelector(element, enableSetting);
                continue;
            }
            for (IClockElement predecessorElement : element.getPredecessors()) {
                EnableSetting predecessorEnableSetting = predecessorElement.getEnableSetting();
                if (predecessorEnableSetting == null) continue;
                enableSetting.setSoftEnableCondition(Expression.create(predecessorEnableSetting.getId()));
            }
        }
    }

    private static void createSoftDisableConditionForSelector(@NonNull IClockElement element, @NonNull EnableSetting enableSetting) {
        StringBuilder expressionBuilder = new StringBuilder();
        for (IClockElement predecessorElement : element.getPredecessors()) {
            EnableSetting predecessorEnableSetting = predecessorElement.getEnableSetting();
            ISetting selectorSetting = element.getFrequencyModifierSetting();
            if (predecessorEnableSetting == null || selectorSetting == null) continue;
            Collection<@NonNull Object> values = ((ClockSelect)element).getInputs();
            String exprValue = null;
            for (Object inputObject : values) {
                String input = UtilsText.safeToString((Object)inputObject);
                if (!input.equals(predecessorElement.getID())) continue;
                exprValue = input;
            }
            if (UtilsText.isEmpty(exprValue)) continue;
            if (!expressionBuilder.toString().trim().isEmpty()) {
                expressionBuilder.append("||");
            }
            expressionBuilder.append(String.valueOf(selectorSetting.getId()) + "==" + "`" + exprValue + "`" + "&&" + predecessorEnableSetting.getId());
        }
        if (expressionBuilder.length() != 0) {
            enableSetting.setSoftEnableCondition(Expression.create(UtilsText.safeToString((Object)expressionBuilder)));
        } else {
            enableSetting.setSoftEnableCondition(Expression.EXPRESSION_TRUE);
        }
    }

    @Override
    public @NonNull IDirectedGraph getSettingDependencies() {
        return this.settingDependencyGraph;
    }

    private void addControlSetting(@NonNull String setting, @NonNull String controlSetting) {
        if (!setting.equals(controlSetting)) {
            Set<@NonNull String> controlSettings = new HashSet<String>();
            if (this.controlledSettings.containsKey(setting)) {
                controlSettings = Objects.requireNonNull(this.controlledSettings.get(setting));
            }
            controlSettings.add(controlSetting);
            this.controlledSettings.put(setting, controlSettings);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createControlledSettingsRelation() {
        for (ISetting setting : this.settings.getAllBitFieldSettings()) {
            Collection<@NonNull String> predecessors = this.settingDependencyGraph.getPredecessors(setting.getId());
            Collection<@NonNull String> successors = this.settingDependencyGraph.getSuccessors(setting.getId());
            @NonNull List bitFieldModifiers = (List)predecessors.stream().filter(successors::contains).collect(CollectorsUtils.toList());
            for (String modifier : bitFieldModifiers) {
                successors.forEach(x -> this.addControlSetting((String)x, modifier));
            }
        }
    }

    @Override
    public @Nullable Set<@NonNull String> getControlSettings(@NonNull String setting) {
        return this.controlledSettings.get(setting);
    }

    @Override
    public DiagramData getDiagramDataCopy() {
        ArrayList<@NonNull DiagramSymbol> copy = new ArrayList<DiagramSymbol>();
        this.diagramSymbols.forEach(x -> {
            boolean bl = copy.add(x.makeCopy());
        });
        return new DiagramData(copy, this);
    }

    @Override
    public @NonNull Collection<@NonNull Pin> getAllPins() {
        return this.pins;
    }
}

