/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.model.EDividerError;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.lang.ArraysUtils;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.stream.StreamsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class ErrorHelper {
    public static @Nullable String extractFrequencyErrorMessage(boolean isOnInput, @Nullable String minFreqText, @Nullable String maxFreqText) {
        if (minFreqText != null && maxFreqText != null) {
            if (minFreqText.equals(maxFreqText)) {
                String unformated = isOnInput ? Messages.get().ErrorHelper_InputFrequencyEquals : Messages.get().ErrorHelper_OutputFrequencyEquals;
                return MessageFormat.format(unformated, minFreqText);
            }
            String unformated = isOnInput ? Messages.get().ErrorHelper_InputFrequencyInRange : Messages.get().ErrorHelper_OutputFrequencyInRange;
            return MessageFormat.format(unformated, minFreqText, maxFreqText);
        }
        if (minFreqText != null) {
            String unformated = isOnInput ? Messages.get().ErrorHelper_InputFrequencyGreaterOrEqual : Messages.get().ErrorHelper_OutputFrequencyGreaterOrEqual;
            return MessageFormat.format(unformated, minFreqText);
        }
        if (maxFreqText != null) {
            String unformated = isOnInput ? Messages.get().ErrorHelper_InputFrequencyLowerOrEqual : Messages.get().ErrorHelper_OutputFrequencyLowerOrEqual;
            return MessageFormat.format(unformated, maxFreqText);
        }
        return null;
    }

    public static @Nullable String extractFrequencyErrorMessage(boolean isOnInput, @Nullable Frequency minFreq, @Nullable Frequency maxFreq, @Nullable BigRational accuracy) {
        String minFreqText = null;
        String maxFreqText = null;
        String accuracyText = "";
        if (accuracy != null) {
            accuracyText = Text.accuracyToPercent(accuracy);
        }
        if (minFreq != null) {
            minFreqText = FrequencyCalculator.normalize((Frequency)minFreq, (long)1L).toString();
            minFreqText = minFreqText.concat(accuracyText);
        }
        if (maxFreq != null) {
            maxFreqText = FrequencyCalculator.normalize((Frequency)maxFreq, (long)1L).toString();
            maxFreqText = maxFreqText.concat(accuracyText);
        }
        return ErrorHelper.extractFrequencyErrorMessage(isOnInput, minFreqText, maxFreqText);
    }

    public static @Nullable String extractFrequencyErrorMessage(boolean isOnInput, @Nullable BigRational minHertz, @Nullable BigRational maxHertz) {
        Frequency min = minHertz == null ? null : Converter.toFrequency(minHertz);
        Frequency max = maxHertz == null ? null : Converter.toFrequency(maxHertz);
        return ErrorHelper.extractFrequencyErrorMessage(isOnInput, min, max, null);
    }

    public static @NonNull String extractDivisionErrorMessage(EDividerError errorType, @NonNull Node device, @NonNull IMcu mcu, @NonNull IClocksConfig config, @Nullable ISetting setting) {
        String message = "";
        switch (errorType) {
            case MasterSlaveRatioInMaster: {
                message = Messages.get().ErrorHelper_WrongDivisionRatio;
                break;
            }
            case MasterSlaveRatioInSlave: {
                message = Messages.get().ErrorHelper_WrongDivisionRatio;
                break;
            }
            case RatioNotIntegralInMaster: {
                message = MessageFormat.format(Messages.get().ErrorHelper_MasterNotIntegerDivideOfSlaves, ErrorHelper.nodesToElementNames(device.getSlaveDividers(), mcu));
                break;
            }
            case RatioNotIntegralInSlave: {
                message = MessageFormat.format(Messages.get().ErrorHelper_SlaveNotIntegerDivideOfMaster, ErrorHelper.nodesToElementNames(device.getMasters(), mcu));
                break;
            }
            case ScaleOutOfRange: {
                String editorTooltip;
                message = Messages.get().ErrorHelper_ScaleOutOfRange;
                if (errorType != EDividerError.ScaleOutOfRange || setting == null || UtilsText.isEmpty((String)(editorTooltip = SettingEditorHelper.getEditorToolTip(setting, config)))) break;
                message = String.valueOf(message) + "\n" + editorTooltip;
                break;
            }
        }
        return UtilsText.safeString((String)message);
    }

    public static @NonNull String nodeToElementName(@Nullable Node node, @NonNull IMcu mcu) {
        if (node == null) {
            return "";
        }
        return ErrorHelper.elementsToString(ErrorHelper.nodeToElement(node, mcu));
    }

    public static @NonNull String nodesToElementNames(@NonNull Collection<? extends @NonNull Node> nodes, @NonNull IMcu mcu) {
        return ErrorHelper.elementsToString(ErrorHelper.nodesToElements(nodes, mcu));
    }

    public static @NonNull Stream<@Nullable IClockElement> nodeToElement(@NonNull Node node, @NonNull IMcu mcu) {
        return ErrorHelper.nodesToElements(StreamsUtils.streamOf((Object)node), mcu);
    }

    public static @NonNull Stream<@Nullable IClockElement> nodesToElements(@NonNull Collection<? extends @NonNull Node> nodes, @NonNull IMcu mcu) {
        return ErrorHelper.nodesToElements(StreamsUtils.safeStream(nodes), mcu);
    }

    public static @NonNull Stream<@Nullable IClockElement> nodesToElements(@NonNull Stream<? extends @NonNull Node> nodes, @NonNull IMcu mcu) {
        return StreamsUtils.safeStream(nodes.map(device -> mcu.getClockElement(device.getID())));
    }

    public static @NonNull String elementsToString(@NonNull Collection<? extends @Nullable IElement> elements) {
        return ErrorHelper.elementsToString(StreamsUtils.safeStream(elements.stream()));
    }

    public static @NonNull String elementsToString(@NonNull Stream<? extends @Nullable IElement> elements) {
        return Text.collectionToString((Collection)elements.filter(Objects::nonNull).map(IElement::getName).collect(CollectorsUtils.toList()));
    }

    public static @NonNull String elementsIdsToNames(@NonNull Collection<@NonNull String> elementsIds, @NonNull IMcu elementsMcu) {
        return ErrorHelper.elementsIdsToNames(StreamsUtils.safeStream(elementsIds), elementsMcu);
    }

    public static @NonNull String elementsIdsToNames(@NonNull Stream<@NonNull String> elementsIds, @NonNull IMcu elementsMcu) {
        return ErrorHelper.elementsToString(StreamsUtils.safeStream(elementsIds.map(id -> {
            IElement element = elementsMcu.getClockElement((String)id);
            if (element == null) {
                elementsMcu.getSettings().getAllConfigElementSettings();
                Optional<@NonNull ISetting> first = elementsMcu.getSettings().getAllConfigElementSettings().stream().filter(x -> x.getElement().getID().equals(id)).findFirst();
                ISetting setting = (ISetting)CollectionsUtils.nullableOptionalGet(first);
                if (setting != null) {
                    element = setting.getElement();
                }
            }
            return element;
        })));
    }

    public static void addErrorIfNotPresent(@NonNull String id, @NonNull String message, @NonNull Map<@NonNull String, String> errors) {
        String error = errors.get(id);
        if (error == null || UtilsText.isEmpty((String)error)) {
            error = message;
        } else {
            @NonNull Object @NonNull [] errorLines = error.split("\n");
            if (!ArraysUtils.contains((Object[])errorLines, (Object)message)) {
                error = String.valueOf(error) + "\n" + message;
            }
        }
        errors.put(id, error);
    }
}

