/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.ui.diagram.DiagramConnection;
import com.nxp.swtools.clocks.ui.diagram.Junction;
import com.nxp.swtools.clocks.ui.diagramsymbols.CompositeSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.InvisibleConnectionSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.Wire;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DiagramData {
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mTopLevelSymbols = new HashSet<DiagramSymbol>();
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mAllSymbols = new HashSet<DiagramSymbol>();
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mSymbolsWithElement;
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mSymbolsWithPin;
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mSymbolsUnavailable;
    @NonNull
    @NonNull Collection<@NonNull DiagramSymbol> mSymbolsDiagramOnly;
    @NonNull
    @NonNull Map<@NonNull String, @NonNull DiagramConnection> mConnections = new HashMap<String, DiagramConnection>();
    public static final double ALLOWED_DISTANCE = 0.01;

    public DiagramData(@NonNull Collection<@NonNull DiagramSymbol> diagramSymbols, @NonNull IMcu mcu) {
        this();
        this.mAllSymbols = diagramSymbols;
        this.mTopLevelSymbols = this.computeHierarchy();
        this.mConnections = this.computeConnections();
        ArrayList<@NonNull E> tmp = new ArrayList();
        this.mAllSymbols.forEach(x -> {
            IClockElement element = mcu.getClockElement(x.getId());
            if (element != null) {
                if (element instanceof ClockOutput) {
                    tmp.add(x);
                } else {
                    this.mSymbolsWithElement.add((DiagramSymbol)x);
                }
                return;
            }
            boolean isUnavailable = mcu.isElementNotAvailable(x.getId());
            if (isUnavailable) {
                this.mSymbolsUnavailable.add((DiagramSymbol)x);
                return;
            }
            for (Pin p : mcu.getAllPins()) {
                if (!x.getId().equals(p.getID())) continue;
                this.mSymbolsWithPin.add((DiagramSymbol)x);
                return;
            }
            if (x.isDiagramOnly() && !x.getId().equals("Wires") && !x.getId().equals("Junctions")) {
                this.mSymbolsDiagramOnly.add((DiagramSymbol)x);
            }
        });
        this.mSymbolsWithElement.addAll(tmp);
    }

    public DiagramData() {
        this.mSymbolsWithElement = new ArrayList<DiagramSymbol>();
        this.mSymbolsWithPin = new ArrayList<DiagramSymbol>();
        this.mSymbolsUnavailable = new ArrayList<DiagramSymbol>();
        this.mSymbolsDiagramOnly = new ArrayList<DiagramSymbol>();
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getTopLevelSymbols() {
        return this.mTopLevelSymbols;
    }

    public static void removeUnwantedJunctions(double allowedDistance, @NonNull Collection<@NonNull DiagramSymbol> symbols) {
        DiagramSymbol junctionSymbol = symbols.stream().filter(x -> x.getId().equals("Junctions")).findFirst().orElse(new CompositeSymbol("", false, false, false));
        Collection junctions = CollectionsUtils.getInstancesOf(junctionSymbol.getGraphElems(), Junction.class).collect(Collectors.toList());
        Collection teleports = CollectionsUtils.getInstancesOf(symbols, InvisibleConnectionSymbol.class).collect(Collectors.toList());
        ArrayList toRemove = new ArrayList();
        teleports.forEach(x -> {
            com.nxp.swtools.clocks.ui.diagramsymbols.Pin p = x.getInputPin();
            toRemove.addAll(junctions.stream().filter(y -> y.getPosition().distance(p.getStartDS()) <= allowedDistance || y.getPosition().distance(p.getEndDS()) <= allowedDistance).collect(Collectors.toList()));
        });
        junctionSymbol.getGraphElems().removeAll(toRemove);
    }

    private @NonNull List<@NonNull DiagramSymbol> computeHierarchy() {
        List<@NonNull T> boundaries = CollectionsUtils.getInstancesOf(this.mAllSymbols, CompositeSymbol.class).filter(CompositeSymbol::definesBoundary).collect(Collectors.toList());
        ArrayList<@NonNull DiagramSymbol> result = new ArrayList<DiagramSymbol>(this.mAllSymbols);
        for (CompositeSymbol cs : boundaries) {
            for (DiagramSymbol s : this.mAllSymbols) {
                if (cs.equals(s) || boundaries.contains(s) || !cs.isSurrounding(s)) continue;
                cs.addPart(s);
                s.setParent(cs);
                result.remove(s);
            }
        }
        return result;
    }

    private @NonNull Map<@NonNull String, @NonNull DiagramConnection> computeConnections() {
        HashMap<@NonNull String, @NonNull DiagramConnection> connections = new HashMap<String, DiagramConnection>();
        HashMap<com.nxp.swtools.clocks.ui.diagramsymbols.Pin, DiagramSymbol> elements = new HashMap<com.nxp.swtools.clocks.ui.diagramsymbols.Pin, DiagramSymbol>();
        ArrayList<@NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin> outPins = new ArrayList<com.nxp.swtools.clocks.ui.diagramsymbols.Pin>();
        ArrayList<@NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin> inPins = new ArrayList<com.nxp.swtools.clocks.ui.diagramsymbols.Pin>();
        for (DiagramSymbol symbol : this.mAllSymbols) {
            for (GraphicalElement element : symbol.getGraphElems()) {
                if (!(element instanceof com.nxp.swtools.clocks.ui.diagramsymbols.Pin)) continue;
                com.nxp.swtools.clocks.ui.diagramsymbols.Pin pin = (com.nxp.swtools.clocks.ui.diagramsymbols.Pin)element;
                if (pin.isInput()) {
                    inPins.add(pin);
                } else {
                    outPins.add(pin);
                }
                elements.put(pin, symbol);
            }
        }
        Collection<Wire> wires = this.getWires();
        for (com.nxp.swtools.clocks.ui.diagramsymbols.Pin pin : outPins) {
            Collection<DiagramConnection> pinConnections = this.findConnections(inPins, wires, pin, elements);
            for (DiagramConnection pinConnection : pinConnections) {
                connections.put(pinConnection.getId(), pinConnection);
            }
        }
        return connections;
    }

    private @NonNull Collection<Wire> getWires() {
        return (Collection)this.mAllSymbols.stream().flatMap(x -> x.getGraphElems().stream().filter(y -> y instanceof Wire).map(Wire.class::cast)).collect(CollectorsUtils.toList());
    }

    private @NonNull Collection<DiagramConnection> findConnections(@NonNull Collection<com.nxp.swtools.clocks.ui.diagramsymbols.Pin> inputPins, @NonNull Collection<Wire> wires, @NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin outputPin, @NonNull Map<com.nxp.swtools.clocks.ui.diagramsymbols.Pin, DiagramSymbol> elements) {
        DiagramSymbol outElement = elements.get(outputPin);
        assert (outElement != null);
        DiagramConnection connection = new DiagramConnection(outputPin, outElement);
        Collection<DiagramConnection> result = this.updateConnection(inputPins, wires, outputPin.getEndDS(), connection, elements);
        if (result.isEmpty()) {
            result = this.updateConnection(inputPins, wires, outputPin.getStartDS(), connection, elements);
        }
        return result;
    }

    private @NonNull Collection<DiagramConnection> updateConnection(@NonNull Collection<com.nxp.swtools.clocks.ui.diagramsymbols.Pin> inputPins, @NonNull Collection<Wire> wires, @NonNull Point2D point, @NonNull DiagramConnection connection, @NonNull Map<com.nxp.swtools.clocks.ui.diagramsymbols.Pin, DiagramSymbol> elements) {
        ArrayList<DiagramConnection> result = new ArrayList<DiagramConnection>();
        List<Wire> matchingWires = DiagramData.getMatchingWires(point, wires);
        List<com.nxp.swtools.clocks.ui.diagramsymbols.Pin> matchingInputPins = DiagramData.getMatchingPins(point, inputPins);
        wires.removeAll(matchingWires);
        inputPins.removeAll(matchingInputPins);
        int elementsToInspect = matchingWires.size() + matchingInputPins.size();
        for (Wire wire : matchingWires) {
            Point2D nextPoint = wire.getEndDS().distance(point) < wire.getStartDS().distance(point) ? wire.getStartDS() : wire.getEndDS();
            DiagramConnection connectionCopy = elementsToInspect <= 1 ? connection : connection.makeCopy();
            connectionCopy.getWires().add(wire);
            result.addAll(this.updateConnection(inputPins, wires, nextPoint, connectionCopy, elements));
            --elementsToInspect;
        }
        for (com.nxp.swtools.clocks.ui.diagramsymbols.Pin pin : matchingInputPins) {
            connection.setSuccessorPin(pin);
            DiagramSymbol inElement = elements.get(pin);
            assert (inElement != null);
            connection.setSuccessor(inElement);
            result.add(elementsToInspect <= 1 ? connection : connection.makeCopy());
            --elementsToInspect;
        }
        return result;
    }

    protected static @NonNull List<@NonNull Wire> getMatchingWires(@NonNull Point2D point, @NonNull Collection<Wire> wires) {
        ArrayList<@NonNull Wire> matchingWires = new ArrayList<Wire>();
        for (Wire wire : wires) {
            if (!(wire.getEndDS().distance(point) <= 0.01) && !(wire.getStartDS().distance(point) <= 0.01)) continue;
            matchingWires.add(wire);
        }
        return matchingWires;
    }

    protected static @NonNull List<@NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin> getMatchingPins(@NonNull Point2D point, @NonNull Collection<com.nxp.swtools.clocks.ui.diagramsymbols.Pin> pins) {
        ArrayList<@NonNull com.nxp.swtools.clocks.ui.diagramsymbols.Pin> matchingPins = new ArrayList<com.nxp.swtools.clocks.ui.diagramsymbols.Pin>();
        for (com.nxp.swtools.clocks.ui.diagramsymbols.Pin pin : pins) {
            if (!(pin.getEndDS().distance(point) <= 0.01) && !(pin.getStartDS().distance(point) <= 0.01)) continue;
            matchingPins.add(pin);
        }
        return matchingPins;
    }

    public @Nullable DiagramConnection getConnection(@NonNull String fromId, @NonNull String toId) {
        return this.mConnections.get(DiagramConnection.createConnectionID(fromId, toId));
    }

    public @NonNull Stream<@NonNull DiagramConnection> getConnections(@NonNull String fromId) {
        return this.mConnections.values().stream().filter(x -> x.getPredecessor().getId().equals(fromId));
    }

    public @NonNull Collection<@NonNull DiagramConnection> getAllConnections() {
        return this.mConnections.values();
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getAllSymbols() {
        return this.mAllSymbols;
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getSymbolsWithElement() {
        return this.mSymbolsWithElement;
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getSymbolsWithPin() {
        return this.mSymbolsWithPin;
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getSymbolsUnavailable() {
        return this.mSymbolsUnavailable;
    }

    public @NonNull Collection<@NonNull DiagramSymbol> getSymbolsDiagramOnly() {
        return this.mSymbolsDiagramOnly;
    }
}

