/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.application;

import com.nxp.swtools.clocks.wizards.exportWizard.ExportClocksHtmlReport;
import com.nxp.swtools.clocks.wizards.exportWizard.ExportClocksSourcesWizard;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.cmd.CmdSection;
import com.nxp.swtools.common.utils.cmd.ICmdApplication;
import com.nxp.swtools.common.utils.files.FileAccessFactory;
import com.nxp.swtools.common.utils.files.IAbstractFileAccess;
import com.nxp.swtools.common.utils.lang.MethodAndInstance;
import com.nxp.swtools.common.utils.lang.ReflectionUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.configuration.sources.IDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.SimpleDestinationPathProvider;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import com.nxp.swtools.utils.wizards.exportWizard.ExportUtils;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class CmdApplication
implements ICmdApplication {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(CmdApplication.class);
    @NonNull
    private static final String INTERNAL_BUNDLE_NAME = "com.nxp.swtools.clocks.internal_development";
    @NonNull
    private static final String TEST_DATA_GENERATOR_CLASS = "TestConfigGenerator";
    @NonNull
    private static final String HANDLER_PACKAGE_NAME = "handlers";
    @NonNull
    private static final String TEST_DATA_GENERATOR_METHOD = "generateTestConfigurations";

    public boolean run(@NonNull CmdSection cmdSection) {
        boolean result = true;
        Set keys = cmdSection.cmdMap.keySet();
        for (String key : keys) {
            String path;
            if (key.equals("-ExportAll") && !(path = cmdSection.getOptionValue("-ExportAll")).isEmpty()) {
                result &= CmdApplication.exportSources(path, false);
                result &= CmdApplication.exportHTML(path);
            }
            if (key.equals("-ExportSrc") && !(path = cmdSection.getOptionValue("-ExportSrc")).isEmpty()) {
                result &= CmdApplication.exportSources(path, false);
            }
            if (key.equals("-ExportMcuTemplate") && !(path = cmdSection.getOptionValue("-ExportMcuTemplate")).isEmpty()) {
                result &= CmdApplication.exportSources(path, true);
            }
            if (key.equals("-ExportHTML") && !(path = cmdSection.getOptionValue("-ExportHTML")).isEmpty()) {
                result &= CmdApplication.exportHTML(path);
            }
            if (!key.equals("-GenerateTestConfigs") || (path = cmdSection.getOptionValue("-GenerateTestConfigs")).isEmpty()) continue;
            Bundle bundle = Platform.getBundle((String)INTERNAL_BUNDLE_NAME);
            if (bundle == null) {
                result = true;
                LOGGER.log(Level.SEVERE, "Unable to get bundle: com.nxp.swtools.clocks.internal_development");
                result = false;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(INTERNAL_BUNDLE_NAME);
            stringBuilder.append(".");
            stringBuilder.append(HANDLER_PACKAGE_NAME);
            stringBuilder.append(".");
            stringBuilder.append(TEST_DATA_GENERATOR_CLASS);
            MethodAndInstance methodAndInstance = ReflectionUtils.getMethodAndInstance((Bundle)bundle, (String)stringBuilder.toString(), (String)TEST_DATA_GENERATOR_METHOD, (Class[])new Class[]{String.class});
            if (methodAndInstance == null) {
                result = false;
                continue;
            }
            try {
                methodAndInstance.getMethod().invoke(methodAndInstance.getInstance(), path);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, "Unable to invoke instance of " + methodAndInstance.getMethod().getName(), e.getMessage());
                result = false;
            }
        }
        return result;
    }

    private static boolean exportSources(@NonNull String path, boolean template) {
        return ExportClocksSourcesWizard.generateSourcesToFolder((IDestinationPathProvider)new SimpleDestinationPathProvider(Paths.get(path, new String[0])), FileAccessFactory.getFileSystemAccess(), template) != null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean exportHTML(@NonNull String path) {
        AExportWizard.GenerationResult result = ExportClocksHtmlReport.generateReport();
        if (result.wasSuccessful) {
            @NonNull @NonNull Map report = result.generatedFiles;
            assert (report != null);
            return ExportUtils.exportToFolder((IDestinationPathProvider)new SimpleDestinationPathProvider(Paths.get(path, new String[0])), (Map)report, (IAbstractFileAccess)FileAccessFactory.getFileSystemAccess(), (String)KEPreferences.getLineEnding(), null, (boolean)false);
        }
        return false;
    }
}

